/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.MapMessage;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.HashKeyEnumeration;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageFormatException;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.TypeConverter;

public final class MapMessageImpl
extends MessageImpl
implements MapMessage,
Externalizable {
    private static final byte EXTVERSION = 1;
    static final long serialVersionUID = -3363325517439700010L;
    HashMap hashMap;
    private byte[] payload;
    private PeerInfo peerInfo;

    public MapMessageImpl() {
        this.peerInfo = PeerInfo.getPeerInfo();
    }

    public MapMessageImpl(MapMessage mapMessage) throws javax.jms.JMSException {
        this(mapMessage, (Destination)null, (Destination)null);
    }

    public MapMessageImpl(MapMessage mapMessage, Destination destination, Destination destination2) throws javax.jms.JMSException {
        super(mapMessage, destination, destination2);
        Enumeration enumeration = mapMessage.getMapNames();
        if (enumeration.hasMoreElements()) {
            this.hashMap = new HashMap();
            do {
                String string = (String)enumeration.nextElement();
                this.hashMap.put(string, mapMessage.getObject(string));
            } while (enumeration.hasMoreElements());
        }
        this.peerInfo = PeerInfo.getPeerInfo();
    }

    public byte getType() {
        return 3;
    }

    public boolean getBoolean(String string) throws javax.jms.JMSException {
        return TypeConverter.toBoolean(this.getObject(string));
    }

    public byte getByte(String string) throws javax.jms.JMSException {
        return TypeConverter.toByte(this.getObject(string));
    }

    public byte[] getBytes(String string) throws javax.jms.JMSException {
        return TypeConverter.toByteArray(this.getObject(string));
    }

    public char getChar(String string) throws javax.jms.JMSException {
        return TypeConverter.toChar(this.getObject(string));
    }

    public double getDouble(String string) throws javax.jms.JMSException {
        return TypeConverter.toDouble(this.getObject(string));
    }

    public float getFloat(String string) throws javax.jms.JMSException {
        return TypeConverter.toFloat(this.getObject(string));
    }

    public short getShort(String string) throws javax.jms.JMSException {
        return TypeConverter.toShort(this.getObject(string));
    }

    public int getInt(String string) throws javax.jms.JMSException {
        return TypeConverter.toInt(this.getObject(string));
    }

    public long getLong(String string) throws javax.jms.JMSException {
        return TypeConverter.toLong(this.getObject(string));
    }

    public String getString(String string) throws javax.jms.JMSException {
        return TypeConverter.toString(this.getObject(string));
    }

    public Object getObject(String string) throws javax.jms.JMSException {
        return this.getHashMap().get(string);
    }

    public Enumeration getMapNames() throws javax.jms.JMSException {
        return new HashKeyEnumeration(this.getHashMap());
    }

    public void setBoolean(String string, boolean bl) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Boolean(bl));
    }

    public void setByte(String string, byte by) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Byte(by));
    }

    public void setBytes(String string, byte[] byArray) throws javax.jms.JMSException {
        this.setObjectInternal(string, byArray);
    }

    public void setBytes(String string, byte[] byArray, int n, int n2) throws javax.jms.JMSException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.setObjectInternal(string, byArray2);
    }

    public void setChar(String string, char c) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Character(c));
    }

    public void setDouble(String string, double d) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Double(d));
    }

    public void setFloat(String string, float f) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Float(f));
    }

    public void setInt(String string, int n) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Integer(n));
    }

    public void setLong(String string, long l) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Long(l));
    }

    public void setObject(String string, Object object) throws javax.jms.JMSException {
        if (!(object instanceof Number || object instanceof String || object instanceof Boolean || object instanceof byte[] || object instanceof Character || object == null)) {
            throw new MessageFormatException("Invalid data type, " + object.getClass().getName());
        }
        this.setObjectInternal(string, object);
    }

    public void setShort(String string, short s) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Short(s));
    }

    public void setString(String string, String string2) throws javax.jms.JMSException {
        this.setObjectInternal(string, string2);
    }

    private void setObjectInternal(String string, Object object) throws javax.jms.JMSException {
        this.writeMode();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Illegal name, '" + string + "'");
        }
        this.getHashMap().put(string, object);
    }

    public boolean itemExists(String string) throws javax.jms.JMSException {
        return this.getHashMap().containsKey(string);
    }

    public void nullBody() {
        this.payload = null;
        this.hashMap = null;
    }

    public String toString() {
        return "MapMessage[" + this.getJMSMessageID() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        byte[] byArray;
        super.writeExternal(objectOutput);
        objectOutput.writeByte(1);
        PeerInfo peerInfo = objectOutput instanceof PeerInfoable ? ((PeerInfoable)((Object)objectOutput)).getPeerInfo() : PeerInfo.getPeerInfo();
        MapMessageImpl mapMessageImpl = this;
        synchronized (mapMessageImpl) {
            byArray = this.getPayload(peerInfo);
            if (this.payload == null) {
                this.payload = byArray;
                this.peerInfo = peerInfo;
                this.hashMap = null;
            }
        }
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        PeerInfo peerInfo;
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        this.peerInfo = PeerInfo.getPeerInfo();
        if (objectInput instanceof PeerInfoable && (peerInfo = ((PeerInfoable)((Object)objectInput)).getPeerInfo()).compareTo(this.peerInfo) < 0) {
            this.peerInfo = peerInfo;
        }
        this.payload = new byte[objectInput.readInt()];
        objectInput.readFully(this.payload);
    }

    public MessageImpl copy() throws javax.jms.JMSException {
        MapMessageImpl mapMessageImpl = new MapMessageImpl();
        this.copy(mapMessageImpl);
        try {
            mapMessageImpl.peerInfo = PeerInfo.getPeerInfo();
            mapMessageImpl.payload = this.getPayload(mapMessageImpl.peerInfo);
        }
        catch (IOException iOException) {
            throw new JMSException("Error copying message", iOException);
        }
        mapMessageImpl.setBodyWritable(false);
        return mapMessageImpl;
    }

    public long getPayloadSize() {
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        this.bodySize = this.payload == null ? 0L : (long)this.payload.length;
        return this.bodySize;
    }

    private HashMap getHashMap() throws javax.jms.JMSException {
        if (this.hashMap != null) {
            return this.hashMap;
        }
        if (this.payload == null) {
            this.hashMap = new HashMap();
        } else {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.payload);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                this.hashMap = JMSUtilities.readBasicMap(objectInputStream, this.peerInfo);
            }
            catch (IOException iOException) {
                throw new JMSException("Error deserializing message", iOException);
            }
        }
        this.payload = null;
        return this.hashMap;
    }

    private byte[] getPayload(PeerInfo peerInfo) throws IOException {
        Closeable closeable;
        Closeable closeable2;
        HashMap hashMap = this.hashMap;
        if (this.payload != null) {
            if (this.peerInfo != null && this.peerInfo.equals(peerInfo)) {
                return this.payload;
            }
            closeable2 = new ByteArrayInputStream(this.payload);
            closeable = new ObjectInputStream((InputStream)closeable2);
            hashMap = JMSUtilities.readBasicMap((ObjectInput)((Object)closeable), this.peerInfo);
        } else if (hashMap == null) {
            hashMap = new HashMap();
        }
        closeable2 = new ByteArrayOutputStream();
        closeable = new ObjectOutputStream((OutputStream)closeable2);
        JMSUtilities.writeBasicMap((ObjectOutput)((Object)closeable), hashMap, peerInfo, true);
        ((ObjectOutputStream)closeable).flush();
        return ((ByteArrayOutputStream)closeable2).toByteArray();
    }
}

