/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.Message;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSLogger;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.Counter;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.HashKeyEnumeration;
import weblogic.jms.common.HdrMessageImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSOutputStream;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MapMessageImpl;
import weblogic.jms.common.MessageFormatException;
import weblogic.jms.common.MessageNotReadableException;
import weblogic.jms.common.MessageNotWriteableException;
import weblogic.jms.common.MessageReference;
import weblogic.jms.common.MessageTime;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.PutBackable;
import weblogic.jms.common.StreamMessageImpl;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.common.TypeConverter;
import weblogic.jms.common.XMLMessageImpl;
import weblogic.jms.extensions.WLMessage;
import weblogic.utils.expressions.ExpressionMap;

public abstract class MessageImpl
implements Message,
WLMessage,
ExpressionMap,
Cloneable,
Externalizable {
    static final long serialVersionUID = 7571220996297716034L;
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 10;
    private static final byte EXTVERSION3 = 20;
    private int deliveryMode = 1;
    private transient int adjustedDeliveryMode = 1;
    private boolean redelivered;
    private long expiration;
    private long deliveryTime;
    private int redeliveryLimit = -1;
    private byte priority;
    private int userdatalen = -1;
    protected transient long bodySize = -1L;
    private boolean clientResponsibleForAcknowledge = false;
    private transient long sequenceNumber;
    protected transient boolean bodyWritable = true;
    protected transient boolean propertiesWritable = true;
    private boolean serializeDestination = true;
    private boolean forwarded;
    private transient int pagedState;
    public static final int PAGED_IN = 0;
    public static final int PAGING_OUT = 2;
    public static final int PAGED_OUT = 3;
    public static final int PAGING_IN = 5;
    private transient Counter expirationReported = new Counter(0);
    private String correlationId;
    private DestinationImpl destination;
    private DestinationImpl writeDestination;
    private DestinationImpl replyTo;
    private String type;
    private HashMap properties;
    private MessageTime messageTime = new MessageTime();
    static final byte NULLMESSAGEIMPL = 0;
    static final byte BYTESMESSAGEIMPL = 1;
    static final byte HDRMESSAGEIMPL = 2;
    static final byte MAPMESSAGEIMPL = 3;
    static final byte OBJECTMESSAGEIMPL = 4;
    static final byte STREAMMESSAGEIMPL = 5;
    static final byte TEXTMESSAGEIMPL = 6;
    static final byte XMLMESSAGEIMPL = 7;
    private transient Counter topicReferenceCount = new Counter(0);
    private transient MessageImpl commonPagedOutMessage;
    private transient Object durableState;
    private Externalizable bexaXid;
    private int recoverCount = 0;
    private JMSMessageId messageId;
    private JMSID connectionId;
    private String messageIdString;
    private transient JMSSession session;
    private transient Object pagingState;
    private transient MessageReference mRef;
    private static final int _PRIORITYMASK = 15;
    private static final int _PRIORITYSHIFT = 0;
    private static final int _FORWARDED = 128;
    private static final int _HASREDELIVERYLIMIT = 256;
    private static final int _ISPERSISTENT = 512;
    private static final int _HASCORRID = 1024;
    private static final int _HASDESTINATION = 2048;
    private static final int _HASREPLYTO = 4096;
    private static final int _ISREDELIVERED = 8192;
    private static final int _HASTYPE = 16384;
    private static final int _HASEXPIRATION = 32768;
    private static final int _HASPROPERTIES = 65536;
    private static final int _HASXID = 131072;
    private static final int _HASMESSAGEID = 262144;
    private static final int _HASUSERDATALEN = 524288;
    private static final int _HASDELIVERYTIME = 0x100000;
    private static final int _SERIALIZEDEST = 0x200000;
    private static final int _CLIENTRESPONSIBLEFORACKNOWLEDGE = 0x400000;
    private static final int _RESERVEDEXTENSION1 = 0x800000;
    private static final int _VERSIONMASK = -16777216;
    private static final int _VERSIONSHIFT = 24;
    private static final int _DESTINATIONMASK = 7;
    private static final int _REPLYTODESTINATIONMASK = 56;
    private static final int _REPLYTODESTINATIONSHIFT = 3;
    private static final int _RESERVEDEXTENSION2 = 128;

    public MessageTime getMessageTime() {
        return this.messageTime;
    }

    public void incRecoverCount() {
        ++this.recoverCount;
    }

    public int getRecoverCount() {
        return this.recoverCount;
    }

    public MessageImpl() {
    }

    public int getPagedState() {
        return this.pagedState;
    }

    public void setPagedState(int n) {
        this.pagedState = n;
    }

    public abstract byte getType();

    public static MessageImpl createMessageImpl(byte by) throws IOException {
        switch (by) {
            case 1: {
                return new BytesMessageImpl();
            }
            case 2: {
                return new HdrMessageImpl();
            }
            case 3: {
                return new MapMessageImpl();
            }
            case 4: {
                return new ObjectMessageImpl();
            }
            case 5: {
                return new StreamMessageImpl();
            }
            case 6: {
                return new TextMessageImpl();
            }
            case 7: {
                return new XMLMessageImpl();
            }
        }
        throw new IOException("Internal error, unknown message type " + by);
    }

    public MessageImpl(Message message) throws javax.jms.JMSException {
        this(message, null, null);
    }

    public MessageImpl(Message message, javax.jms.Destination destination, javax.jms.Destination destination2) throws javax.jms.JMSException {
        this();
        this.setJMSCorrelationID(message.getJMSCorrelationID());
        this.setJMSType(message.getJMSType());
        if (destination2 == null) {
            this.setJMSReplyTo(message.getJMSReplyTo());
        } else {
            this.setJMSReplyTo(destination2);
        }
        this.userdatalen = 0;
        if (this.correlationId != null) {
            this.userdatalen = this.correlationId.length();
        }
        if (this.type != null) {
            this.userdatalen += this.type.length();
        }
        if (destination == null) {
            this.setJMSDestination(message.getJMSDestination());
        } else {
            this.setJMSDestination(destination);
        }
        this.setJMSRedelivered(message.getJMSRedelivered());
        this.setJMSExpiration(message.getJMSExpiration());
        if (message instanceof WLMessage) {
            this.setJMSPriority(message.getJMSPriority());
            this.setJMSDeliveryMode(message.getJMSDeliveryMode());
            this.setJMSDeliveryTime(((WLMessage)message).getJMSDeliveryTime());
            this.setJMSRedeliveryLimit(((WLMessage)message).getJMSRedeliveryLimit());
        }
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = message.getObjectProperty(string);
            this.userdatalen += 4 + (string.length() << 2);
            this.userdatalen += JMSUtilities.calcObjectSize(object);
            this.setObjectProperty(string, object);
        }
    }

    private void copyToMessageReference() {
        if (this.mRef == null) {
            return;
        }
        try {
            MessageImpl messageImpl = this.copy();
            this.mRef.setMessage(messageImpl);
        }
        catch (javax.jms.JMSException jMSException) {
            JMSLogger.logStackTrace(jMSException);
        }
        this.mRef = null;
    }

    public String getJMSMessageID() {
        if (this.messageIdString == null && this.messageId != null) {
            this.messageIdString = (this.deliveryMode == 1 ? "ID:N" : "ID:P") + this.messageId;
        }
        return this.messageIdString;
    }

    public void setJMSMessageID(String string) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.messageIdString = string;
    }

    public long getJMSTimestamp() {
        if (this.messageId != null) {
            return this.messageId.getTimestamp();
        }
        return 0L;
    }

    public void setJMSTimestamp(long l) {
    }

    public byte[] getJMSCorrelationIDAsBytes() throws javax.jms.JMSException {
        if (this.correlationId == null) {
            return null;
        }
        byte[] byArray = new byte[this.correlationId.length()];
        try {
            byArray = this.correlationId.getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        try {
            if (byArray == null) {
                this.setJMSCorrelationID(null);
            } else {
                this.setJMSCorrelationID(new String(byArray, "UTF-16BE"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setJMSCorrelationID(String string) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.correlationId = string;
    }

    public String getJMSCorrelationID() {
        return this.correlationId;
    }

    public javax.jms.Destination getJMSReplyTo() {
        return this.replyTo;
    }

    public void setJMSReplyTo(javax.jms.Destination destination) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.replyTo = destination == null || destination instanceof DestinationImpl ? (DestinationImpl)destination : (DestinationImpl)null;
    }

    public javax.jms.Destination getJMSDestination() {
        return this.destination;
    }

    public DestinationImpl getDestination() {
        return this.destination;
    }

    public void setJMSDestination(javax.jms.Destination destination) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.destination = destination == null || destination instanceof DestinationImpl ? (DestinationImpl)destination : (DestinationImpl)null;
    }

    public void setJMSDestinationImpl(DestinationImpl destinationImpl) {
        this.destination = destinationImpl;
    }

    public int getJMSDeliveryMode() {
        return this.deliveryMode;
    }

    public void setJMSDeliveryMode(int n) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        if (n != 2 && n != 1) {
            throw new JMSException("Invalid delivery mode, " + n);
        }
        this.deliveryMode = n;
        this.adjustedDeliveryMode = this.deliveryMode;
    }

    public int getAdjustedDeliveryMode() {
        return this.adjustedDeliveryMode;
    }

    public void setAdjustedDeliveryMode(int n) {
        this.adjustedDeliveryMode = n;
    }

    public void setDeliveryMode(int n) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.deliveryMode = n;
        this.adjustedDeliveryMode = n;
    }

    public boolean getJMSRedelivered() {
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean bl) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.redelivered = bl;
    }

    public void setRedelivered(boolean bl) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.redelivered = bl;
    }

    public void setClientResponsibleForAcknowledge(boolean bl) {
        this.clientResponsibleForAcknowledge = bl;
    }

    public boolean getClientResponsibleForAcknowledge() {
        return this.clientResponsibleForAcknowledge;
    }

    public String getJMSType() {
        return this.type;
    }

    public void setJMSType(String string) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.type = string;
    }

    public long getJMSExpiration() {
        return this.expiration;
    }

    public void setJMSExpiration(long l) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.expiration = l;
    }

    public void _setJMSExpiration(long l) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.expiration = l;
    }

    public void setJMSDeliveryTime(long l) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.deliveryTime = l;
    }

    public void setDeliveryTime(long l) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.deliveryTime = l;
    }

    public long getJMSDeliveryTime() throws javax.jms.JMSException {
        return this.deliveryTime;
    }

    public long getDeliveryTime() {
        return this.deliveryTime;
    }

    public void setJMSRedeliveryLimit(int n) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        if (n < -1) {
            throw new JMSException("Invalid redelivery limit, must be >= -1");
        }
        this.redeliveryLimit = n;
    }

    public void _setJMSRedeliveryLimit(int n) {
        this.redeliveryLimit = n;
    }

    public int getJMSRedeliveryLimit() throws javax.jms.JMSException {
        return this.redeliveryLimit;
    }

    public int _getJMSRedeliveryLimit() {
        return this.redeliveryLimit;
    }

    public int getJMSPriority() {
        return this.priority;
    }

    public void setJMSPriority(int n) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        if (n >= 0 && n <= 9) {
            this.priority = (byte)n;
        } else if (n == -1) {
            this.priority = (byte)4;
        } else {
            throw new JMSException("Invalid priority, " + n);
        }
    }

    public void _setJMSPriority(int n) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.priority = n >= 0 && n <= 9 ? (byte)n : (byte)4;
    }

    public void setMessageReference(MessageReference messageReference) {
        this.mRef = messageReference;
    }

    public void clearHeader() {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.commonPagedOutMessage = null;
        this.durableState = null;
        this.pagingState = null;
    }

    public void clearProperties() {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.propertiesWritable = true;
        if (this.properties == null) {
            return;
        }
        this.properties = null;
    }

    public boolean propertyExists(String string) {
        return this.properties != null && this.properties.containsKey(string);
    }

    public boolean getBooleanProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toBoolean(this.getObjectProperty(string));
    }

    public byte getByteProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toByte(this.getObjectProperty(string));
    }

    public short getShortProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toShort(this.getObjectProperty(string));
    }

    public int getIntProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toInt(this.getObjectProperty(string));
    }

    public long getLongProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toLong(this.getObjectProperty(string));
    }

    public float getFloatProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toFloat(this.getObjectProperty(string));
    }

    public double getDoubleProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toDouble(this.getObjectProperty(string));
    }

    public String getStringProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toString(this.getObjectProperty(string));
    }

    public Object getObjectProperty(String string) throws javax.jms.JMSException {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public Enumeration getPropertyNames() throws javax.jms.JMSException {
        return new HashKeyEnumeration(this.properties);
    }

    public void setBooleanProperty(String string, boolean bl) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Boolean(bl));
    }

    public void setByteProperty(String string, byte by) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Byte(by));
    }

    public void setShortProperty(String string, short s) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Short(s));
    }

    public void setIntProperty(String string, int n) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Integer(n));
    }

    public void setLongProperty(String string, long l) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Long(l));
    }

    public void setFloatProperty(String string, float f) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Float(f));
    }

    public void setDoubleProperty(String string, double d) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Double(d));
    }

    public void setStringProperty(String string, String string2) throws javax.jms.JMSException {
        this.setObjectProperty(string, string2);
    }

    public void setObjectProperty(String string, Object object) throws javax.jms.JMSException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Illegal property name, '" + string + "'");
        }
        if (MessageImpl.isHeaderField(string)) {
            throw new MessageFormatException("Illegal property name, '" + string + "'");
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            throw new MessageFormatException("Illegal property name, '" + string + "'");
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            throw new MessageFormatException("Illegal property name, '" + string + "'");
        }
        if (!this.propertiesWritable) {
            throw new MessageNotWriteableException("Property write attempted in READ mode");
        }
        if (object instanceof Number || object instanceof String || object instanceof Boolean || object == null) {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
        } else {
            throw new MessageFormatException("Illegal property value, " + object);
        }
        this.properties.put(string, object);
    }

    public void acknowledge() throws javax.jms.JMSException {
        if (this.session != null) {
            if (JMSDebug.debugJMSCommon) {
                JMSDebug.debug(16, "COMMON/MessageImpl: Acknowledging message, " + this.getJMSMessageID());
            }
            this.session.acknowledge(this);
            this.session = null;
        }
    }

    public void clearBody() throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.bodyWritable = true;
        this.bodySize = -1L;
        this.nullBody();
    }

    public abstract void nullBody();

    public void setId(JMSMessageId jMSMessageId) {
        this.messageId = jMSMessageId;
        this.messageIdString = null;
    }

    public JMSMessageId getId() {
        return this.messageId;
    }

    public void setSession(JMSSession jMSSession) {
        this.session = jMSSession;
    }

    public JMSSession getSession() {
        return this.session;
    }

    public void setConnectionId(JMSID jMSID) {
        this.connectionId = jMSID;
    }

    public JMSID getConnectionId() {
        return this.connectionId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public Object get(String string) {
        try {
            if (string.startsWith("JMS")) {
                if (string.equals("JMSCorrelationID")) {
                    return this.getJMSCorrelationID();
                }
                if (string.equals("JMSDeliveryMode")) {
                    if (this.getJMSDeliveryMode() == 2) {
                        return "PERSISTENT";
                    }
                    return "NON_PERSISTENT";
                }
                if (string.equals("JMSDeliveryTime")) {
                    return new Long(this.getDeliveryTime());
                }
                if (string.equals("JMSExpiration")) {
                    return new Long(this.getJMSExpiration());
                }
                if (string.equals("JMSMessageID")) {
                    return this.getJMSMessageID();
                }
                if (string.equals("JMSPriority")) {
                    return new Integer(this.getJMSPriority());
                }
                if (string.equals("JMSRedelivered")) {
                    return new Boolean(this.getJMSRedelivered());
                }
                if (string.equals("JMSRedeliveryLimit")) {
                    return new Integer(this.getJMSRedeliveryLimit());
                }
                if (string.equals("JMSTimestamp")) {
                    return new Long(this.getJMSTimestamp());
                }
                if (string.equals("JMSType")) {
                    return this.getJMSType();
                }
            }
            return this.getObjectProperty(string);
        }
        catch (javax.jms.JMSException jMSException) {
            return null;
        }
    }

    public Object parse() throws Exception {
        return null;
    }

    public synchronized MessageImpl cloneit() {
        try {
            return (MessageImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public MessageImpl getClonePageOut() {
        if (this.commonPagedOutMessage != this && this.commonPagedOutMessage != null && this.commonPagedOutMessage.commonPagedOutMessage != null && this.commonPagedOutMessage.commonPagedOutMessage != this.commonPagedOutMessage) {
            return this.commonPagedOutMessage.getClonePageOut();
        }
        return this.commonPagedOutMessage;
    }

    public MessageImpl createClonePageOut() {
        this.commonPagedOutMessage.commonPagedOutMessage = this.commonPagedOutMessage = this.cloneit();
        return this.commonPagedOutMessage.commonPagedOutMessage;
    }

    public MessageImpl setupPagedIn(MessageImpl messageImpl) {
        this.bodySize = messageImpl.bodySize;
        this.deliveryMode = messageImpl.deliveryMode;
        this.redelivered = messageImpl.redelivered;
        this.expiration = messageImpl.expiration;
        this.deliveryTime = messageImpl.deliveryTime;
        this.redeliveryLimit = messageImpl.redeliveryLimit;
        this.priority = messageImpl.priority;
        this.userdatalen = messageImpl.userdatalen;
        this.sequenceNumber = messageImpl.sequenceNumber;
        this.bodyWritable = messageImpl.bodyWritable;
        this.propertiesWritable = messageImpl.propertiesWritable;
        this.serializeDestination = messageImpl.serializeDestination;
        this.forwarded = messageImpl.forwarded;
        this.pagedState = messageImpl.pagedState;
        this.correlationId = messageImpl.correlationId;
        this.destination = messageImpl.destination;
        this.replyTo = messageImpl.replyTo;
        this.type = messageImpl.type;
        this.topicReferenceCount = messageImpl.topicReferenceCount;
        this.expirationReported = messageImpl.expirationReported;
        this.commonPagedOutMessage = messageImpl.commonPagedOutMessage;
        this.durableState = messageImpl.durableState;
        this.bexaXid = messageImpl.bexaXid;
        this.messageId = messageImpl.messageId;
        this.connectionId = messageImpl.connectionId;
        this.messageIdString = messageImpl.messageIdString;
        this.session = messageImpl.session;
        this.pagingState = messageImpl.pagingState;
        return this;
    }

    public abstract MessageImpl copy() throws javax.jms.JMSException;

    void copy(MessageImpl messageImpl) {
        boolean bl = false;
        if (this.destination instanceof DestinationImpl) {
            messageImpl.destination = this.destination;
        }
        if (this.replyTo instanceof DestinationImpl) {
            messageImpl.replyTo = this.replyTo;
        }
        messageImpl.deliveryMode = this.deliveryMode;
        messageImpl.correlationId = this.correlationId;
        messageImpl.redelivered = this.redelivered;
        messageImpl.type = this.type;
        messageImpl.deliveryTime = this.deliveryTime;
        messageImpl.redeliveryLimit = this.redeliveryLimit;
        messageImpl.expiration = this.expiration;
        messageImpl.priority = this.priority;
        messageImpl.clientResponsibleForAcknowledge = this.clientResponsibleForAcknowledge;
        if (this.userdatalen == -1) {
            bl = true;
            messageImpl.userdatalen = 0;
            if (messageImpl.correlationId != null) {
                messageImpl.userdatalen = messageImpl.correlationId.length();
            }
            if (messageImpl.type != null) {
                messageImpl.userdatalen += messageImpl.type.length();
            }
        } else {
            messageImpl.userdatalen = this.userdatalen;
        }
        messageImpl.connectionId = this.connectionId;
        messageImpl.messageId = this.messageId;
        try {
            Enumeration enumeration = this.getPropertyNames();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = this.getObjectProperty(string);
                if (bl) {
                    n += 4 + (string.length() << 2);
                    n += JMSUtilities.calcObjectSize(object);
                }
                messageImpl.setObjectProperty(string, object);
            }
            messageImpl.userdatalen += n;
        }
        catch (javax.jms.JMSException jMSException) {
            // empty catch block
        }
        messageImpl.bodyWritable = this.bodyWritable;
        messageImpl.propertiesWritable = this.propertiesWritable;
        messageImpl.serializeDestination = this.serializeDestination;
        messageImpl.forwarded = this.forwarded;
    }

    private int getVersion(Object object) throws IOException {
        if (object instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)object).getPeerInfo();
            int n = peerInfo.getMajor();
            int n2 = peerInfo.getMinor();
            if (n < 6) {
                throw new IOException("Peer neither compatible with 1 or 10 or 20 .  PeerInfo is " + peerInfo);
            }
            if (n == 6) {
                return 10;
            }
        }
        return 20;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        boolean bl;
        int n = 0;
        int n2 = this.getVersion(objectOutput);
        n |= n2 << 24;
        if (this.deliveryMode == 2) {
            n |= 0x200;
        }
        if (this.correlationId != null) {
            n |= 0x400;
        }
        if (this.serializeDestination) {
            n |= 0x200000;
        }
        if (this.forwarded) {
            n |= 0x80;
        }
        this.writeDestination = this.destination;
        if (this.writeDestination != null) {
            if (this.serializeDestination) {
                n |= 0x800;
            } else if (!(objectOutput instanceof WLObjectOutput || objectOutput instanceof JMSOutputStream && (((JMSOutputStream)((Object)objectOutput)).isJMSMulticastOutputStream() || ((JMSOutputStream)((Object)objectOutput)).isBypassOutputStream()))) {
                n |= 0x800;
            }
        }
        int n3 = 0;
        if (n2 >= 20 && (n & 0x800) != 0 && (n3 |= Destination.getDestinationType(this.writeDestination, 0)) != 0) {
            n |= 0x800000;
        }
        if (this.replyTo != null) {
            n |= 0x1000;
        }
        if (n2 >= 20 && (n & 0x1000) != 0 && ((n3 |= Destination.getDestinationType(this.replyTo, 3)) & 0x38) != 0) {
            n |= 0x800000;
        }
        if (this.redelivered) {
            n |= 0x2000;
        }
        if (this.type != null) {
            n |= 0x4000;
        }
        if (this.deliveryTime != 0L) {
            n |= 0x100000;
        }
        if (n2 >= 20 && this.redeliveryLimit != -1) {
            n |= 0x100;
        }
        if (this.expiration != 0L) {
            n |= 0x8000;
        }
        n |= this.priority << 0;
        boolean bl2 = bl = this.properties != null && !this.properties.isEmpty();
        if (bl) {
            n |= 0x10000;
        }
        if (this.messageId != null) {
            n |= 0x40000;
        }
        if (this.bexaXid != null) {
            n |= 0x20000;
        }
        if ((n & 0x14400) != 0) {
            n |= 0x80000;
        }
        if (this.clientResponsibleForAcknowledge) {
            n |= 0x400000;
        }
        objectOutput.writeInt(n);
        this.userdatalen = 0;
        if (this.correlationId != null) {
            objectOutput.writeUTF(this.correlationId);
            this.userdatalen = this.correlationId.length();
        }
        if (n2 >= 20 && (n & 0x800000) != 0) {
            objectOutput.writeByte(n3);
        }
        if ((n & 0x800) != 0) {
            this.writeDestination.writeExternal(objectOutput);
        }
        if (this.replyTo != null) {
            this.replyTo.writeExternal(objectOutput);
        }
        if (this.type != null) {
            objectOutput.writeUTF(this.type);
            this.userdatalen += this.type.length();
        }
        if (this.deliveryTime != 0L) {
            objectOutput.writeLong(this.deliveryTime);
        }
        if (n2 >= 20 && this.redeliveryLimit != -1) {
            objectOutput.writeInt(this.redeliveryLimit);
        }
        if (this.expiration != 0L) {
            objectOutput.writeLong(this.expiration);
        }
        if (bl) {
            PeerInfo peerInfo = objectOutput instanceof PeerInfoable ? ((PeerInfoable)((Object)objectOutput)).getPeerInfo() : PeerInfo.getPeerInfo();
            this.userdatalen += JMSUtilities.writeBasicMap(objectOutput, this.properties, peerInfo, false);
        }
        if (this.messageId != null) {
            this.messageId.writeExternal(objectOutput);
        }
        if (this.bexaXid != null) {
            objectOutput.writeObject(this.bexaXid);
        }
        if ((n & 0x14400) != 0) {
            objectOutput.writeInt(this.userdatalen);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        byte by = (byte)((n & 0xFF000000) >>> 24 & 0xFF);
        if (by == 1) {
            if (!(objectInput instanceof PutBackable)) {
                throw new IOException("Unknown underlying stream type, can't convert 6.0 class.");
            }
            ((PutBackable)((Object)objectInput)).unput();
            ((PutBackable)((Object)objectInput)).unput();
            ((PutBackable)((Object)objectInput)).unput();
            this.readExternalVersion1(objectInput);
            return;
        }
        if (by == 10) {
            this.readExternalVersion2(objectInput, n);
            return;
        }
        if (by != 20) {
            throw JMSUtilities.versionIOException(by, 1, 20);
        }
        this.deliveryMode = (n & 0x200) != 0 ? 2 : 1;
        this.adjustedDeliveryMode = this.deliveryMode;
        if ((n & 0x400) != 0) {
            this.correlationId = objectInput.readUTF();
        }
        if ((n & 0x800000) != 0) {
            byte by2;
            byte by3 = objectInput.readByte();
            if ((n & 0x800) != 0) {
                by2 = (byte)(by3 & 7);
                this.destination = Destination.createDestination(by2, objectInput);
            }
            if ((n & 0x1000) != 0) {
                by2 = (byte)((by3 & 0x38) >>> 3);
                this.replyTo = Destination.createDestination(by2, objectInput);
            }
        }
        boolean bl = this.redelivered = (n & 0x2000) != 0;
        if ((n & 0x4000) != 0) {
            this.type = objectInput.readUTF();
        }
        if ((n & 0x100000) != 0) {
            this.deliveryTime = objectInput.readLong();
        }
        if ((n & 0x100) != 0) {
            this.redeliveryLimit = objectInput.readInt();
        }
        if ((n & 0x8000) != 0) {
            this.expiration = objectInput.readLong();
        }
        this.priority = (byte)((n & 0xF) >>> 0 & 0xFF);
        if ((n & 0x10000) != 0) {
            this.properties = JMSUtilities.readBasicMap(objectInput, null);
        }
        if ((n & 0x40000) != 0) {
            this.messageId = new JMSMessageId();
            this.messageId.readExternal(objectInput);
        }
        if ((n & 0x20000) != 0) {
            this.bexaXid = (Externalizable)objectInput.readObject();
        }
        this.userdatalen = (n & 0x80000) != 0 ? objectInput.readInt() : 0;
        this.clientResponsibleForAcknowledge = (n & 0x400000) != 0;
        this.bodyWritable = false;
        this.propertiesWritable = false;
        this.serializeDestination = (n & 0x200000) != 0;
        this.forwarded = (n & 0x80) != 0;
    }

    private void readExternalVersion2(ObjectInput objectInput, int n) throws IOException, ClassNotFoundException {
        this.deliveryMode = (n & 0x200) != 0 ? 2 : 1;
        this.adjustedDeliveryMode = this.deliveryMode;
        if ((n & 0x400) != 0) {
            this.correlationId = objectInput.readUTF();
        }
        if ((n & 0x800) != 0) {
            this.destination = new DestinationImpl();
            this.destination.readExternal(objectInput);
        }
        if ((n & 0x1000) != 0) {
            this.replyTo = new DestinationImpl();
            this.replyTo.readExternal(objectInput);
        }
        boolean bl = this.redelivered = (n & 0x2000) != 0;
        if ((n & 0x4000) != 0) {
            this.type = objectInput.readUTF();
        }
        if ((n & 0x100000) != 0) {
            this.deliveryTime = objectInput.readLong();
        }
        if ((n & 0x8000) != 0) {
            this.expiration = objectInput.readLong();
        }
        this.priority = (byte)((n & 0xF) >>> 0 & 0xFF);
        if ((n & 0x10000) != 0) {
            this.properties = JMSUtilities.readBasicMap(objectInput, null);
        }
        if ((n & 0x40000) != 0) {
            this.messageId = new JMSMessageId();
            this.messageId.readExternal(objectInput);
        }
        if ((n & 0x20000) != 0) {
            this.bexaXid = (Externalizable)objectInput.readObject();
        }
        this.userdatalen = (n & 0x80000) != 0 ? objectInput.readInt() : 0;
        this.bodyWritable = false;
        this.propertiesWritable = false;
        this.serializeDestination = (n & 0x200000) != 0;
    }

    private void readExternalVersion1(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.adjustedDeliveryMode = this.deliveryMode = (int)objectInput.readByte();
        if (this.deliveryMode != 2) {
            throw new IOException("Stream is corrupted.  Possible older version.");
        }
        this.correlationId = objectInput.readBoolean() ? objectInput.readUTF() : null;
        long l = objectInput.readLong();
        if (objectInput.readBoolean()) {
            this.destination = new DestinationImpl();
            this.destination.readExternal(objectInput);
        }
        if (objectInput.readBoolean()) {
            this.replyTo = new DestinationImpl();
            this.replyTo.readExternal(objectInput);
        }
        this.redelivered = objectInput.readBoolean();
        this.type = objectInput.readBoolean() ? objectInput.readUTF() : null;
        this.expiration = objectInput.readLong();
        this.priority = objectInput.readByte();
        if (objectInput.readBoolean()) {
            this.properties = JMSUtilities.readBasicMap(objectInput, null);
        }
        if (objectInput.readBoolean()) {
            this.messageId = new JMSMessageId();
            this.messageId.readExternal(objectInput);
        }
        if (this.messageId == null && this.expiration != 0L) {
            throw new IOException("Unsupported version.  Contact customer support.");
        }
        if (objectInput.readBoolean()) {
            this.bexaXid = (Externalizable)objectInput.readObject();
        }
        this.userdatalen = objectInput.readInt();
        this.connectionId = new JMSID();
        this.clientResponsibleForAcknowledge = false;
        this.connectionId.readExternal(objectInput);
        this.bodyWritable = false;
        this.propertiesWritable = false;
    }

    public static boolean isHeaderField(String string) {
        return string.startsWith("JMS") && (string.equals("JMSCorrelationID") || string.equals("JMSDeliveryMode") || string.equals("JMSDeliveryTime") || string.equals("JMSDestination") || string.equals("JMSExpiration") || string.equals("JMSPriority") || string.equals("JMSRedelivered") || string.equals("JMSRedeliveryLimit") || string.equals("JMSRedeliveryDelay") || string.equals("JMSReplyTo") || string.equals("JMSTimestamp") || string.equals("JMSType"));
    }

    public void reset() throws javax.jms.JMSException {
    }

    protected boolean isWriteMode() {
        return this.bodyWritable;
    }

    protected void setBodyWritable(boolean bl) {
        this.bodyWritable = bl;
        this.propertiesWritable = bl;
    }

    protected void readMode() throws javax.jms.JMSException {
        if (this.bodyWritable) {
            throw new MessageNotReadableException("Read attempted in WRITE mode");
        }
    }

    protected void writeMode() throws javax.jms.JMSException {
        if (!this.bodyWritable) {
            throw new MessageNotWriteableException("Write attempted in Read mode");
        }
    }

    public final void resetTopicReferenceCount() {
        this.topicReferenceCount = new Counter(0);
    }

    public final void incTopicReferenceCount() {
        this.topicReferenceCount.increment();
    }

    public final int decTopicReferenceCount() {
        return this.topicReferenceCount.decrement();
    }

    public final Counter getTopicReferenceCount() {
        return this.topicReferenceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean AMEReportTAS() {
        Counter counter = this.expirationReported;
        synchronized (counter) {
            if (this.expirationReported.getValue() == 0) {
                this.expirationReported.increment();
                return true;
            }
            return false;
        }
    }

    public final synchronized void setDurableState(Object object) {
        this.durableState = object;
        this.pagingState = object;
    }

    public final synchronized Object getDurableState() {
        return this.durableState;
    }

    public final synchronized void setPagingState(Object object) {
        this.pagingState = object;
    }

    public final synchronized Object getPagingState() {
        return this.pagingState;
    }

    public final Externalizable getBEXAXid() {
        return this.bexaXid;
    }

    public final void setBEXAXid(Externalizable externalizable) {
        this.bexaXid = externalizable;
    }

    public abstract long getPayloadSize();

    public final int getUserPropertySize() {
        return this.userdatalen;
    }

    public final void resetUserPropertySize() {
        this.userdatalen = -1;
        this.bodySize = -1;
    }

    public final void setSerializeDestination(boolean bl) {
        this.serializeDestination = bl;
    }

    public final void setForwarded(boolean bl) {
        this.forwarded = bl;
    }

    public final boolean getForwarded() {
        return this.forwarded;
    }

    public final HashMap getProperties() {
        return this.properties;
    }

    public final void resetExpirationReported() {
        this.expirationReported = new Counter(0);
    }
}

