/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.jms.common.JMSEventListener;
import weblogic.jms.common.MessageReference;

public class MessageList {
    protected MessageReference first;
    protected MessageReference last;
    protected int count;
    private JMSEventListener eventListener;

    public void setJMSEventListener(JMSEventListener jMSEventListener, int n) {
        this.eventListener = jMSEventListener;
    }

    public void add(MessageReference messageReference) {
        boolean bl;
        messageReference.setPrev(this.last);
        messageReference.setNext(null);
        if (this.last == null) {
            this.first = messageReference;
            bl = this.eventListener != null;
        } else {
            this.last.setNext(messageReference);
            bl = false;
        }
        this.last = messageReference;
        ++this.count;
        if (bl) {
            this.eventListener.onJMSEvent(null, 4);
        }
    }

    public void addToHead(MessageReference messageReference) {
        boolean bl;
        messageReference.setPrev(null);
        messageReference.setNext(this.first);
        if (this.first == null) {
            this.last = messageReference;
            bl = this.eventListener != null;
        } else {
            this.first.setPrev(messageReference);
            bl = false;
        }
        this.first = messageReference;
        ++this.count;
        if (bl) {
            this.eventListener.onJMSEvent(null, 4);
        }
    }

    public void remove(MessageReference messageReference) {
        if (messageReference.getPrev() == null) {
            this.first = messageReference.getNext();
        } else {
            messageReference.getPrev().setNext(messageReference.getNext());
        }
        if (messageReference.getNext() == null) {
            this.last = messageReference.getPrev();
        } else {
            messageReference.getNext().setPrev(messageReference.getPrev());
        }
        messageReference.setNext(null);
        messageReference.setPrev(null);
        --this.count;
    }

    public MessageReference removeFirst() {
        MessageReference messageReference = this.first;
        if (messageReference != null) {
            --this.count;
            this.first = messageReference.getNext();
            messageReference.setNext(null);
            if (this.first == null) {
                this.last = null;
            } else {
                this.first.setPrev(null);
            }
        }
        return messageReference;
    }

    public MessageReference removeBeforeSequenceNumber(long l) {
        MessageReference messageReference;
        MessageReference messageReference2 = this.first;
        int n = 0;
        for (messageReference = this.first; messageReference != null; messageReference = messageReference.getNext()) {
            if (messageReference.getSequenceNumber() == l) {
                this.first = messageReference.getNext();
                if (this.first == null) {
                    this.last = null;
                } else {
                    this.first.setPrev(null);
                }
                messageReference.setNext(null);
                this.count -= ++n;
                break;
            }
            ++n;
        }
        return messageReference;
    }

    MessageReference removeMessages(int n) {
        MessageReference messageReference = this.first;
        if (n == -1 || n >= this.count) {
            this.last = null;
            this.first = null;
            this.count = 0;
        } else {
            n = this.count - n;
            while (this.first != null) {
                this.first = this.first.getNext();
            }
            while (--this.count != n) {
            }
            if (this.first == null) {
                this.last = null;
            } else {
                this.first.getPrev().setNext(null);
                this.first.setPrev(null);
            }
        }
        return messageReference;
    }

    public MessageReference removeAll() {
        MessageReference messageReference = this.first;
        this.last = null;
        this.first = null;
        this.count = 0;
        return messageReference;
    }

    public MessageReference getFirst() {
        return this.first;
    }

    public MessageReference getLast() {
        return this.last;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public int getSize() {
        return this.count;
    }
}

