/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.jms.common.MessageImpl;

public class MessageReference {
    private MessageImpl message;
    private long sequenceNumber;
    private short redeliveryCount;
    private MessageReference prev;
    private MessageReference next;

    public MessageReference(MessageImpl messageImpl) {
        this.message = messageImpl;
        if (messageImpl.getJMSRedelivered()) {
            this.redeliveryCount = (short)-1;
        }
    }

    public MessageReference(MessageReference messageReference) {
        this.message = messageReference.message;
        this.redeliveryCount = messageReference.redeliveryCount;
    }

    public void setMessage(MessageImpl messageImpl) {
        this.message = messageImpl;
    }

    public MessageImpl getMessage() {
        return this.message;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setPrev(MessageReference messageReference) {
        this.prev = messageReference;
    }

    public MessageReference getPrev() {
        return this.prev;
    }

    public void setNext(MessageReference messageReference) {
        this.next = messageReference;
    }

    public MessageReference getNext() {
        return this.next;
    }

    public boolean getRedelivered() {
        return this.redeliveryCount == -1 || this.redeliveryCount > 0;
    }

    public void setRedelivered() {
        if (this.redeliveryCount == 0) {
            this.redeliveryCount = (short)-1;
        }
    }

    public short getRedeliveryCount() {
        if (this.redeliveryCount == -1) {
            return 0;
        }
        return this.redeliveryCount;
    }

    public short postIncRedeliveryCount() {
        if (this.redeliveryCount == -1) {
            this.redeliveryCount = 0;
        }
        short s = this.redeliveryCount;
        short s2 = this.redeliveryCount;
        this.redeliveryCount = (short)(s2 + 1);
        if (s2 < 0) {
            this.redeliveryCount = Short.MAX_VALUE;
        }
        return s;
    }

    public void prepareForCache() {
        if (this.message != null) {
            this.message.setMessageReference(null);
        }
        this.message = null;
        this.sequenceNumber = 0L;
        this.redeliveryCount = 0;
        this.prev = null;
        this.next = null;
    }

    public void reset(MessageImpl messageImpl) {
        this.message = messageImpl;
        if (messageImpl.getJMSRedelivered()) {
            this.redeliveryCount = (short)-1;
        }
    }

    public String toString() {
        return "(mRef id=" + this.message.getId() + ")";
    }
}

