/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

public class MessageTime {
    public static int UNKNOWN_STATE = 0;
    public static int ENQUEUE_START_STATE = 1;
    public static int ENQUEUE_END_STATE = 2;
    public static int PARKING_START_STATE = 4;
    public static int PARKING_END_STATE = 8;
    public static int DEQUEUE_START_STATE = 16;
    public static int DEQUEUE_END_STATE = 32;
    private int state = UNKNOWN_STATE;
    private long startTime = -1L;
    private int enqTime = -1;
    private int parkTime = -1;
    private int deqTime = -1;

    public void prepareForParking() {
        this.state = ENQUEUE_END_STATE;
    }

    public void changeTimeState(int n) {
        this.state = n;
    }

    public int getTimeState() {
        return this.state;
    }

    public boolean isUnknownTime() {
        return this.state == UNKNOWN_STATE;
    }

    public boolean isEnqStartTime() {
        return this.state == ENQUEUE_START_STATE;
    }

    public boolean isEnqEndTime() {
        return this.state == ENQUEUE_END_STATE;
    }

    public boolean isParkingStartTime() {
        return this.state == PARKING_START_STATE;
    }

    public boolean isParkingEndTime() {
        return this.state == PARKING_END_STATE;
    }

    public boolean isDeqStartTime() {
        return this.state == DEQUEUE_START_STATE;
    }

    public boolean isDeqEndTime() {
        return this.state == DEQUEUE_END_STATE;
    }

    public long getEnqTime() {
        return this.enqTime;
    }

    public long getParkingTime() {
        return this.parkTime;
    }

    public long getDeqTime() {
        return this.deqTime;
    }

    public int setEnqEndTime() {
        this.state = ENQUEUE_END_STATE;
        this.enqTime = (int)(System.currentTimeMillis() - this.startTime);
        return this.enqTime;
    }

    public int setParkingEndTime() {
        this.state = PARKING_END_STATE;
        this.parkTime = (int)(System.currentTimeMillis() - this.startTime);
        return this.parkTime;
    }

    public int setDeqEndTime() {
        this.state = DEQUEUE_END_STATE;
        this.deqTime = (int)(System.currentTimeMillis() - this.startTime);
        return this.deqTime;
    }

    public void setEnqStartTime() {
        this.state = ENQUEUE_START_STATE;
        this.startTime = System.currentTimeMillis();
    }

    public void setParkingStartTime() {
        this.state = PARKING_START_STATE;
        this.startTime = System.currentTimeMillis();
    }

    public void setDeqStartTime() {
        this.state = DEQUEUE_START_STATE;
        this.startTime = System.currentTimeMillis();
    }
}

