/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.ObjectMessage;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.Replacer;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.kernel.Kernel;

public final class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage,
Externalizable {
    private static final byte EXTVERSION = 1;
    static final long serialVersionUID = -1035306457762201546L;
    private transient Serializable object;
    private byte[] objectBytes;
    private Replacer replacer;
    private static final String REMOTE_OBJECT_REPLACER_CLASS_NAME = "weblogic.rmi.utils.io.RemoteObjectReplacer";

    public ObjectMessageImpl() {
        this.replacer = this.getReplacer();
    }

    public ObjectMessageImpl(ObjectMessage objectMessage) throws javax.jms.JMSException {
        this(objectMessage, (Destination)null, (Destination)null);
    }

    public ObjectMessageImpl(ObjectMessage objectMessage, Destination destination, Destination destination2) throws javax.jms.JMSException {
        super(objectMessage, destination, destination2);
        this.setObject(objectMessage.getObject());
        this.replacer = this.getReplacer();
    }

    public byte getType() {
        return 4;
    }

    public void setObject(Serializable serializable) throws javax.jms.JMSException {
        this.writeMode();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream2 objectOutputStream2 = new ObjectOutputStream2(byteArrayOutputStream);
            if (!objectOutputStream2.canReplace()) {
                serializable = (Serializable)objectOutputStream2.replaceObject(serializable);
            }
            objectOutputStream2.writeObject(serializable);
            objectOutputStream2.flush();
            this.objectBytes = byteArrayOutputStream.toByteArray();
            this.object = null;
        }
        catch (Exception exception) {
            throw new JMSException("Error serializing object", exception);
        }
    }

    public Serializable getObject() throws javax.jms.JMSException {
        if (this.object == null && this.objectBytes != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.objectBytes);
                ObjectInputStream2 objectInputStream2 = new ObjectInputStream2(byteArrayInputStream);
                this.object = (Serializable)objectInputStream2.readObject();
                if (!objectInputStream2.canResolve()) {
                    this.object = (Serializable)objectInputStream2.resolveObject(this.object);
                }
            }
            catch (IOException iOException) {
                throw new JMSException("Error deserializing object", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JMSException("Error deserializing object", classNotFoundException);
            }
        }
        return this.object;
    }

    public void nullBody() {
        this.object = null;
        this.objectBytes = null;
    }

    public String toString() {
        try {
            return "ObjectMessage[" + this.getJMSMessageID() + "," + this.getObject() + "]";
        }
        catch (javax.jms.JMSException jMSException) {
            return "ObjectMessage[" + this.getJMSMessageID() + "]";
        }
    }

    private Replacer getReplacer() {
        try {
            Class<?> clazz = Class.forName(REMOTE_OBJECT_REPLACER_CLASS_NAME);
            Method method = clazz.getMethod("getReplacer", new Class[0]);
            return (Replacer)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeByte(1);
        if (this.objectBytes == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream2 objectOutputStream2 = new ObjectOutputStream2(byteArrayOutputStream);
            objectOutputStream2.writeObject(this.object);
            objectOutputStream2.flush();
            this.objectBytes = byteArrayOutputStream.toByteArray();
        }
        objectOutput.writeInt(this.objectBytes.length);
        objectOutput.write(this.objectBytes);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        this.objectBytes = new byte[objectInput.readInt()];
        objectInput.readFully(this.objectBytes);
    }

    public MessageImpl copy() {
        ObjectMessageImpl objectMessageImpl = new ObjectMessageImpl();
        this.copy(objectMessageImpl);
        try {
            if (this.objectBytes == null && this.object != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream2 objectOutputStream2 = new ObjectOutputStream2(byteArrayOutputStream);
                objectOutputStream2.writeObject(this.object);
                objectOutputStream2.flush();
                objectMessageImpl.objectBytes = byteArrayOutputStream.toByteArray();
            } else if (this.objectBytes != null) {
                objectMessageImpl.objectBytes = new byte[this.objectBytes.length];
                System.arraycopy(this.objectBytes, 0, objectMessageImpl.objectBytes, 0, this.objectBytes.length);
            } else {
                objectMessageImpl.objectBytes = null;
            }
            objectMessageImpl.object = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        objectMessageImpl.setBodyWritable(false);
        return objectMessageImpl;
    }

    public long getPayloadSize() {
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.objectBytes != null) {
            this.bodySize = this.objectBytes.length;
            return this.bodySize;
        }
        this.bodySize = 0L;
        return 0L;
    }

    final class ObjectOutputStream2
    extends ObjectOutputStream
    implements WLObjectOutput {
        private boolean canReplace = true;

        ObjectOutputStream2(OutputStream outputStream) throws IOException, StreamCorruptedException {
            super(outputStream);
            if (Kernel.isApplet()) {
                this.canReplace = false;
            } else {
                this.enableReplaceObject(true);
            }
        }

        protected boolean canReplace() {
            return this.canReplace;
        }

        protected Object replaceObject(Object object) throws IOException {
            if (ObjectMessageImpl.this.replacer != null) {
                return ObjectMessageImpl.this.replacer.replaceObject(object);
            }
            return object;
        }

        public final void writeObjectWL(Object object) throws IOException {
            this.writeObject(object);
        }

        public final void writeAscii(String string) throws IOException {
            this.writeObject(string);
        }

        public final void writeString(String string) throws IOException {
            this.writeObject(string);
        }

        public final void writeDate(Date date) throws IOException {
            this.writeObject(date);
        }

        public final void writeVector(Vector vector) throws IOException {
            this.writeObject(vector);
        }

        public final void writeArrayList(ArrayList arrayList) throws IOException {
            this.writeObject(arrayList);
        }

        public final void writeHashtable(Hashtable hashtable) throws IOException {
            this.writeObject(hashtable);
        }

        public final void writeProperties(Properties properties) throws IOException {
            this.writeObject(properties);
        }

        public final void writeBytes(byte[] byArray) throws IOException {
            this.writeObject(byArray);
        }

        public final void writeBytes(byte[] byArray, int n) throws IOException {
            this.writeBytes(byArray, 0, n);
        }

        public final void writeBytes(byte[] byArray, int n, int n2) throws IOException {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.writeObject(byArray2);
        }

        public final void writeBooleanArray(boolean[] blArray) throws IOException {
            this.writeObject(blArray);
        }

        public final void writeCharArray(char[] cArray) throws IOException {
            this.writeObject(cArray);
        }

        public final void writeDoubleArray(double[] dArray) throws IOException {
            this.writeObject(dArray);
        }

        public final void writeFloatArray(float[] fArray) throws IOException {
            this.writeObject(fArray);
        }

        public final void writeIntArray(int[] nArray) throws IOException {
            this.writeObject(nArray);
        }

        public final void writeShortArray(short[] sArray) throws IOException {
            this.writeObject(sArray);
        }

        public final void writeLongArray(long[] lArray) throws IOException {
            this.writeObject(lArray);
        }

        public final void writeArrayOfObjects(Object[] objectArray) throws IOException {
            this.writeObject(objectArray);
        }

        public final void writeArrayOfConsistentObjects(Object[] objectArray) throws IOException {
            this.writeObject(objectArray);
        }

        public final void writeAbbrevString(String string) throws IOException {
            this.writeObject(string);
        }

        public final void writeImmutable(Object object) throws IOException {
            this.writeObject(object);
        }
    }

    final class ObjectInputStream2
    extends ObjectInputStream
    implements WLObjectInput {
        private boolean canResolve = true;

        ObjectInputStream2(InputStream inputStream) throws IOException, StreamCorruptedException {
            super(inputStream);
            if (Kernel.isApplet()) {
                this.canResolve = false;
            } else {
                this.enableResolveObject(true);
            }
        }

        protected boolean canResolve() {
            return this.canResolve;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            if (Kernel.isApplet()) {
                return Class.forName(objectStreamClass.getName());
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                return Class.forName(objectStreamClass.getName(), true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.resolveClass(objectStreamClass);
            }
        }

        protected Object resolveObject(Object object) throws IOException {
            if (ObjectMessageImpl.this.replacer != null) {
                return ObjectMessageImpl.this.replacer.resolveObject(object);
            }
            return object;
        }

        public final Object readObjectWL() throws IOException, ClassNotFoundException {
            return this.readObject();
        }

        public final String readAscii() throws IOException {
            try {
                return (String)this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }

        public final String readString() throws IOException {
            try {
                return (String)this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }

        public final Date readDate() throws IOException {
            try {
                return (Date)this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Couldn't find class:  " + classNotFoundException);
            }
        }

        public final Vector readVector() throws IOException, ClassNotFoundException {
            return (Vector)this.readObject();
        }

        public final ArrayList readArrayList() throws IOException, ClassNotFoundException {
            return (ArrayList)this.readObject();
        }

        public final Hashtable readHashtable() throws IOException, ClassNotFoundException {
            return (Hashtable)this.readObject();
        }

        public final Properties readProperties() throws IOException {
            try {
                return (Properties)this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Couldn't find class:  " + classNotFoundException);
            }
        }

        public final byte[] readBytes() throws IOException {
            try {
                return (byte[])this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Couldn't find class:  " + classNotFoundException);
            }
        }

        public final boolean[] readBooleanArray() throws IOException {
            try {
                return (boolean[])this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Couldn't find class:  " + classNotFoundException);
            }
        }

        public final char[] readCharArray() throws IOException {
            try {
                return (char[])this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Couldn't find class:  " + classNotFoundException);
            }
        }

        public final double[] readDoubleArray() throws IOException {
            try {
                return (double[])this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Couldn't find class:  " + classNotFoundException);
            }
        }

        public final float[] readFloatArray() throws IOException {
            try {
                return (float[])this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Couldn't find class:  " + classNotFoundException);
            }
        }

        public final int[] readIntArray() throws IOException {
            try {
                return (int[])this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Couldn't find class:  " + classNotFoundException);
            }
        }

        public final short[] readShortArray() throws IOException {
            try {
                return (short[])this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Couldn't find class:  " + classNotFoundException);
            }
        }

        public final long[] readLongArray() throws IOException {
            try {
                return (long[])this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Couldn't find class:  " + classNotFoundException);
            }
        }

        public final Object[] readArrayOfObjects() throws IOException, ClassNotFoundException {
            return (Object[])this.readObject();
        }

        public final Object[] readArrayOfConsistentObjects() throws IOException, ClassNotFoundException {
            return (Object[])this.readObject();
        }

        public final String readAbbrevString() throws IOException {
            try {
                return (String)this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }

        public final Object readImmutable() throws IOException, ClassNotFoundException {
            return this.readObject();
        }
    }
}

