/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import javax.jms.Destination;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;
import weblogic.jms.JMSLogger;
import weblogic.jms.common.BufferDataInputStream;
import weblogic.jms.common.BufferDataOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageEOFException;
import weblogic.jms.common.MessageFormatException;
import weblogic.jms.common.MessageImpl;

public final class StreamMessageImpl
extends MessageImpl
implements StreamMessage,
Externalizable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    static final long serialVersionUID = 7748687583664395357L;
    private static final byte UNKNOWN_TYPECODE = 0;
    private static final byte BOOLEAN_TYPE = 1;
    private static final byte BYTE_TYPE = 2;
    private static final byte CHAR_TYPE = 3;
    private static final byte DOUBLE_TYPE = 4;
    private static final byte FLOAT_TYPE = 5;
    private static final byte INT_TYPE = 6;
    private static final byte LONG_TYPE = 7;
    private static final byte SHORT_TYPE = 8;
    private static final byte STRING_UTF_TYPE = 9;
    private static final byte STRING_UTF32_TYPE = 10;
    private static final byte BYTES_TYPE = 11;
    private static final byte NULL_TYPE = 12;
    private static final String[] TYPE_CODE_STRINGS = new String[]{"invalid type code", "boolean", "byte", "char", "double", "float", "integer", "long", "short", "String", "String", "byte array", "null object"};
    private boolean readingByteArray;
    private int available_bytes;
    private transient byte[] buffer;
    private transient int length;
    private transient boolean copyOnWrite;
    private transient BufferDataOutputStream bdos;
    private transient BufferDataInputStream bdis;

    public StreamMessageImpl() {
    }

    public StreamMessageImpl(StreamMessage streamMessage) throws IOException, javax.jms.JMSException {
        this(streamMessage, (Destination)null, (Destination)null);
    }

    public StreamMessageImpl(StreamMessage streamMessage, Destination destination, Destination destination2) throws IOException, javax.jms.JMSException {
        super(streamMessage, destination, destination2);
        if (!(streamMessage instanceof StreamMessageImpl)) {
            streamMessage.reset();
        }
        try {
            while (true) {
                this.writeObject(streamMessage.readObject());
            }
        }
        catch (javax.jms.MessageEOFException messageEOFException) {
            this.reset();
            return;
        }
    }

    public byte getType() {
        return 5;
    }

    public void nullBody() {
        this.length = 0;
        this.buffer = null;
        this.copyOnWrite = false;
        this.bdis = null;
        this.bdos = null;
        this.readingByteArray = false;
        this.available_bytes = 0;
    }

    private void putTypeBack() {
        if (!this.readingByteArray) {
            this.bdis.unput();
        }
    }

    private byte readType() throws javax.jms.JMSException {
        this.checkReadable();
        if (this.readingByteArray) {
            return 11;
        }
        try {
            return this.bdis.readByte();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    private void writeType(byte by) throws javax.jms.JMSException {
        this.checkWritable();
        try {
            this.bdos.writeByte(by);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public boolean readBoolean() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 1: {
                    return this.bdis.readBoolean();
                }
                case 9: 
                case 10: {
                    return Boolean.valueOf(this.readStringInternal(by));
                }
            }
            this.putTypeBack();
            throw new MessageFormatException("Cannot convert " + this.typeCodeToString(by) + " to boolean");
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public byte readByte() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 2: {
                    return this.bdis.readByte();
                }
                case 9: 
                case 10: {
                    this.bdis.mark();
                    return Byte.parseByte(this.readStringInternal(by));
                }
            }
            this.putTypeBack();
            throw new MessageFormatException("Cannot convert " + this.typeCodeToString(by) + " to byte");
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
        catch (NumberFormatException numberFormatException) {
            this.bdis.backToMark();
            this.bdis.unput();
            throw numberFormatException;
        }
    }

    public short readShort() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 2: {
                    return this.bdis.readByte();
                }
                case 8: {
                    return this.bdis.readShort();
                }
                case 9: 
                case 10: {
                    this.bdis.mark();
                    return Short.parseShort(this.readStringInternal(by));
                }
            }
            this.putTypeBack();
            throw new MessageFormatException("Cannot convert " + this.typeCodeToString(by) + " to short");
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
        catch (NumberFormatException numberFormatException) {
            this.bdis.backToMark();
            this.bdis.unput();
            throw numberFormatException;
        }
    }

    public char readChar() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 3: {
                    return this.bdis.readChar();
                }
                case 12: {
                    this.putTypeBack();
                    throw new NullPointerException("Null");
                }
            }
            this.putTypeBack();
            throw new MessageFormatException("Cannot convert " + this.typeCodeToString(by) + " to char");
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading stream", iOException);
        }
    }

    public int readInt() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 2: {
                    return this.bdis.readByte();
                }
                case 8: {
                    return this.bdis.readShort();
                }
                case 6: {
                    return this.bdis.readInt();
                }
                case 9: 
                case 10: {
                    this.bdis.mark();
                    return Integer.parseInt(this.readStringInternal(by));
                }
            }
            this.putTypeBack();
            throw new MessageFormatException("Cannot convert " + this.typeCodeToString(by) + " to int");
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
        catch (NumberFormatException numberFormatException) {
            this.bdis.backToMark();
            this.bdis.unput();
            throw numberFormatException;
        }
    }

    public long readLong() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 2: {
                    return this.bdis.readByte();
                }
                case 8: {
                    return this.bdis.readShort();
                }
                case 6: {
                    return this.bdis.readInt();
                }
                case 7: {
                    return this.bdis.readLong();
                }
                case 9: 
                case 10: {
                    this.bdis.mark();
                    return Long.parseLong(this.readStringInternal(by));
                }
            }
            this.putTypeBack();
            throw new MessageFormatException("Cannot convert " + this.typeCodeToString(by) + " to long");
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
        catch (NumberFormatException numberFormatException) {
            this.bdis.backToMark();
            this.bdis.unput();
            throw numberFormatException;
        }
    }

    public float readFloat() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 5: {
                    return this.bdis.readFloat();
                }
                case 9: 
                case 10: {
                    this.bdis.mark();
                    return Float.parseFloat(this.readStringInternal(by));
                }
            }
            this.putTypeBack();
            throw new MessageFormatException("Cannot convert " + this.typeCodeToString(by) + " to float");
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
        catch (NumberFormatException numberFormatException) {
            this.bdis.backToMark();
            this.bdis.unput();
            throw numberFormatException;
        }
    }

    public double readDouble() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 5: {
                    return this.bdis.readFloat();
                }
                case 4: {
                    return this.bdis.readDouble();
                }
                case 9: 
                case 10: {
                    this.bdis.mark();
                    return Double.parseDouble(this.readStringInternal(by));
                }
            }
            this.putTypeBack();
            throw new MessageFormatException("Cannot convert " + this.typeCodeToString(by) + " to double");
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
        catch (NumberFormatException numberFormatException) {
            this.bdis.backToMark();
            this.bdis.unput();
            throw numberFormatException;
        }
    }

    public String readString() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 1: {
                    return String.valueOf(this.bdis.readBoolean());
                }
                case 2: {
                    return String.valueOf(this.bdis.readByte());
                }
                case 8: {
                    return String.valueOf(this.bdis.readShort());
                }
                case 3: {
                    return String.valueOf(this.bdis.readChar());
                }
                case 6: {
                    return String.valueOf(this.bdis.readInt());
                }
                case 7: {
                    return String.valueOf(this.bdis.readLong());
                }
                case 5: {
                    return String.valueOf(this.bdis.readFloat());
                }
                case 4: {
                    return String.valueOf(this.bdis.readDouble());
                }
                case 9: {
                    return this.readStringInternal(by);
                }
                case 10: {
                    return this.readStringInternal(by);
                }
                case 12: {
                    return null;
                }
            }
            this.putTypeBack();
            throw new MessageFormatException("Cannot convert to string from : " + this.typeCodeToString(by));
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public int readBytes(byte[] byArray) throws javax.jms.JMSException {
        int n = -1;
        if (byArray == null) {
            throw new NullPointerException();
        }
        try {
            if (!this.readingByteArray) {
                byte by = this.readType();
                if (by != 11) {
                    if (by == 12) {
                        return -1;
                    }
                    this.bdis.unput();
                    throw new MessageFormatException("Cannot convert " + this.typeCodeToString(by) + " to byte[]");
                }
                this.available_bytes = this.bdis.readInt();
                if (this.available_bytes == 0) {
                    return 0;
                }
                this.readingByteArray = true;
            }
            if (this.available_bytes == 0) {
                this.readingByteArray = false;
                return -1;
            }
            if (byArray.length > this.available_bytes) {
                n = this.bdis.read(byArray, 0, this.available_bytes);
                this.readingByteArray = false;
            } else {
                n = this.bdis.read(byArray, 0, byArray.length);
                this.available_bytes -= byArray.length;
            }
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new JMSException("Error reading from stream", arrayIndexOutOfBoundsException);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new JMSException("Error reading from stream", arrayStoreException);
        }
        return n;
    }

    public Object readObject() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 1: {
                    return new Boolean(this.bdis.readBoolean());
                }
                case 2: {
                    return new Byte(this.bdis.readByte());
                }
                case 8: {
                    return new Short(this.bdis.readShort());
                }
                case 3: {
                    return new Character(this.bdis.readChar());
                }
                case 6: {
                    return new Integer(this.bdis.readInt());
                }
                case 7: {
                    return new Long(this.bdis.readLong());
                }
                case 5: {
                    return new Float(this.bdis.readFloat());
                }
                case 4: {
                    return new Double(this.bdis.readDouble());
                }
                case 9: {
                    return this.readStringInternal(by);
                }
                case 10: {
                    return this.readStringInternal(by);
                }
                case 12: {
                    return null;
                }
                case 11: {
                    int n = this.bdis.readInt();
                    byte[] byArray = new byte[n];
                    int n2 = this.bdis.read(byArray, 0, n);
                    if (n2 != n) {
                        throw new EOFException("");
                    }
                    return byArray;
                }
            }
            this.bdis.unput();
            throw new MessageFormatException("Cannot convert to Object from : " + this.typeCodeToString(by));
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public void writeBoolean(boolean bl) throws javax.jms.JMSException {
        this.writeType((byte)1);
        try {
            this.bdos.writeBoolean(bl);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeByte(byte by) throws javax.jms.JMSException {
        this.writeType((byte)2);
        try {
            this.bdos.writeByte(by);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeShort(short s) throws javax.jms.JMSException {
        this.writeType((byte)8);
        try {
            this.bdos.writeShort(s);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeChar(char c) throws javax.jms.JMSException {
        this.writeType((byte)3);
        try {
            this.bdos.writeChar(c);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeInt(int n) throws javax.jms.JMSException {
        this.writeType((byte)6);
        try {
            this.bdos.writeInt(n);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeLong(long l) throws javax.jms.JMSException {
        this.writeType((byte)7);
        try {
            this.bdos.writeLong(l);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeFloat(float f) throws javax.jms.JMSException {
        this.writeType((byte)5);
        try {
            this.bdos.writeFloat(f);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeDouble(double d) throws javax.jms.JMSException {
        this.writeType((byte)4);
        try {
            this.bdos.writeDouble(d);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeString(String string) throws javax.jms.JMSException {
        if (string == null) {
            this.writeType((byte)12);
        } else {
            try {
                this.writeStringInternal(string);
            }
            catch (IOException iOException) {
                throw new JMSException("Error writing to stream", iOException);
            }
        }
    }

    public void writeBytes(byte[] byArray) throws javax.jms.JMSException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws javax.jms.JMSException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.writeType((byte)11);
        try {
            this.bdos.writeInt(n2);
            this.bdos.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeObject(Object object) throws javax.jms.JMSException {
        if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Number) {
            if (object instanceof Byte) {
                this.writeByte((Byte)object);
            } else if (object instanceof Double) {
                this.writeDouble((Double)object);
            } else if (object instanceof Float) {
                this.writeFloat(((Float)object).floatValue());
            } else if (object instanceof Integer) {
                this.writeInt((Integer)object);
            } else if (object instanceof Long) {
                this.writeLong((Long)object);
            } else if (object instanceof Short) {
                this.writeShort((Short)object);
            }
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else if (object == null) {
            this.writeType((byte)12);
        } else {
            throw new MessageFormatException("Invalid Type: " + object.getClass().getName());
        }
    }

    public void reset() throws javax.jms.JMSException {
        this.setBodyWritable(false);
        if (this.bdis != null) {
            this.bdis.reset();
        } else if (this.bdos != null) {
            this.buffer = this.bdos.getBuffer();
            this.length = this.bdos.size();
            this.bdos = null;
        }
        this.copyOnWrite = false;
    }

    public MessageImpl copy() {
        StreamMessageImpl streamMessageImpl = new StreamMessageImpl();
        super.copy(streamMessageImpl);
        if (this.bdos != null) {
            streamMessageImpl.buffer = this.bdos.getBuffer();
            streamMessageImpl.length = this.bdos.size();
            this.copyOnWrite = true;
        } else {
            streamMessageImpl.buffer = this.buffer;
            streamMessageImpl.length = this.length;
        }
        streamMessageImpl.setBodyWritable(false);
        return streamMessageImpl;
    }

    protected void checkWritable() throws javax.jms.JMSException {
        super.writeMode();
        if (this.bdos == null) {
            this.bdos = new BufferDataOutputStream(null, 256);
        } else if (this.copyOnWrite) {
            this.bdos.copyBuffer();
            this.copyOnWrite = false;
        }
    }

    protected void checkReadable() throws javax.jms.JMSException {
        super.readMode();
        if (this.buffer == null || this.length == 0) {
            throw new MessageEOFException("Attempt to read past end of message");
        }
        if (this.bdis == null) {
            this.bdis = new BufferDataInputStream(null, this.buffer, 0, this.length);
        }
    }

    public String toString() {
        return "StreamMessage[" + this.getJMSMessageID() + "]";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        byte[] byArray;
        super.writeExternal(objectOutput);
        objectOutput.writeByte(2);
        if (this.bdos != null) {
            byArray = this.bdos.getBuffer();
            n = this.bdos.size();
        } else {
            byArray = this.buffer;
            n = this.length;
        }
        if (byArray == null || n == 0) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(n);
            objectOutput.write(byArray, 0, n);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        if (by != 1 && by != 2) {
            throw JMSUtilities.versionIOException(by, 1, 2);
        }
        if (by == 1) {
            this.length = objectInput.readInt();
            this.buffer = new byte[this.length];
            objectInput.readFully(this.buffer);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buffer);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.setBodyWritable(true);
            try {
                while (true) {
                    this.writeObject(objectInputStream.readObject());
                }
            }
            catch (EOFException eOFException) {
                try {
                    this.reset();
                    byte[] byArray = new byte[this.length];
                    System.arraycopy(this.buffer, 0, byArray, 0, this.length);
                    this.buffer = byArray;
                }
                catch (javax.jms.JMSException jMSException) {
                    JMSLogger.logStackTrace(jMSException);
                }
            }
            catch (MessageNotWriteableException messageNotWriteableException) {
                JMSLogger.logStackTrace(messageNotWriteableException);
            }
            catch (javax.jms.MessageFormatException messageFormatException) {
                JMSLogger.logStackTrace(messageFormatException);
            }
            catch (javax.jms.JMSException jMSException) {
                JMSLogger.logStackTrace(jMSException);
            }
        } else {
            this.length = objectInput.readInt();
            if (this.length > 0) {
                this.buffer = new byte[this.length];
                objectInput.readFully(this.buffer);
            }
        }
    }

    public long getPayloadSize() {
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.buffer != null) {
            this.bodySize = this.length;
            return this.bodySize;
        }
        this.bodySize = 0L;
        return 0L;
    }

    private String typeCodeToString(int n) {
        try {
            return TYPE_CODE_STRINGS[n];
        }
        catch (Throwable throwable) {
            return TYPE_CODE_STRINGS[0];
        }
    }

    private void writeStringInternal(String string) throws IOException, javax.jms.JMSException {
        if (string.length() > 20000) {
            this.writeType((byte)10);
            this.bdos.writeUTF32(string);
        } else {
            this.writeType((byte)9);
            this.bdos.writeUTF(string);
        }
    }

    private String readStringInternal(byte by) throws IOException {
        if (by == 10) {
            return this.bdis.readUTF32();
        }
        return this.bdis.readUTF();
    }
}

