/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;

public final class TextMessageImpl
extends MessageImpl
implements TextMessage,
Externalizable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    static final long serialVersionUID = 5844425982189539558L;
    private String text;

    public TextMessageImpl() {
    }

    public TextMessageImpl(TextMessage textMessage) throws JMSException {
        this(textMessage, (Destination)null, (Destination)null);
    }

    public TextMessageImpl(TextMessage textMessage, Destination destination, Destination destination2) throws JMSException {
        super(textMessage, destination, destination2);
        this.setText(textMessage.getText());
    }

    public byte getType() {
        return 6;
    }

    public TextMessageImpl(String string) {
        this.text = string;
    }

    public void setText(String string) throws JMSException {
        this.writeMode();
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void nullBody() {
        this.text = null;
    }

    public String toString() {
        return "TextMessage[" + this.getJMSMessageID() + ", " + (this.text == null ? "null" : (this.text.length() < 40 ? this.text : this.text.substring(0, 30) + "...")) + "]";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeByte(2);
        if (this.text == null || this.text.length() == 0) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(this.text);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        if (by == 1) {
            if (objectInput.readBoolean()) {
                this.text = objectInput.readUTF();
            }
        } else if (by == 2) {
            if (objectInput.readBoolean()) {
                this.text = (String)objectInput.readObject();
            }
        } else {
            throw JMSUtilities.versionIOException(by, 1, 2);
        }
    }

    public MessageImpl copy() {
        TextMessageImpl textMessageImpl = new TextMessageImpl();
        this.copy(textMessageImpl);
        textMessageImpl.text = this.text;
        textMessageImpl.setBodyWritable(false);
        return textMessageImpl;
    }

    public long getPayloadSize() {
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.text != null) {
            this.bodySize = this.text.length();
            return this.bodySize;
        }
        this.bodySize = 0L;
        return 0L;
    }
}

