/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.jms.common.MessageFormatException;

public final class TypeConverter {
    public static boolean toBoolean(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new MessageFormatException("Cannot convert " + object + " to boolean");
    }

    public static byte toByte(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NumberFormatException("Cannot convert null to byte");
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof String) {
            return Byte.parseByte((String)object);
        }
        throw new MessageFormatException("Cannot convert " + object + " to byte");
    }

    public static short toShort(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NumberFormatException("Cannot convert null to short");
        }
        if (object instanceof Byte || object instanceof Short) {
            return ((Number)object).shortValue();
        }
        if (object instanceof String) {
            return Short.parseShort((String)object);
        }
        throw new MessageFormatException("Cannot convert " + object + " to short");
    }

    public static char toChar(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NullPointerException("Cannot convert null to char");
        }
        try {
            Character c = (Character)object;
            return c.charValue();
        }
        catch (ClassCastException classCastException) {
            try {
                String string = (String)object;
                if (string.length() == 1) {
                    return string.charAt(0);
                }
            }
            catch (ClassCastException classCastException2) {
                // empty catch block
            }
            throw new MessageFormatException("Cannot convert " + object + " to char");
        }
    }

    public static int toInt(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NumberFormatException("Cannot convert null to int");
        }
        if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        throw new MessageFormatException("Cannot convert " + object + " to int");
    }

    public static long toLong(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NumberFormatException("Cannot convert null to long");
        }
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        throw new MessageFormatException("Cannot convert " + object + " to long");
    }

    public static float toFloat(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NullPointerException("Cannot convert null to float");
        }
        if (object instanceof Float) {
            return ((Number)object).floatValue();
        }
        if (object instanceof String) {
            return Float.valueOf((String)object).floatValue();
        }
        throw new MessageFormatException("Cannot convert " + object + " to float");
    }

    public static double toDouble(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NullPointerException("Cannot convert null to double");
        }
        if (object instanceof Double || object instanceof Float) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.valueOf((String)object);
        }
        throw new MessageFormatException("Cannot convert " + object + " to double");
    }

    public static String toString(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            throw new MessageFormatException("Cannot convert to byte[] to string");
        }
        return object == null ? null : object.toString();
    }

    public static byte[] toByteArray(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            return null;
        }
        try {
            return (byte[])object;
        }
        catch (ClassCastException classCastException) {
            throw new MessageFormatException("Cannot convert " + object + " to byte[]");
        }
    }
}

