/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jms.JMSException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.XMLMessage;
import weblogic.utils.AssertionError;

public final class XMLMessageImpl
extends MessageImpl
implements XMLMessage,
Externalizable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    static final long serialVersionUID = -7021112875012439613L;
    private String text;
    private transient Document document;
    static /* synthetic */ Class class$weblogic$jms$common$XMLMessageImpl;

    public XMLMessageImpl() {
    }

    public XMLMessageImpl(XMLMessage xMLMessage) throws JMSException {
        super(xMLMessage);
        this.text = xMLMessage.getText();
    }

    public XMLMessageImpl(String string) {
        this.text = string;
    }

    public byte getType() {
        return 7;
    }

    public MessageImpl copy() {
        XMLMessageImpl xMLMessageImpl = new XMLMessageImpl(this.text);
        this.copy(xMLMessageImpl);
        xMLMessageImpl.document = this.document;
        xMLMessageImpl.text = this.text;
        return xMLMessageImpl;
    }

    private synchronized void setDocument(Document document) {
        this.document = document;
    }

    Document getDocument() {
        return this.document;
    }

    public synchronized Object parse() throws ParserConfigurationException, SAXException, IOException {
        Document document;
        if (JMSDebug.debugJMSCommon) {
            JMSDebug.debug(16, "Entering XMLMessageImpl.parse()");
        }
        if ((document = this.getDocument()) != null) {
            return document;
        }
        if (JMSDebug.debugJMSCommon) {
            JMSDebug.debug(16, "XMLMessageImpl.parse(): DOM document is null");
        }
        try {
            Class<?> clazz = Class.forName("weblogic.jms.common.XMLMessageParser");
            Method method = clazz.getMethod("parse", class$weblogic$jms$common$XMLMessageImpl == null ? (class$weblogic$jms$common$XMLMessageImpl = XMLMessageImpl.class$("weblogic.jms.common.XMLMessageImpl")) : class$weblogic$jms$common$XMLMessageImpl);
            document = (Document)method.invoke(null, this);
            this.setDocument(document);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ParserConfigurationException) {
                throw (ParserConfigurationException)throwable;
            }
            if (throwable instanceof SAXException) {
                throw (SAXException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new AssertionError(throwable);
        }
        catch (Exception exception) {
            throw new AssertionError(exception);
        }
        return document;
    }

    public void setText(String string) throws JMSException {
        this.writeMode();
        this.text = string;
    }

    void setTextInternal(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void nullBody() {
        this.text = null;
        this.document = null;
    }

    public String toString() {
        return "XMLMessage[id=" + this.getJMSMessageID() + ",text=" + (this.text == null ? "null" : (this.text.length() < 40 ? this.text : this.text.substring(0, 30) + "...")) + "]";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeByte(2);
        if (this.text == null || this.text.length() == 0) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(this.text);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        if (by != 1 && by != 2) {
            throw JMSUtilities.versionIOException(by, 1, 2);
        }
        if (by == 2) {
            if (objectInput.readBoolean()) {
                this.text = (String)objectInput.readObject();
            }
        } else {
            this.text = objectInput.readUTF();
        }
    }

    public long getPayloadSize() {
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.text != null) {
            this.bodySize = this.text.length();
            return this.bodySize;
        }
        this.bodySize = 0L;
        return 0L;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

