/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSUtilities;

public final class DispatcherId
implements Externalizable,
Comparable {
    static final long serialVersionUID = 2503587581403689795L;
    private String name;
    private int hashCode;
    private boolean isServer;
    private static final byte EXTVERSION = 1;

    public DispatcherId(String string) {
        this.name = string;
        this.isServer = !string.startsWith("weblogic.jms.C:");
        this.hashCode = string.hashCode();
    }

    public boolean isServer() {
        return this.isServer;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof DispatcherId)) {
            return false;
        }
        DispatcherId dispatcherId = (DispatcherId)object;
        return this == dispatcherId || this.hashCode == dispatcherId.hashCode && this.name.equals(dispatcherId.name);
    }

    public final int compareTo(Object object) {
        int n = ((DispatcherId)object).hashCode;
        if (this.hashCode < n) {
            return -1;
        }
        if (this.hashCode > n) {
            return 1;
        }
        if (this.name.length() < ((DispatcherId)object).name.length()) {
            return -1;
        }
        if (this.name.length() > ((DispatcherId)object).name.length()) {
            return 1;
        }
        return this.name.compareTo(((DispatcherId)object).name);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return this.name;
    }

    public DispatcherId() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        objectOutput.writeUTF(this.name);
        objectOutput.writeInt(this.hashCode);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        this.name = objectInput.readUTF();
        this.isServer = !this.name.startsWith("weblogic.jms.C:");
        this.hashCode = objectInput.readInt();
    }
}

