/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.rmi.RemoteException;
import javax.jms.JMSException;
import javax.transaction.Transaction;
import weblogic.jms.JMSLogger;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.common.TestHelper;
import weblogic.jms.dispatcher.Dispatcher;
import weblogic.jms.dispatcher.DispatcherException;
import weblogic.jms.dispatcher.DispatcherId;
import weblogic.jms.dispatcher.DispatcherManager;
import weblogic.jms.dispatcher.DispatcherOneWay;
import weblogic.jms.dispatcher.DispatcherRemote;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.Response;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.rmi.extensions.server.ReferenceHelper;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;
import weblogic.utils.AssertionError;

public final class DispatcherImpl
implements Dispatcher,
DispatcherRemote,
DispatcherOneWay {
    private String name;
    private DispatcherId dispatcherId;
    private DispatcherWrapper localDispatcherWrapper;
    static final boolean USEASYNC4NOREPLY = false;
    static final VoidResponse USEASYNC4NOREPLYRESPONSE = null;
    private static final ClientTransactionManager tm = TransactionHelper.getTransactionHelper().getTransactionManager();
    public static final boolean TESTXA = false;
    private TestHelper testHelper;
    static /* synthetic */ Class class$java$lang$Object;

    DispatcherImpl(DispatcherManager dispatcherManager, String string, DispatcherId dispatcherId) {
        this.name = string;
        this.dispatcherId = dispatcherId;
        this.localDispatcherWrapper = new DispatcherWrapper(this);
    }

    public String getName() {
        return this.name;
    }

    public void addRefCount() {
    }

    public boolean removeRefCount() {
        return true;
    }

    void export() {
        try {
            ReferenceHelper.getReferenceHelper().exportObject(this);
        }
        catch (RemoteException remoteException) {
            throw new AssertionError("cannot export to IIOP", remoteException);
        }
    }

    void unexport() {
        try {
            ReferenceHelper.getReferenceHelper().unexportObject(this);
        }
        catch (RemoteException remoteException) {
            throw new AssertionError("cannot unexport from IIOP", remoteException);
        }
    }

    public DispatcherId getId() {
        return this.dispatcherId;
    }

    public DispatcherWrapper getLocalDispatcherWrapper() {
        return this.localDispatcherWrapper;
    }

    public boolean equals(Object object) {
        if (object instanceof DispatcherImpl) {
            DispatcherImpl dispatcherImpl = (DispatcherImpl)object;
            return this == dispatcherImpl || (this.dispatcherId == dispatcherImpl.getId() || this.dispatcherId.equals(dispatcherImpl.getId())) && (this.name == dispatcherImpl.getName() || this.name.equals(dispatcherImpl.getName()));
        }
        return false;
    }

    public void dispatchAsync(Request request) {
        request.setTranInfo(2);
        this.dispatchAsyncInternal(request);
    }

    private void dispatchAsyncInternal(Request request) {
        try {
            request.wrappedFiniteStateMachine();
        }
        catch (Throwable throwable) {
            request.notifyResult(throwable, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void cautiousResume(Object object, Transaction transaction) {
        try {
            Transaction transaction2 = tm.forceSuspend();
            if (transaction2 != null) {
                JMSLogger.logStackTraceDebug(new Exception("debug_STATIC " + object + " retained " + transaction2));
            }
            Object var4_3 = null;
            if (transaction != null) {
                tm.forceResume(transaction);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (transaction != null) {
                tm.forceResume(transaction);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchNoReply(Request request) {
        Transaction transaction = tm.forceSuspend();
        try {
            this.dispatchAsyncInternal(request);
        }
        finally {
            DispatcherImpl.cautiousResume(request, transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response dispatchSync(Request request) throws JMSException {
        Transaction transaction = tm.forceSuspend();
        try {
            request.setTranInfo(2);
            Response response = request.wrappedFiniteStateMachine();
            return response;
        }
        finally {
            DispatcherImpl.cautiousResume(request, transaction);
        }
    }

    public Response dispatchSyncTran(Request request) throws JMSException {
        request.setTranInfo(2);
        return request.wrappedFiniteStateMachine();
    }

    public Response dispatchSyncFuture(Request request) throws JMSException {
        throw new Error("compiler error");
    }

    public void dispatchSyncFuture(Request request, FutureResponse futureResponse) {
        request.setTranInfo(0);
        request.setFutureResponse(futureResponse);
        this.dispatchAsyncInternal(request);
    }

    public Response dispatchSyncTranFuture(Request request) throws JMSException {
        throw new Error("compiler error");
    }

    public void dispatchSyncTranFuture(Request request, FutureResponse futureResponse) {
        request.setTranInfo(2);
        request.setFutureResponse(futureResponse);
        this.dispatchAsyncInternal(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response dispatchSyncNoTran(Request request) throws JMSException {
        Transaction transaction = tm.forceSuspend();
        try {
            Response response = request.wrappedFiniteStateMachine();
            return response;
        }
        finally {
            DispatcherImpl.cautiousResume(request, transaction);
        }
    }

    public Response dispatchSyncNoTranFuture(Request request) throws JMSException {
        throw new Error("compiler error");
    }

    public void dispatchSyncNoTranFuture(Request request, FutureResponse futureResponse) {
        request.setTranInfo(0);
        request.setFutureResponse(futureResponse);
        this.dispatchAsyncInternal(request);
    }

    public void dispatchAsync(Request request, AsyncResult asyncResult) {
        request.setAsyncResult(asyncResult);
        this.dispatchAsyncInternal(request);
    }

    public void dispatchAsyncFuture(Request request, AsyncResult asyncResult) {
        throw new Error("compiler error");
    }

    public void dispatchAsyncFuture(Request request, AsyncResult asyncResult, FutureResponse futureResponse) {
        if (JMSDebug.debugJMSDispatcher) {
            JMSDebug.debug(2048, "DispatcherImpl.dispatchAsyncFuture() : " + request);
        }
        request.setAsyncResult(asyncResult);
        request.setFutureResponse(futureResponse);
        this.dispatchAsyncInternal(request);
    }

    public void dispatchAsyncTranFuture(Request request, AsyncResult asyncResult) {
        throw new Error("compiler error");
    }

    public void dispatchAsyncTranFuture(Request request, AsyncResult asyncResult, FutureResponse futureResponse) {
        if (JMSDebug.debugJMSDispatcher) {
            JMSDebug.debug(2048, "DispatcherImpl.dispatchAsyncFuture() : " + request);
        }
        request.setTranInfo(2);
        request.setAsyncResult(asyncResult);
        request.setFutureResponse(futureResponse);
        this.dispatchAsyncInternal(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchOneWay(Request request) {
        Transaction transaction = tm.forceSuspend();
        try {
            this.dispatchAsyncInternal(request);
        }
        finally {
            DispatcherImpl.cautiousResume(request, transaction);
        }
    }

    public void dispatchOneWayTran(Request request) {
        request.setTranInfo(2);
        this.dispatchOneWay(request);
    }

    public void responseOneWay(Response response) {
    }

    public void responseOneWayTran(Response response) {
        this.responseOneWayTran(response);
    }

    public void addPeerGoneListener() {
    }

    public JMSPeerGoneListener addDispatcherPeerGoneListener(JMSPeerGoneListener jMSPeerGoneListener) {
        return null;
    }

    public void removeDispatcherPeerGoneListener(JMSPeerGoneListener jMSPeerGoneListener) {
    }

    public void removePeerGoneListener() {
    }

    public boolean ready() {
        return true;
    }

    public boolean peerIsGone() {
        return false;
    }

    public void sleepTillNotified() throws DispatcherException {
    }

    public final boolean deleteNotify() {
        return false;
    }

    public void setTestHelper(TestHelper testHelper) {
        this.testHelper = testHelper;
    }

    private void test(String string, boolean bl) throws Throwable {
        if (this.testHelper != null) {
            this.testHelper.enlist(string, bl);
        }
    }

    public void testSync(boolean bl) {
        try {
            this.test("testSync", bl);
        }
        catch (Throwable throwable) {
            JMSLogger.logStackTraceDebug(throwable);
        }
    }

    public void testFuture(boolean bl) {
        throw new Error("unreachable");
    }

    public void testFuture(boolean bl, FutureResponse futureResponse) {
        try {
            this.test("testFuture", bl);
            futureResponse.getMsgOutput().writeObject(null, class$java$lang$Object == null ? (class$java$lang$Object = DispatcherImpl.class$("java.lang.Object")) : class$java$lang$Object);
            futureResponse.send();
        }
        catch (Throwable throwable) {
            JMSLogger.logStackTraceDebug(throwable);
        }
    }

    public void testAsyncFuture(boolean bl) {
        throw new Error("unreachable");
    }

    public void testAsyncFuture(boolean bl, AsyncResult asyncResult) {
        throw new Error("unreachable");
    }

    public void testAsyncFuture(boolean bl, AsyncResult asyncResult, FutureResponse futureResponse) {
        try {
            this.test("testAsyncFuture", bl);
            asyncResult.setResult(null);
            futureResponse.send();
        }
        catch (Throwable throwable) {
            JMSLogger.logStackTraceDebug(throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

