/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.jms.JMSLogger;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.dispatcher.Dispatcher;
import weblogic.jms.dispatcher.DispatcherException;
import weblogic.jms.dispatcher.DispatcherId;
import weblogic.jms.dispatcher.DispatcherImpl;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.DispatcherWrapperState;
import weblogic.jms.dispatcher.HandshakeRequest;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableMonitor;
import weblogic.jms.dispatcher.Request;
import weblogic.kernel.Kernel;
import weblogic.rmi.extensions.server.HeartbeatMonitor;
import weblogic.rmi.extensions.server.HeartbeatMonitorUnavailableException;
import weblogic.security.SpinnerRandomBitsSource;

public final class DispatcherManager
implements Invocable {
    public static final String PREFIX_SERVER_NAME = "weblogic.jms.S:";
    public static final String PREFIX_CLIENT_NAME = "weblogic.jms.C:";
    private DispatcherImpl localDispatcher;
    private DispatcherId dispatcherId;
    private HashMap dispatchers = new HashMap();
    private HashMap hellos = new HashMap();
    private static DispatcherManager dispatcherManager;
    private static JMSException clusterProcessCheckException;
    private static final String JMS_EXECUTE_QUEUE_NAME = "JmsDispatcher";

    private DispatcherManager(String string) {
        this.dispatcherId = new DispatcherId(string);
        this.initializeThreadPool();
        this.localDispatcher = new DispatcherImpl(this, string, this.dispatcherId);
    }

    public static DispatcherManager get() {
        return dispatcherManager;
    }

    public JMSID getId() {
        return null;
    }

    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    public static synchronized DispatcherManager create() {
        if (dispatcherManager != null) {
            return dispatcherManager;
        }
        String string = PREFIX_CLIENT_NAME + DispatcherManager.getHostAddress() + ":" + Long.toString(System.currentTimeMillis() & 0xFFFFL, 36) + ":" + Long.toString(DispatcherManager.generateRandomLong(), 36);
        dispatcherManager = new DispatcherManager(string);
        return dispatcherManager;
    }

    public static synchronized DispatcherManager initializeServer(String string, JMSException jMSException) throws DispatcherException {
        clusterProcessCheckException = jMSException;
        dispatcherManager = new DispatcherManager(string);
        return dispatcherManager;
    }

    private synchronized DispatcherWrapperState dispatcherAdd(DispatcherWrapperState dispatcherWrapperState) throws DispatcherException {
        return this.dispatcherAdd(dispatcherWrapperState, true);
    }

    private synchronized DispatcherWrapperState dispatcherAdd(DispatcherWrapperState dispatcherWrapperState, boolean bl) throws DispatcherException {
        try {
            if (bl) {
                dispatcherWrapperState.addPeerGoneListener();
            }
        }
        catch (Throwable throwable) {
            JMSLogger.logUnhandledException("add JMS Dispatcher peerGone", "addPeerGoneListener", throwable);
        }
        if (dispatcherWrapperState.getPeerGoneCache()) {
            DispatcherWrapperState dispatcherWrapperState2 = (DispatcherWrapperState)this.dispatchers.get(dispatcherWrapperState.getId());
            if (dispatcherWrapperState2 == null || dispatcherWrapperState2.getPeerGoneCache()) {
                DispatcherException dispatcherException = new DispatcherException("can not add a disconnected JMS Dispatcher " + this.dispatcherId);
                if (JMSDebug.debugJMSDispatcher) {
                    JMSDebug.debug(2048, "dispatch to peerGone failed.", dispatcherException);
                }
                throw dispatcherException;
            }
            dispatcherWrapperState = dispatcherWrapperState2;
        } else {
            DispatcherWrapperState dispatcherWrapperState3 = this.dispatchers.put(dispatcherWrapperState.getId(), dispatcherWrapperState);
            if (dispatcherWrapperState3 != null && !dispatcherWrapperState3.getPeerGoneCache() && dispatcherWrapperState3.getDispatcherWrapper().equals(dispatcherWrapperState.getDispatcherWrapper())) {
                this.dispatchers.put(dispatcherWrapperState3.getId(), dispatcherWrapperState3);
                dispatcherWrapperState = dispatcherWrapperState3;
            }
        }
        dispatcherWrapperState.addRefCount();
        return dispatcherWrapperState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Dispatcher addDispatcherReference(Dispatcher dispatcher) throws DispatcherException {
        if (DispatcherManager.getLocalDispatcher().getId().equals(dispatcher.getId())) {
            return dispatcher;
        }
        DispatcherWrapperState dispatcherWrapperState = this.dispatcherAdd((DispatcherWrapperState)dispatcher);
        if (!dispatcherWrapperState.ready()) {
            DispatcherWrapperState dispatcherWrapperState2 = dispatcherWrapperState;
            synchronized (dispatcherWrapperState2) {
                dispatcherWrapperState.handshakeDone();
            }
        }
        return dispatcherWrapperState;
    }

    public synchronized Dispatcher dispatcherRemoveReference(Dispatcher dispatcher, boolean bl) {
        if (dispatcher.removeRefCount() && !bl) {
            return dispatcher;
        }
        if (dispatcher.deleteNotify()) {
            Dispatcher dispatcher2 = (Dispatcher)this.dispatchers.get(dispatcher.getId());
            if (dispatcher2 != dispatcher) {
                return dispatcher;
            }
            return (Dispatcher)this.dispatchers.remove(dispatcher.getId());
        }
        return dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dispatcher internalDispatcherFind(DispatcherId dispatcherId) throws DispatcherException {
        if (dispatcherId == null) {
            throw new DispatcherException("null dispatcherId");
        }
        if (DispatcherManager.dispatcherManager.localDispatcher.getId().equals(dispatcherId)) {
            return DispatcherManager.dispatcherManager.localDispatcher;
        }
        DispatcherManager dispatcherManager = DispatcherManager.dispatcherManager;
        synchronized (dispatcherManager) {
            DispatcherWrapperState dispatcherWrapperState = (DispatcherWrapperState)DispatcherManager.dispatcherManager.dispatchers.get(dispatcherId);
            if (dispatcherWrapperState == null) {
                throw new DispatcherException("Dispatcher not found, " + dispatcherId);
            }
            if (dispatcherWrapperState.ready()) {
                dispatcherWrapperState.addRefCount();
            }
            return dispatcherWrapperState;
        }
    }

    public static Dispatcher dispatcherFind(DispatcherId dispatcherId) throws DispatcherException {
        Dispatcher dispatcher = DispatcherManager.internalDispatcherFind(dispatcherId);
        if (dispatcher.ready()) {
            return dispatcher;
        }
        return DispatcherManager.handshakeDispatcher((DispatcherWrapperState)dispatcher);
    }

    public static String getDispatcherJNDIName(DispatcherId dispatcherId) {
        return PREFIX_SERVER_NAME + dispatcherId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Dispatcher dispatcherCreate(DispatcherId dispatcherId) throws DispatcherException {
        DispatcherWrapper dispatcherWrapper;
        InitialContext initialContext = null;
        try {
            try {
                initialContext = new InitialContext();
                dispatcherWrapper = (DispatcherWrapper)initialContext.lookup(DispatcherManager.getDispatcherJNDIName(dispatcherId));
                try {
                    HeartbeatMonitor.getHeartbeatMonitor().addHeartbeatMonitorListener(dispatcherWrapper.getRemoteDispatcher(), dispatcherWrapper);
                }
                catch (HeartbeatMonitorUnavailableException heartbeatMonitorUnavailableException) {
                    DispatcherException dispatcherException = new DispatcherException(heartbeatMonitorUnavailableException.getMessage() + " for " + dispatcherId);
                    dispatcherException.initCause(heartbeatMonitorUnavailableException);
                    throw dispatcherException;
                }
                Object var6_7 = null;
                if (initialContext == null) return DispatcherManager.handshakeDispatcher(dispatcherManager.dispatcherAdd(new DispatcherWrapperState(dispatcherWrapper), false));
            }
            catch (NamingException namingException) {
                DispatcherException dispatcherException = new DispatcherException("could not find JMS Server " + dispatcherId);
                dispatcherException.initCause(namingException);
                throw dispatcherException;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (initialContext == null) throw throwable;
            try {
                initialContext.close();
                throw throwable;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (NamingException namingException) {}
        initialContext.close();
        return DispatcherManager.handshakeDispatcher(dispatcherManager.dispatcherAdd(new DispatcherWrapperState(dispatcherWrapper), false));
    }

    private static Dispatcher dispatcherCreate(DispatcherWrapperState dispatcherWrapperState) throws DispatcherException {
        DispatcherId dispatcherId = dispatcherWrapperState.getId();
        if (DispatcherManager.dispatcherManager.localDispatcher.getId().equals(dispatcherId)) {
            return DispatcherManager.dispatcherManager.localDispatcher;
        }
        dispatcherWrapperState = dispatcherManager.dispatcherAdd(dispatcherWrapperState);
        return DispatcherManager.handshakeDispatcher(dispatcherWrapperState);
    }

    public static Dispatcher dispatcherFindOrCreate(DispatcherId dispatcherId) throws DispatcherException {
        try {
            return DispatcherManager.dispatcherFind(dispatcherId);
        }
        catch (DispatcherException dispatcherException) {
            return DispatcherManager.dispatcherCreate(dispatcherId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dispatcher dispatcherFindOrCreate(Dispatcher dispatcher) throws DispatcherException {
        DispatcherWrapperState dispatcherWrapperState;
        if (this.localDispatcher.getId().equals(dispatcher.getId())) {
            return this.localDispatcher;
        }
        if (((DispatcherWrapperState)dispatcher).getDispatcherWrapper().getId() == null) {
            throw new DispatcherException("null dispatcherId");
        }
        DispatcherManager dispatcherManager = DispatcherManager.dispatcherManager;
        synchronized (dispatcherManager) {
            dispatcherWrapperState = (DispatcherWrapperState)DispatcherManager.dispatcherManager.dispatchers.get(dispatcher.getId());
            if (dispatcherWrapperState == null) {
                return DispatcherManager.dispatcherCreate((DispatcherWrapperState)dispatcher);
            }
        }
        dispatcherWrapperState = this.dispatcherAdd(dispatcherWrapperState);
        if (dispatcherWrapperState.ready()) {
            return dispatcherWrapperState;
        }
        return DispatcherManager.handshakeDispatcher(dispatcherWrapperState);
    }

    public static Dispatcher dispatcherFindOrCreateChecked(DispatcherId dispatcherId) throws DispatcherException, JMSException {
        if (clusterProcessCheckException != null && dispatcherId.isServer() && !DispatcherManager.dispatcherManager.dispatcherId.equals(dispatcherId)) {
            throw new weblogic.jms.common.JMSException(clusterProcessCheckException.getMessage());
        }
        return DispatcherManager.dispatcherFindOrCreate(dispatcherId);
    }

    public static Dispatcher getLocalDispatcher() {
        return DispatcherManager.dispatcherManager.localDispatcher;
    }

    public DispatcherWrapper getLocalDispatcherWrapper() throws DispatcherException {
        return this.localDispatcher.getLocalDispatcherWrapper();
    }

    public static void exportLocalDispatcher() {
        DispatcherManager.dispatcherManager.localDispatcher.export();
    }

    public static void unexportLocalDispatcher() {
        DispatcherManager.dispatcherManager.localDispatcher.unexport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Dispatcher handshakeDispatcher(DispatcherWrapperState dispatcherWrapperState) throws DispatcherException {
        boolean bl;
        Object object = dispatcherManager;
        // MONITORENTER : object
        if (dispatcherWrapperState.getPeerGoneCache()) {
            if (DispatcherManager.dispatcherManager.hellos.get(dispatcherWrapperState.getId()) != dispatcherWrapperState) throw new DispatcherException("Dispatcher negotiation to peerGone node failed " + dispatcherWrapperState.getId());
            DispatcherManager.dispatcherManager.hellos.remove(dispatcherWrapperState.getId());
            dispatcherManager.dispatcherRemoveReference(dispatcherWrapperState, true);
            throw new DispatcherException("Dispatcher negotiation to peerGone node failed " + dispatcherWrapperState.getId());
        }
        if (dispatcherWrapperState.ready()) {
            // MONITOREXIT : object
            return dispatcherWrapperState;
        }
        Serializable serializable = dispatcherWrapperState;
        // MONITORENTER : serializable
        if (dispatcherWrapperState.ready()) {
            // MONITOREXIT : serializable
            // MONITOREXIT : object
            return dispatcherWrapperState;
        }
        Dispatcher dispatcher = DispatcherManager.dispatcherManager.hellos.put(dispatcherWrapperState.getId(), dispatcherWrapperState);
        if (dispatcher != null) {
            bl = true;
            DispatcherManager.dispatcherManager.hellos.put(dispatcher.getId(), dispatcher);
        } else {
            bl = false;
        }
        // MONITOREXIT : serializable
        // MONITOREXIT : object
        if (bl) {
            object = dispatcher;
            // MONITORENTER : object
            dispatcher.sleepTillNotified();
            dispatcher.addRefCount();
            // MONITOREXIT : object
            return dispatcher;
        }
        try {
            try {
                dispatcherWrapperState.dispatchSync(new HandshakeRequest(dispatcherManager.getLocalDispatcherWrapper()));
                dispatcherWrapperState.addPeerGoneListener();
                object = dispatcherManager;
                // MONITORENTER : object
                serializable = dispatcherWrapperState;
                // MONITORENTER : serializable
                dispatcherWrapperState.handshakeDone();
                // MONITOREXIT : serializable
                // MONITOREXIT : object
                dispatcherWrapperState.addRefCount();
                object = dispatcherWrapperState;
                Object var11_7 = null;
                DispatcherManager dispatcherManager = DispatcherManager.dispatcherManager;
            }
            catch (DispatcherException dispatcherException) {
                dispatcherWrapperState.peerGone(dispatcherException, false);
                throw dispatcherException;
            }
            catch (Throwable throwable) {
                serializable = new DispatcherException(throwable.getMessage());
                ((Throwable)serializable).initCause(throwable);
                dispatcherWrapperState.peerGone((Exception)serializable, false);
                throw serializable;
            }
            // MONITORENTER : dispatcherManager
            DispatcherManager.dispatcherManager.hellos.remove(dispatcherWrapperState.getId());
            // MONITOREXIT : dispatcherManager
            if (dispatcherWrapperState.ready()) return object;
            dispatcherManager.dispatcherRemoveReference(dispatcherWrapperState, true);
            return object;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            DispatcherManager dispatcherManager = DispatcherManager.dispatcherManager;
            // MONITORENTER : dispatcherManager
            DispatcherManager.dispatcherManager.hellos.remove(dispatcherWrapperState.getId());
            // MONITOREXIT : dispatcherManager
            if (dispatcherWrapperState.ready()) throw throwable;
            DispatcherManager.dispatcherManager.dispatcherRemoveReference(dispatcherWrapperState, true);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int remoteHello(DispatcherWrapperState dispatcherWrapperState) throws JMSException {
        try {
            DispatcherManager dispatcherManager = DispatcherManager.dispatcherManager;
            synchronized (dispatcherManager) {
                DispatcherWrapperState dispatcherWrapperState2 = dispatcherWrapperState;
                synchronized (dispatcherWrapperState2) {
                    dispatcherWrapperState.handshakeDone();
                }
                DispatcherManager.dispatcherManager.dispatcherAdd(dispatcherWrapperState);
            }
        }
        catch (DispatcherException dispatcherException) {
            throw new weblogic.jms.common.JMSException(dispatcherException.getMessage(), dispatcherException);
        }
        return Integer.MAX_VALUE;
    }

    public int invoke(Request request) throws Throwable {
        switch (request.getMethodId()) {
            case 15872: {
                return this.remoteHello(new DispatcherWrapperState(((HandshakeRequest)request).getClientWrapper()));
            }
        }
        throw new weblogic.jms.common.JMSException("No such method " + request.getMethodId());
    }

    private void initializeThreadPool() {
        Kernel.ensureInitialized();
        int n = Kernel.getConfig().getJMSThreadPoolSize();
        if (n < 5 && (Kernel.isServer() || n > 0)) {
            n = 5;
        }
        Kernel.addExecuteQueue(JMS_EXECUTE_QUEUE_NAME, 0, n, n);
    }

    private static String getHostAddress() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "UNKNOWN";
        }
    }

    private static long generateRandomLong() {
        SpinnerRandomBitsSource spinnerRandomBitsSource = new SpinnerRandomBitsSource();
        byte[] byArray = spinnerRandomBitsSource.randomBytes(new byte[8]);
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l = l << 8 | (long)byArray[i];
        }
        return l;
    }
}

