/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.rmi.PortableRemoteObject;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Dispatcher;
import weblogic.jms.dispatcher.DispatcherId;
import weblogic.jms.dispatcher.DispatcherImpl;
import weblogic.jms.dispatcher.DispatcherOneWay;
import weblogic.jms.dispatcher.DispatcherRemote;
import weblogic.jms.dispatcher.DispatcherWrapperState;
import weblogic.rmi.extensions.server.HeartbeatMonitorListener;

public final class DispatcherWrapper
implements Externalizable,
HeartbeatMonitorListener {
    static final long serialVersionUID = -569390197367234160L;
    private static final byte EXTVERSION = 1;
    private static final byte DISPATCHER_VERSION = 8;
    private String name;
    private DispatcherId dispatcherId;
    private PeerInfo peerInfo;
    private boolean isPeerGone;
    private Object peerGoneLock = new Object();
    private DispatcherRemote dispatcherRemote;
    private DispatcherOneWay dispatcherOneWay;
    static /* synthetic */ Class class$weblogic$jms$dispatcher$DispatcherRemote;
    static /* synthetic */ Class class$weblogic$jms$dispatcher$DispatcherOneWay;

    public DispatcherWrapper(Dispatcher dispatcher) {
        this.dispatcherId = dispatcher.getId();
        this.name = dispatcher.getName();
        this.dispatcherRemote = (DispatcherRemote)((Object)dispatcher);
        this.dispatcherOneWay = (DispatcherOneWay)((Object)dispatcher);
        this.peerInfo = dispatcher instanceof DispatcherWrapperState ? ((DispatcherWrapperState)dispatcher).getPeerInfo() : PeerInfo.getPeerInfoForWire();
    }

    public DispatcherRemote getRemoteDispatcher() {
        return this.dispatcherRemote;
    }

    public DispatcherOneWay getOneWayDispatcher() {
        return this.dispatcherOneWay;
    }

    public PeerInfo getPeerInfo() {
        return this.peerInfo;
    }

    public final String getName() {
        return this.name;
    }

    public final DispatcherId getId() {
        return this.dispatcherId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callback(Exception exception) {
        Object object = this.peerGoneLock;
        synchronized (object) {
            this.isPeerGone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean getPeerGoneCache() {
        Object object = this.peerGoneLock;
        synchronized (object) {
            if (!this.isPeerGone || this.dispatcherRemote instanceof DispatcherImpl) {
                return false;
            }
            return this.isPeerGone;
        }
    }

    public final int hashCode() {
        return this.dispatcherId.hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof DispatcherWrapper)) {
            return false;
        }
        DispatcherWrapper dispatcherWrapper = (DispatcherWrapper)object;
        return this.dispatcherRemote.equals(dispatcherWrapper.dispatcherRemote) && this.dispatcherId.equals(dispatcherWrapper.dispatcherId);
    }

    public DispatcherWrapper() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        objectOutput.writeByte(8);
        if (this.name == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this.name);
        }
        if (this.dispatcherId == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            this.dispatcherId.writeExternal(objectOutput);
        }
        objectOutput.writeObject(this.peerInfo);
        objectOutput.writeObject(this.dispatcherRemote);
        objectOutput.writeObject(this.dispatcherOneWay);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        byte by2 = objectInput.readByte();
        if (by2 != 8) {
            throw JMSUtilities.versionIOException(by2, 8, 8);
        }
        if (objectInput.readBoolean()) {
            this.name = objectInput.readUTF();
        }
        if (objectInput.readBoolean()) {
            this.dispatcherId = new DispatcherId();
            this.dispatcherId.readExternal(objectInput);
        }
        this.peerInfo = (PeerInfo)objectInput.readObject();
        this.dispatcherRemote = (DispatcherRemote)PortableRemoteObject.narrow((Object)objectInput.readObject(), (Class)(class$weblogic$jms$dispatcher$DispatcherRemote == null ? (class$weblogic$jms$dispatcher$DispatcherRemote = DispatcherWrapper.class$("weblogic.jms.dispatcher.DispatcherRemote")) : class$weblogic$jms$dispatcher$DispatcherRemote));
        this.dispatcherOneWay = (DispatcherOneWay)PortableRemoteObject.narrow((Object)objectInput.readObject(), (Class)(class$weblogic$jms$dispatcher$DispatcherOneWay == null ? (class$weblogic$jms$dispatcher$DispatcherOneWay = DispatcherWrapper.class$("weblogic.jms.dispatcher.DispatcherOneWay")) : class$weblogic$jms$dispatcher$DispatcherOneWay));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

