/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.JMSException;
import javax.transaction.Transaction;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.JMSLogger;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.LostServerException;
import weblogic.jms.dispatcher.Dispatcher;
import weblogic.jms.dispatcher.DispatcherException;
import weblogic.jms.dispatcher.DispatcherId;
import weblogic.jms.dispatcher.DispatcherManager;
import weblogic.jms.dispatcher.DispatcherOneWay;
import weblogic.jms.dispatcher.DispatcherRemote;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.Response;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.Kernel;
import weblogic.rmi.extensions.AsyncResultFactory;
import weblogic.rmi.extensions.AsyncResultListener;
import weblogic.rmi.extensions.server.HeartbeatMonitor;
import weblogic.rmi.extensions.server.HeartbeatMonitorListener;
import weblogic.rmi.extensions.server.HeartbeatMonitorUnavailableException;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;

public final class DispatcherWrapperState
implements Dispatcher,
ExecuteRequest,
HeartbeatMonitorListener,
Externalizable {
    static final long serialVersionUID = -360573074488373048L;
    private static final byte EXTVERSION = 1;
    private static final byte DISPATCHER_VERSION = 8;
    private DispatcherWrapper dispatcherWrapper;
    private String name;
    private DispatcherId dispatcherId;
    private byte remoteVersion;
    private PeerInfo peerInfo;
    private DispatcherRemote dispatcherRemote;
    private DispatcherOneWay dispatcherOneWay;
    private boolean peerGoneIsOn;
    private boolean ready;
    private int numWaiting;
    private int refCount;
    private Exception exceptionForPeerGone;
    private boolean fireListeners;
    private transient Set listeners = Collections.synchronizedSet(new HashSet());
    private transient HashMap listenersMap = new HashMap();
    private static ClientTransactionManager tranManager = TransactionHelper.getTransactionHelper().getTransactionManager();
    private static final String SERVER_UTILITIES_CLASS = "weblogic.jms.common.JMSServerUtilities";

    public DispatcherWrapperState(DispatcherWrapper dispatcherWrapper) {
        this.dispatcherWrapper = dispatcherWrapper;
        this.dispatcherId = dispatcherWrapper.getId();
        this.name = dispatcherWrapper.getName();
        this.dispatcherRemote = dispatcherWrapper.getRemoteDispatcher();
        this.dispatcherOneWay = dispatcherWrapper.getOneWayDispatcher();
        this.peerInfo = dispatcherWrapper.getPeerInfo();
    }

    public DispatcherWrapper getDispatcherWrapper() {
        return this.dispatcherWrapper;
    }

    public PeerInfo getPeerInfo() {
        return this.peerInfo;
    }

    final boolean getPeerGoneCache() {
        return this.dispatcherWrapper.getPeerGoneCache();
    }

    final void handshakeDone() {
        if (!this.getPeerGoneCache()) {
            this.ready = true;
        }
        if (!this.peerGoneIsOn) {
            try {
                this.addPeerGoneListener();
            }
            catch (DispatcherException dispatcherException) {
                // empty catch block
            }
        }
        if (this.numWaiting > 0) {
            this.notify();
        }
    }

    public boolean ready() {
        return this.ready && !this.dispatcherWrapper.getPeerGoneCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void sleepTillNotified() throws DispatcherException {
        block17: {
            block16: {
                try {
                    try {
                        ++this.numWaiting;
                        if (this.ready()) {
                            Object var3_1 = null;
                            --this.numWaiting;
                            if (this.numWaiting > 0) {
                                this.notify();
                            }
                            if (!this.getPeerGoneCache()) break block16;
                            throw new DispatcherException("Dispatcher negotiation to peerGone node failed " + this.getId());
                        }
                        this.wait();
                        break block17;
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_3 = null;
                        --this.numWaiting;
                        if (this.numWaiting > 0) {
                            this.notify();
                        }
                        if (this.getPeerGoneCache()) {
                            throw new DispatcherException("Dispatcher negotiation to peerGone node failed " + this.getId());
                        }
                        if (!this.ready()) throw new DispatcherException("Dispatcher negotiation failed");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    --this.numWaiting;
                    if (this.numWaiting > 0) {
                        this.notify();
                    }
                    if (this.getPeerGoneCache()) {
                        throw new DispatcherException("Dispatcher negotiation to peerGone node failed " + this.getId());
                    }
                    if (!this.ready()) throw new DispatcherException("Dispatcher negotiation failed");
                    return;
                }
            }
            if (!this.ready()) throw new DispatcherException("Dispatcher negotiation failed");
            return;
        }
        Object var3_2 = null;
        --this.numWaiting;
        if (this.numWaiting > 0) {
            this.notify();
        }
        if (this.getPeerGoneCache()) {
            throw new DispatcherException("Dispatcher negotiation to peerGone node failed " + this.getId());
        }
        if (!this.ready()) throw new DispatcherException("Dispatcher negotiation failed");
    }

    public synchronized boolean removeRefCount() {
        --this.refCount;
        if (this.refCount <= 0) {
            this.refCount = 0;
            return false;
        }
        return true;
    }

    public synchronized void addRefCount() {
        ++this.refCount;
    }

    public final synchronized boolean deleteNotify() {
        this.removePeerGoneListener();
        if (this.numWaiting > 0) {
            this.notify();
        }
        return true;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean equals(Object object) {
        if (object instanceof DispatcherWrapperState) {
            DispatcherWrapperState dispatcherWrapperState = (DispatcherWrapperState)object;
            return this == dispatcherWrapperState || this.dispatcherWrapper.equals(dispatcherWrapperState.dispatcherWrapper) && (this.name == dispatcherWrapperState.name || this.name != null && dispatcherWrapperState.name != null && this.name.equals(dispatcherWrapperState.getName()));
        }
        return false;
    }

    public String toString() {
        return "DispWrap #" + this.hashCode() + " " + this.dispatcherId;
    }

    public final int hashCode() {
        return this.dispatcherId.hashCode();
    }

    public final DispatcherId getId() {
        return this.dispatcherId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispatchAsync(Request request) throws DispatcherException {
        block11: {
            request.setPeerInfo(this.peerInfo);
            request.setState(-42);
            request.needOutsideResult();
            try {
                if (0 != (request.remoteSignature() & 1)) {
                    this.dispatcherRemote.dispatchAsyncTranFuture(request, AsyncResultFactory.getCallbackableResult((AsyncResultListener)request));
                    break block11;
                }
                Transaction transaction = null;
                try {
                    transaction = tranManager.forceSuspend();
                    this.dispatcherRemote.dispatchAsyncFuture(request, AsyncResultFactory.getCallbackableResult((AsyncResultListener)request));
                    Object var4_5 = null;
                    if (transaction != null) {
                        tranManager.forceResume(transaction);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (transaction != null) {
                        tranManager.forceResume(transaction);
                    }
                    throw throwable;
                }
            }
            catch (UnmarshalException unmarshalException) {
                try {
                    this.peerGone(unmarshalException, true);
                }
                finally {
                    request.resumeRequest(unmarshalException, false);
                }
            }
            catch (Throwable throwable) {
                request.resumeRequest(throwable, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispatchNoReply(Request request) throws JMSException {
        request.setPeerInfo(this.peerInfo);
        request.setState(-42);
        try {
            if (0 != (request.remoteSignature() & 1)) {
                this.dispatcherOneWay.dispatchOneWayTran(request);
            } else {
                this.dispatcherOneWay.dispatchOneWay(request);
            }
        }
        catch (UnmarshalException unmarshalException) {
            try {
                this.peerGone(unmarshalException, true);
            }
            finally {
                request.notifyResult(unmarshalException, false);
            }
        }
        catch (Throwable throwable) {
            request.notifyResult(throwable, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Response dispatchSync(Request request) throws JMSException {
        request.setPeerInfo(this.peerInfo);
        request.setState(-42);
        try {
            Response response;
            Transaction transaction = null;
            try {
                transaction = tranManager.forceSuspend();
                response = this.dispatcherRemote.dispatchSyncFuture(request);
                Object var5_12 = null;
                if (transaction != null) {
                    tranManager.forceResume(transaction);
                }
            }
            catch (Throwable throwable) {
                Object var5_13 = null;
                if (transaction != null) {
                    tranManager.forceResume(transaction);
                }
                throw throwable;
            }
            request.notifyResult(response);
            request.getResult();
            return response;
        }
        catch (JMSException jMSException) {
            request.notifyResult(jMSException, false);
            throw jMSException;
        }
        catch (RuntimeException runtimeException) {
            request.notifyResult(runtimeException, false);
            throw runtimeException;
        }
        catch (UnmarshalException unmarshalException) {
            LostServerException lostServerException = new LostServerException(unmarshalException.getMessage());
            request.notifyResult(lostServerException, false);
            throw lostServerException;
        }
        catch (RemoteException remoteException) {
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(remoteException.getMessage(), remoteException);
            request.notifyResult(remoteException, false);
            throw jMSException;
        }
        catch (Throwable throwable) {
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(throwable.getMessage(), throwable);
            request.notifyResult(jMSException, false);
            throw jMSException;
        }
    }

    public final Response dispatchSyncTran(Request request) throws JMSException {
        request.setPeerInfo(this.peerInfo);
        request.setState(-42);
        try {
            Response response = this.dispatcherRemote.dispatchSyncTranFuture(request);
            request.notifyResult(response);
            return response;
        }
        catch (JMSException jMSException) {
            request.notifyResult(jMSException, false);
            throw jMSException;
        }
        catch (RuntimeException runtimeException) {
            request.notifyResult(runtimeException, false);
            throw runtimeException;
        }
        catch (UnmarshalException unmarshalException) {
            LostServerException lostServerException = new LostServerException(unmarshalException.getMessage());
            request.notifyResult(lostServerException, false);
            throw lostServerException;
        }
        catch (RemoteException remoteException) {
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(remoteException.getMessage(), remoteException);
            request.notifyResult(remoteException, false);
            throw jMSException;
        }
        catch (Throwable throwable) {
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(throwable.getMessage(), throwable);
            request.notifyResult(jMSException, false);
            throw jMSException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Response dispatchSyncNoTran(Request request) throws JMSException {
        request.setPeerInfo(this.peerInfo);
        request.setState(-42);
        try {
            Response response;
            Transaction transaction = null;
            try {
                transaction = tranManager.forceSuspend();
                response = this.dispatcherRemote.dispatchSyncNoTranFuture(request);
                Object var5_12 = null;
                if (transaction != null) {
                    tranManager.forceResume(transaction);
                }
            }
            catch (Throwable throwable) {
                Object var5_13 = null;
                if (transaction != null) {
                    tranManager.forceResume(transaction);
                }
                throw throwable;
            }
            request.notifyResult(response);
            return response;
        }
        catch (JMSException jMSException) {
            request.notifyResult(jMSException, false);
            throw jMSException;
        }
        catch (RuntimeException runtimeException) {
            request.notifyResult(runtimeException, false);
            throw runtimeException;
        }
        catch (UnmarshalException unmarshalException) {
            LostServerException lostServerException = new LostServerException(unmarshalException.getMessage());
            request.notifyResult(lostServerException, false);
            throw lostServerException;
        }
        catch (RemoteException remoteException) {
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(remoteException.getMessage(), remoteException);
            request.notifyResult(remoteException, false);
            throw jMSException;
        }
        catch (Throwable throwable) {
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(throwable.getMessage(), throwable);
            request.notifyResult(jMSException, false);
            throw jMSException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void oneWayResponse(Response response) {
        try {
            this.dispatcherOneWay.responseOneWay(response);
        }
        catch (UnmarshalException unmarshalException) {
            try {
                this.peerGone(unmarshalException, true);
            }
            finally {
                JMSLogger.logStackTrace(unmarshalException);
            }
        }
        catch (Throwable throwable) {
            JMSLogger.logStackTrace(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void oneWayResponseTran(Response response) {
        try {
            this.dispatcherOneWay.responseOneWayTran(response);
        }
        catch (UnmarshalException unmarshalException) {
            try {
                this.peerGone(unmarshalException, true);
            }
            finally {
                JMSLogger.logStackTrace(unmarshalException);
            }
        }
        catch (Throwable throwable) {
            JMSLogger.logStackTrace(throwable);
        }
    }

    final void deliverResult(long l, Response response) {
    }

    public void callback(Exception exception) {
        this.peerGone(exception, false);
    }

    public synchronized void addPeerGoneListener() throws DispatcherException {
        if (this.dispatcherRemote == null) {
            if (this.peerGoneIsOn) {
                return;
            }
            throw new DispatcherException("dispatcherRemote is null");
        }
        if (this.peerGoneIsOn) {
            return;
        }
        HeartbeatMonitor heartbeatMonitor = HeartbeatMonitor.getHeartbeatMonitor();
        try {
            heartbeatMonitor.addHeartbeatMonitorListener(this.dispatcherRemote, this.dispatcherWrapper);
            heartbeatMonitor.addHeartbeatMonitorListener(this.dispatcherRemote, this);
        }
        catch (HeartbeatMonitorUnavailableException heartbeatMonitorUnavailableException) {
            DispatcherException dispatcherException = new DispatcherException(heartbeatMonitorUnavailableException.getMessage() + " for " + this.dispatcherId);
            dispatcherException.initCause(heartbeatMonitorUnavailableException);
            throw dispatcherException;
        }
        catch (RuntimeException runtimeException) {
            JMSLogger.logUnhandledException("add JMS Dispatcher addPeerGoneListener", this.dispatcherId.toString(), runtimeException);
            throw runtimeException;
        }
        this.peerGoneIsOn = true;
    }

    public synchronized void removePeerGoneListener() {
        if (!this.peerGoneIsOn) {
            return;
        }
        this.peerGoneIsOn = false;
        if (this.dispatcherRemote == null) {
            return;
        }
        HeartbeatMonitor heartbeatMonitor = HeartbeatMonitor.getHeartbeatMonitor();
        heartbeatMonitor.removeHeartbeatMonitorListener(this.dispatcherRemote, this);
        heartbeatMonitor.removeHeartbeatMonitorListener(this.dispatcherRemote, this.dispatcherWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSPeerGoneListener addDispatcherPeerGoneListener(JMSPeerGoneListener jMSPeerGoneListener) {
        JMSPeerGoneListener jMSPeerGoneListener2 = null;
        DispatcherWrapperState dispatcherWrapperState = this;
        synchronized (dispatcherWrapperState) {
            jMSPeerGoneListener2 = (JMSPeerGoneListener)this.listenersMap.get(jMSPeerGoneListener.getId());
            if (this.exceptionForPeerGone == null) {
                if (jMSPeerGoneListener2 == null) {
                    jMSPeerGoneListener2 = jMSPeerGoneListener;
                    this.listenersMap.put(jMSPeerGoneListener.getId(), jMSPeerGoneListener2);
                }
                jMSPeerGoneListener2.incrementRefCount();
                return jMSPeerGoneListener2;
            }
        }
        try {
            jMSPeerGoneListener.jmsPeerGone(this.exceptionForPeerGone, this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dispatcherWrapperState = this;
        synchronized (dispatcherWrapperState) {
            return jMSPeerGoneListener2 == null ? jMSPeerGoneListener : jMSPeerGoneListener2;
        }
    }

    public synchronized void removeDispatcherPeerGoneListener(JMSPeerGoneListener jMSPeerGoneListener) {
        JMSID jMSID = jMSPeerGoneListener.getId();
        JMSPeerGoneListener jMSPeerGoneListener2 = (JMSPeerGoneListener)this.listenersMap.get(jMSID);
        if (jMSPeerGoneListener2 == null) {
            return;
        }
        if (jMSPeerGoneListener2.decrementRefCount() == 0) {
            this.listenersMap.remove(jMSID);
        }
    }

    public final void execute(ExecuteThread executeThread) {
        this.peerGone(this.exceptionForPeerGone, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void peerGone(Exception exception, boolean bl) {
        boolean bl2 = false;
        try {
            Iterator iterator = this;
            // MONITORENTER : iterator
            if (this.exceptionForPeerGone != null && this.fireListeners) {
                // MONITOREXIT : iterator
                Object var9_5 = null;
                DispatcherWrapperState dispatcherWrapperState = this;
                // MONITORENTER : dispatcherWrapperState
                if (bl2) {
                    this.listenersMap.clear();
                }
                // MONITOREXIT : dispatcherWrapperState
                return;
            }
            this.exceptionForPeerGone = exception;
            // MONITOREXIT : iterator
            if (bl) {
                Kernel.execute(this);
                Object var9_6 = null;
                DispatcherWrapperState dispatcherWrapperState = this;
                // MONITORENTER : dispatcherWrapperState
                if (bl2) {
                    this.listenersMap.clear();
                }
                // MONITOREXIT : dispatcherWrapperState
                return;
            }
            bl2 = true;
            Iterator iterator2 = iterator = DispatcherManager.get();
            // MONITORENTER : iterator2
            this.ready = false;
            this.dispatcherWrapper.callback(exception);
            ((DispatcherManager)((Object)iterator)).dispatcherRemoveReference(this, true);
            // MONITOREXIT : iterator2
            iterator2 = null;
            DispatcherWrapperState dispatcherWrapperState = this;
            // MONITORENTER : dispatcherWrapperState
            this.fireListeners = true;
            iterator2 = ((HashMap)this.listenersMap.clone()).values().iterator();
            // MONITOREXIT : dispatcherWrapperState
            while (iterator2.hasNext()) {
                try {
                    ((JMSPeerGoneListener)iterator2.next()).jmsPeerGone(exception, this);
                }
                catch (Throwable throwable) {}
            }
            Object var9_7 = null;
            DispatcherWrapperState dispatcherWrapperState2 = this;
            // MONITORENTER : dispatcherWrapperState2
            if (bl2) {
                this.listenersMap.clear();
            }
            // MONITOREXIT : dispatcherWrapperState2
            return;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            DispatcherWrapperState dispatcherWrapperState = this;
            // MONITORENTER : dispatcherWrapperState
            if (bl2) {
                this.listenersMap.clear();
            }
            // MONITOREXIT : dispatcherWrapperState
            throw throwable;
        }
    }

    public DispatcherWrapperState() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        objectOutput.writeByte(8);
        if (this.name == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this.name);
        }
        if (this.dispatcherId == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            this.dispatcherId.writeExternal(objectOutput);
        }
        objectOutput.writeObject(this.peerInfo);
        objectOutput.writeObject(this.dispatcherRemote);
        objectOutput.writeObject(this.dispatcherOneWay);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        this.remoteVersion = objectInput.readByte();
        if (this.remoteVersion != 8) {
            throw JMSUtilities.versionIOException(this.remoteVersion, 8, 8);
        }
        if (objectInput.readBoolean()) {
            this.name = objectInput.readUTF();
        }
        if (objectInput.readBoolean()) {
            this.dispatcherId = new DispatcherId();
            this.dispatcherId.readExternal(objectInput);
        }
        this.peerInfo = (PeerInfo)objectInput.readObject();
        this.dispatcherRemote = (DispatcherRemote)objectInput.readObject();
        this.dispatcherOneWay = (DispatcherOneWay)objectInput.readObject();
    }

    public DispatcherRemote getRemoteDispatcher() {
        return this.dispatcherRemote;
    }

    public DispatcherOneWay getOneWayDispatcher() {
        return this.dispatcherOneWay;
    }
}

