/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.Request;

public final class HandshakeRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 7454865590727507800L;
    private DispatcherWrapper clientWrapper;
    private int type;
    private static final int HELLO = 256;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;

    public HandshakeRequest(DispatcherWrapper dispatcherWrapper) {
        super(null, 15872);
        this.type = 256;
        this.clientWrapper = dispatcherWrapper;
    }

    public DispatcherWrapper getClientWrapper() {
        return this.clientWrapper;
    }

    public int remoteSignature() {
        return 16;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1 | this.type);
        super.writeExternal(objectOutput);
        if (this.type == 256) {
            objectOutput.writeObject(this.clientWrapper);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        super.readExternal(objectInput);
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        this.type = 0x100 & n;
        if (this.type == 256) {
            this.clientWrapper = (DispatcherWrapper)objectInput.readObject();
        }
    }

    public HandshakeRequest() {
    }
}

