/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.util.HashMap;
import javax.jms.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.dispatcher.DispatcherManager;
import weblogic.jms.dispatcher.Invocable;

public final class InvocableManager {
    public static final int DISPATCHER_MANAGER = 0;
    public static final int FE_MANAGER = 1;
    public static final int BE_MANAGER = 2;
    public static final int JMS_CONNECTION = 3;
    public static final int JMS_SESSION = 4;
    public static final int JMS_PRODUCER = 5;
    public static final int JMS_CONSUMER = 6;
    public static final int FE_CONNECTION = 7;
    public static final int FE_SESSION = 8;
    public static final int FE_PRODUCER = 9;
    public static final int FE_CONSUMER = 10;
    public static final int FE_BROWSER = 11;
    public static final int FE_ENUMERATION = 12;
    public static final int FE_SEQUENCER = 13;
    public static final int BE_SERVER = 14;
    public static final int BE_CONNECTION = 15;
    public static final int BE_SESSION = 16;
    public static final int BE_CONSUMER = 17;
    public static final int BE_BROWSER = 18;
    public static final int BE_ENUMERATION = 19;
    public static final int BE_DESTINATION = 20;
    public static final int JMS_LEADER = 21;
    public static final int JMS_BROWSER = 22;
    public static final int MAXIMUM = 23;
    private static final HashMap[] INVOCABLE_MAPS = new HashMap[]{null, null, null, new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), null, new HashMap()};
    private static final String[] INVOCABLE_STRINGS = new String[]{"Manager", "Manager", "Manager", "Connection", "Session", "Producer", "Consumer", "Connection", "Session", "Producer", "Consumer", "Browser", "Enumeration", "Sequencer", "Back-End", "Connection", "Session", "Consumer", "Browser", "Enumeration", "Destination", "Leader", "Browser"};
    private static int[] invocablesHighCount = new int[23];
    private static int[] invocablesTotalCount = new int[23];
    private static Invocable[] managers = new Invocable[23];
    public static final int INVOCABLE_TYPE_MASK = 255;
    public static final int INVOCABLE_METHOD_MASK = 0xFFFF00;
    public static final int FE_BROWSER_CLOSE = 267;
    public static final int FE_BROWSER_CREATE = 520;
    public static final int FE_BROWSER_CREATE_61 = 519;
    public static final int FE_BROWSER_ENUMERATE = 779;
    public static final int FE_CONNECTION_CLOSE = 1031;
    public static final int FE_CONNECTION_CONSUMER_CLOSE = 1287;
    public static final int FE_CONNECTION_CONSUMER_CREATE = 1543;
    public static final int FE_CONNECTION_SET_CLIENT_ID = 1799;
    public static final int FE_CONNECTION_START = 2055;
    public static final int FE_CONNECTION_STOP = 2311;
    public static final int FE_CONSUMER_CLOSE = 2570;
    public static final int FE_CONSUMER_CREATE = 2824;
    public static final int FE_CONSUMER_INCREMENT_WINDOW = 3082;
    public static final int FE_CONSUMER_RECEIVE = 3338;
    public static final int FE_CONSUMER_SET_LISTENER = 3594;
    public static final int FE_DESTINATION_CREATE = 3841;
    public static final int FE_ENUMERATION_NEXT_ELEMENT = 4108;
    public static final int FE_PRODUCER_CLOSE = 4617;
    public static final int FE_PRODUCER_CREATE = 4872;
    public static final int FE_PRODUCER_SEND = 5129;
    public static final int FE_SUBSCRIPTION_REMOVE = 5377;
    public static final int FE_SERVER_SESSION_POOL_CLOSE = 5633;
    public static final int FE_SESSION_POOL_CREATE = 5895;
    public static final int FE_SESSION_ACKNOWLEDGE = 6152;
    public static final int FE_SESSION_CLOSE = 6408;
    public static final int FE_SESSION_CREATE = 6663;
    public static final int FE_SESSION_RECOVER = 6920;
    public static final int FE_SESSION_SET_REDELIVERY_DELAY = 7176;
    public static final int FE_TEMPORARY_DESTINATION_CLOSE = 7431;
    public static final int FE_TEMPORARY_DESTINATION_CREATE = 7687;
    public static final int FE_SERVER_PUSH_MESSAGE = 7937;
    public static final int BE_BROWSER_CLOSE = 8210;
    public static final int BE_BROWSER_CREATE_61 = 8450;
    public static final int BE_BROWSER_CREATE = 8464;
    public static final int BE_BROWSER_ENUMERATE = 8722;
    public static final int BE_CONNECTION_CONSUMER_CLOSE = 8975;
    public static final int BE_CONNECTION_CONSUMER_CREATE = 9218;
    public static final int BE_CONNECTION_START = 9487;
    public static final int BE_CONNECTION_STOP = 9743;
    public static final int BE_CONSUMER_CLOSE = 10001;
    public static final int BE_CONSUMER_CREATE = 10256;
    public static final int BE_CONSUMER_INCREMENT_WINDOW = 10513;
    public static final int BE_CONSUMER_IS_ACTIVE = 10769;
    public static final int BE_CONSUMER_RECEIVE = 11025;
    public static final int BE_CONSUMER_SET_LISTENER = 11281;
    public static final int BE_DESTINATION_CREATE = 11534;
    public static final int BE_ENUMERATION_NEXT_ELEMENT = 11795;
    public static final int BE_PRODUCER_SEND = 12052;
    public static final int BE_SERVER_SESSION_GET = 12302;
    public static final int BE_SERVER_SESSION_POOL_CLOSE = 12558;
    public static final int BE_SERVER_SESSION_POOL_CREATE = 12814;
    public static final int BE_SESSION_ACKNOWLEDGE = 13072;
    public static final int BE_SESSION_CLOSE = 13328;
    public static final int BE_SESSION_CREATE = 13570;
    public static final int BE_SESSION_RECOVER = 13840;
    public static final int BE_SESSION_SET_REDELIVERY_DELAY = 14096;
    public static final int BE_SESSION_START = 14352;
    public static final int BE_SESSION_STOP = 14608;
    public static final int BE_SUBSCRIPTION_REMOVE = 14850;
    public static final int BE_TEMPORARY_DESTINATION_CLOSE = 15118;
    public static final int JMS_PUSH_EXCEPTION = 15360;
    public static final int JMS_PUSH_MESSAGE = 15616;
    public static final int FE_BROWSER_PUSH_EXCEPTION = 15371;
    public static final int JMS_BROWSER_PUSH_EXCEPTION = 15382;
    public static final int FE_CONSUMER_PUSH_EXCEPTION = 15370;
    public static final int JMS_CONSUMER_PUSH_EXCEPTION = 15366;
    public static final int JMS_CONNECTION_PUSH_EXCEPTION = 15363;
    public static final int DSP_HANDSHAKE_HELLO = 15872;
    public static final int BE_DIST_RETRIEVE = 16130;
    public static final int LEADER_BIND_SINGULAR = 16405;
    public static final int LEADER_BIND_SINGULAR_FAILED = 16661;
    public static final int BE_DIST_PARENT_RETRIEVE = 16898;
    public static final int BE_DIST_CONSUMER = 17169;
    public static final int FE_CONSUMER_INCREMENT_WINDOW_ONE_WAY = 17418;
    public static final int BE_TRAN_FORWARD = 17684;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invocableAdd(int n, Invocable invocable) throws JMSException {
        HashMap hashMap;
        HashMap hashMap2 = hashMap = INVOCABLE_MAPS[n];
        synchronized (hashMap2) {
            Invocable invocable2 = hashMap.put(invocable.getId(), invocable);
            if (invocable2 == null) {
                if (hashMap.size() > invocablesHighCount[n]) {
                    InvocableManager.invocablesHighCount[n] = hashMap.size();
                }
                int n2 = n;
                invocablesTotalCount[n2] = invocablesTotalCount[n2] + 1;
                return;
            }
            if (invocable == invocable2) {
                return;
            }
            hashMap.put(invocable2.getId(), invocable2);
        }
        throw new weblogic.jms.common.JMSException(INVOCABLE_STRINGS[n] + " already exists");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Invocable invocableFind(int n, JMSID jMSID) throws JMSException {
        HashMap hashMap = INVOCABLE_MAPS[n];
        if (hashMap != null) {
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                Invocable invocable = (Invocable)hashMap.get(jMSID);
                if (invocable != null) {
                    return invocable;
                }
            }
        } else if (InvocableManager.isManager(n)) {
            return managers[n];
        }
        throw new weblogic.jms.common.JMSException(INVOCABLE_STRINGS[n] + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Invocable invocableRemove(int n, JMSID jMSID) throws JMSException {
        HashMap hashMap;
        HashMap hashMap2 = hashMap = INVOCABLE_MAPS[n];
        synchronized (hashMap2) {
            Invocable invocable = (Invocable)hashMap.remove(jMSID);
            if (invocable != null) {
                return invocable;
            }
        }
        throw new weblogic.jms.common.JMSException(INVOCABLE_STRINGS[n] + " not found");
    }

    public static HashMap getInvocableMap(int n) {
        return INVOCABLE_MAPS[n];
    }

    public static int getInvocablesCurrentCount(int n) {
        return INVOCABLE_MAPS[n].size();
    }

    public static int getInvocablesHighCount(int n) {
        return invocablesHighCount[n];
    }

    public static int getInvocablesTotalCount(int n) {
        return invocablesTotalCount[n];
    }

    private static boolean isManager(int n) {
        return n == 0 | n == 1 | n == 2 | n == 21;
    }

    public static void addManager(int n, Invocable invocable) {
        InvocableManager.managers[n] = invocable;
    }

    static {
        InvocableManager.addManager(0, DispatcherManager.get());
    }
}

