/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import javax.jms.JMSException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Dispatcher;
import weblogic.jms.dispatcher.DispatcherException;
import weblogic.jms.dispatcher.DispatcherManager;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManager;
import weblogic.jms.dispatcher.InvocableMonitor;
import weblogic.jms.dispatcher.Response;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.Kernel;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.AsyncResultListener;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;
import weblogic.utils.StackTraceUtils;

public abstract class Request
extends Response
implements ExecuteRequest,
AsyncResultListener,
Externalizable {
    static final long serialVersionUID = -3580248041850964617L;
    protected JMSID invocableId;
    protected int methodId;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int INVOCABLE_ID_MASK = 256;
    private static final int CORRELATION_ID_MASK = 512;
    public static final int START = 0;
    public static final int FINISH = 2;
    public static final int COMPLETED = Integer.MAX_VALUE;
    public static final int REMOTE = -42;
    protected int state;
    private Response result;
    private Throwable throwableResponse;
    protected Request parent;
    protected Request next;
    private int numWaiting;
    protected int numChildren;
    private boolean isCollocated;
    private boolean running;
    private boolean isFanoutCoordinator;
    private long correlationId;
    private AsyncResult asyncResult;
    private FutureResponse futureResponse;
    private boolean needFillInStackTrace;
    private int tranInfo;
    public static final int NO_TRAN = 0;
    public static final int HAVE_TRAN = 1;
    public static final int DONT_KNOW_IF_TRAN = 2;
    private Transaction transaction;
    private Invocable invocable;
    private InvocableMonitor invocableMonitor;
    private static Object blankOneWayReply = new Object();
    public static final int RMI_TRANSACTION = 1;
    public static final int RMI_FUTURE_RESPONSE = 2;
    public static final int RMI_SYNC = 16;
    public static final int RMI_ASYNC_RESULT = 32;
    public static final int RMI_ONEWAY = 64;
    private boolean doFailover;

    public Request(JMSID jMSID, int n) {
        this.invocableId = jMSID;
        this.methodId = n;
        this.result = this;
        this.isCollocated = true;
    }

    public void setInvocableId(JMSID jMSID) {
        this.invocableId = jMSID;
    }

    public final JMSID getInvocableId() {
        return this.invocableId;
    }

    public final void setMethodId(int n) {
        this.methodId = n;
    }

    public final int getMethodId() {
        return this.methodId;
    }

    public final void clearResult() {
        this.result = this;
        this.throwableResponse = null;
    }

    public final void clearState() {
        this.result = this;
        this.throwableResponse = null;
        this.numChildren = 0;
    }

    public final boolean hasResults() {
        return this.result != this || this.throwableResponse != null;
    }

    public final void setResult(Response response) {
        this.result = response;
    }

    final synchronized void notifyResult(Throwable throwable, boolean bl) {
        if (this.throwableResponse == null) {
            this.throwableResponse = throwable;
            this.needFillInStackTrace = bl;
        }
        if (this.numWaiting > 0) {
            this.notify();
        } else if (this.state == -42) {
            this.resumeRequest(throwable, bl);
        }
    }

    final synchronized void notifyResult(Response response) {
        this.result = response;
        if (this.numWaiting > 0) {
            this.notify();
        }
    }

    public final synchronized Response getResult() throws JMSException {
        while (this.result == this && this.throwableResponse == null) {
            this.sleepTillNotified();
        }
        if (this.throwableResponse != null) {
            if (this.needFillInStackTrace) {
                this.needFillInStackTrace = false;
                this.throwableResponse = StackTraceUtils.getThrowableWithCause(this.throwableResponse);
            }
            if (this.throwableResponse instanceof RuntimeException) {
                throw (RuntimeException)this.throwableResponse;
            }
            if (this.throwableResponse instanceof JMSException) {
                throw (JMSException)this.throwableResponse;
            }
            throw new weblogic.jms.common.JMSException(this.throwableResponse.getMessage(), this.throwableResponse);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void sleepTillNotified() throws JMSException {
        block42: {
            ++this.numWaiting;
            if (this.tranInfo == 1 && this.transaction == null) {
                this.forceSuspendTransaction();
            }
            this.wait();
            var3_1 = null;
            --this.numWaiting;
            var4_4 = null;
            var5_7 = null;
            var6_10 = false;
            try {
                if (this.transaction != null) {
                    this.resumeTransaction();
                }
            }
            catch (Error var7_13) {
                var4_4 = var7_13;
                var6_10 = true;
            }
            catch (RuntimeException var7_14) {
                var5_7 = var7_14;
                var6_10 = true;
            }
            finally {
                if (this.numWaiting > 0) {
                    this.notify();
                }
            }
            if (var6_10) {
                if (var4_4 != null) {
                    throw var4_4;
                }
                if (var5_7 != null) {
                    throw var5_7;
                }
            }
            break block42;
            {
                catch (InterruptedException var1_22) {
                    block40: {
                        var3_2 = null;
                        --this.numWaiting;
                        var4_5 = null;
                        var5_8 = null;
                        var6_11 = false;
                        try {
                            if (this.transaction != null) {
                                this.resumeTransaction();
                            }
                            ** if (this.numWaiting <= 0) goto lbl-1000
                        }
                        catch (Error var7_15) {
                            ** try [egrp 3[TRYBLOCK] [7 : 98->107)] { 
lbl52:
                            // 1 sources

                            var4_5 = var7_15;
                            var6_11 = true;
                            if (this.numWaiting > 0) {
                                this.notify();
                            }
                            break block40;
                        }
                        catch (RuntimeException var7_16) {
                            ** try [egrp 4[TRYBLOCK] [8 : 121->130)] { 
lbl-1000:
                            // 3 sources

                            {
                                catch (Throwable var8_20) {
                                    if (this.numWaiting > 0) {
                                        this.notify();
                                    }
                                    throw var8_20;
                                }
                            }
lbl63:
                            // 1 sources

                            var5_8 = var7_16;
                            var6_11 = true;
                            if (this.numWaiting > 0) {
                                this.notify();
                            } else {
                                ** GOTO lbl68
                            }
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.notify();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    if (var6_11) {
                        if (var4_5 != null) {
                            throw var4_5;
                        }
                        if (var5_8 != null) {
                            throw var5_8;
                        }
                    }
                }
            }
            catch (Throwable var2_23) {
                block41: {
                    var3_3 = null;
                    --this.numWaiting;
                    var4_6 = null;
                    var5_9 = null;
                    var6_12 = false;
                    try {
                        if (this.transaction != null) {
                            this.resumeTransaction();
                        }
                        ** if (this.numWaiting <= 0) goto lbl-1000
                    }
                    catch (Error var7_17) {
                        ** try [egrp 3[TRYBLOCK] [7 : 98->107)] { 
lbl90:
                        // 1 sources

                        var4_6 = var7_17;
                        var6_12 = true;
                        if (this.numWaiting > 0) {
                            this.notify();
                        }
                        break block41;
                    }
                    catch (RuntimeException var7_18) {
                        ** try [egrp 4[TRYBLOCK] [8 : 121->130)] { 
lbl-1000:
                        // 3 sources

                        {
                            catch (Throwable var8_21) {
                                if (this.numWaiting > 0) {
                                    this.notify();
                                }
                                throw var8_21;
                            }
                        }
lbl101:
                        // 1 sources

                        var5_9 = var7_18;
                        var6_12 = true;
                        if (this.numWaiting > 0) {
                            this.notify();
                        } else {
                            ** GOTO lbl106
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.notify();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                if (var6_12) {
                    if (var4_6 != null) {
                        throw var4_6;
                    }
                    if (var5_9 != null) {
                        throw var5_9;
                    }
                }
                throw var2_23;
            }
        }
    }

    public final void setState(int n) {
        this.state = n;
    }

    public final int getState() {
        return this.state;
    }

    public final void setParent(Request request) {
        this.parent = request;
    }

    public final Request getParent() {
        return this.parent;
    }

    public final synchronized void resumeRequest(Throwable throwable, boolean bl) {
        this.resumeRequest(throwable, bl, false);
    }

    private final synchronized void resumeRequest(Throwable throwable, boolean bl, boolean bl2) {
        this.needFillInStackTrace = bl;
        if (this.numChildren <= 0) {
            return;
        }
        --this.numChildren;
        if (this.throwableResponse == null) {
            this.needFillInStackTrace = bl;
            this.throwableResponse = throwable;
        }
        if (this.numChildren > 0) {
            return;
        }
        if (JMSDebug.debugJMSDispatcher) {
            JMSDebug.debug(2048, "Request():: resumeRequest() " + this + ", throw=" + throwable + ", has numChildren = " + this.numChildren);
        }
        if (this.state == -42 && this.parent != null) {
            this.parent.resumeRequest(this.throwableResponse, this.needFillInStackTrace);
        }
        if (this.numWaiting > 0) {
            this.notify();
        } else if (this.state != Integer.MAX_VALUE && this.state != -42 && !this.running) {
            if (bl2 && Thread.currentThread() instanceof ExecuteThread) {
                Kernel.execute((ExecuteRequest)this, "direct");
            } else {
                Kernel.execute(this);
            }
        }
    }

    public final synchronized void resumeRequest(Response response) {
        this.resumeRequest(response, false);
    }

    private final synchronized void resumeRequest(Response response, boolean bl) {
        if (this.numChildren <= 0) {
            return;
        }
        --this.numChildren;
        if (this.throwableResponse == null && (this.numChildren == 0 && (this.result == this || !this.isFanoutCoordinator) || response != null && !(response instanceof VoidResponse))) {
            this.setResult(response);
        }
        if (this.numChildren > 0) {
            return;
        }
        if (JMSDebug.debugJMSDispatcher) {
            JMSDebug.debug(2048, "Request():: resumeRequest() " + this + ", has numChildren = " + this.numChildren + ", result=" + response + ", throw = " + this.throwableResponse);
        }
        if (this.state == -42 && this.parent != null) {
            if (this.throwableResponse != null) {
                this.parent.resumeRequest(this.throwableResponse, this.needFillInStackTrace);
            } else {
                this.parent.resumeRequest(this.result);
            }
        }
        if (this.numWaiting > 0) {
            this.notify();
        } else if (this.state != Integer.MAX_VALUE && this.state != -42 && !this.running) {
            if (bl && Thread.currentThread() instanceof ExecuteThread) {
                Kernel.execute((ExecuteRequest)this, "direct");
            } else {
                Kernel.execute(this);
            }
        }
    }

    public final synchronized void resumeExecution() {
        if (this.numChildren <= 0) {
            return;
        }
        --this.numChildren;
        if (this.numChildren > 0) {
            return;
        }
        if (this.numWaiting > 0) {
            this.notify();
        } else if (this.state != Integer.MAX_VALUE && this.state != -42 && !this.running) {
            Kernel.execute(this);
        }
    }

    public final void handleResult(AsyncResult asyncResult) {
        Throwable throwable;
        Object object = null;
        try {
            object = asyncResult.getObject();
            if (JMSDebug.debugJMSDispatcher) {
                JMSDebug.debug(2048, "Request.handleResult() : " + object);
            }
            this.resumeRequest((Response)object);
            return;
        }
        catch (ClassCastException classCastException) {
            throwable = object != null && object instanceof Throwable ? (Throwable)object : new weblogic.jms.common.JMSException("Unexpected remote response " + object);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        this.resumeRequest(throwable, true);
    }

    public final synchronized void needOutsideResult() {
        this.isFanoutCoordinator = true;
        ++this.numChildren;
        if (JMSDebug.debugJMSDispatcher) {
            JMSDebug.debug(2048, "needOutside numChildren = " + this.numChildren + " on " + this);
        }
    }

    public final synchronized boolean fanoutComplete() {
        if (--this.numChildren == 0) {
            if (!this.hasResults()) {
                this.setResult(new VoidResponse());
            }
            return false;
        }
        return true;
    }

    public final synchronized boolean fanoutCompleteSuspendIfHaveChildren() {
        if (--this.numChildren == 0) {
            if (!this.hasResults()) {
                this.setResult(new VoidResponse());
            }
            return false;
        }
        if (this.transaction == null) {
            this.forceSuspendTransaction();
        }
        return true;
    }

    final void setFutureResponse(FutureResponse futureResponse) {
        this.futureResponse = futureResponse;
    }

    final boolean isCollocated() {
        return this.isCollocated;
    }

    public final void setNext(Request request) {
        this.next = request;
    }

    public final Request getNext() {
        return this.next;
    }

    final synchronized void setCorrelationId(long l) {
        this.correlationId = l;
    }

    final long getCorrelationId() {
        return this.correlationId;
    }

    final void setAsyncResult(AsyncResult asyncResult) {
        this.asyncResult = asyncResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Response wrappedFiniteStateMachine() throws JMSException {
        Response response;
        block45: {
            FutureResponse futureResponse;
            AsyncResult asyncResult;
            int n;
            Throwable throwable = null;
            response = this;
            Request request = this;
            Request request2 = this;
            synchronized (request2) {
                if (this.running) {
                    return this;
                }
                this.running = true;
                if (this.transaction != null) {
                    this.resumeTransaction();
                }
            }
            while (true) {
                try {
                    if (this.invocable == null) {
                        this.invocable = InvocableManager.invocableFind(this.methodId & 0xFF, this.invocableId);
                        if (this.invocableMonitor == null) {
                            this.invocableMonitor = this.invocable.getInvocableMonitor();
                            if (this.invocableMonitor != null) {
                                this.invocableMonitor.increment();
                            }
                        }
                    }
                    n = this.invocable.invoke(this);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    n = Integer.MAX_VALUE;
                }
                request2 = this;
                synchronized (request2) {
                    if (n == Integer.MAX_VALUE || this.state == Integer.MAX_VALUE || this.throwableResponse != null) break;
                    if (this.numChildren == 0) {
                        if (JMSDebug.debugJMSDispatcher) {
                            JMSDebug.debug(2048, " *** run the fsm of " + this + " again ***");
                        }
                        if (this.transaction != null) {
                            this.resumeTransaction();
                        }
                        continue;
                    }
                    while (request.parent != null && request.isCollocated) {
                        request = request.parent;
                    }
                    if (!request.isCollocated) break;
                    if (this.asyncResult != null || this.futureResponse != null) {
                        throw new AssertionError((Object)"unexpected collocated rmi access");
                    }
                    if (!this.doFailover) {
                        this.sleepTillNotified();
                    }
                    if (this.state == Integer.MAX_VALUE || this.throwableResponse != null) break;
                }
            }
            {
                if (n == Integer.MAX_VALUE || this.state == Integer.MAX_VALUE || this.throwableResponse != null) {
                    this.state = Integer.MAX_VALUE;
                    n = Integer.MAX_VALUE;
                    this.running = false;
                    asyncResult = this.asyncResult;
                    this.asyncResult = null;
                    futureResponse = this.futureResponse;
                    this.futureResponse = null;
                    if (throwable != null) {
                        if (this.throwableResponse != null) {
                            throwable = this.throwableResponse;
                        } else {
                            this.throwableResponse = throwable;
                        }
                    } else if (this.throwableResponse != null) {
                        throwable = this.throwableResponse;
                    } else {
                        response = this.result;
                    }
                    if (throwable != null && this.needFillInStackTrace) {
                        this.needFillInStackTrace = false;
                        throwable = StackTraceUtils.getThrowableWithCause(throwable);
                    }
                    if (JMSDebug.debugJMSDispatcher) {
                        JMSDebug.debug(2048, "     -- COMPLETED " + this + "--");
                    }
                    if (this.parent != null) {
                        if (throwable != null) {
                            this.parent.resumeRequest(throwable, this.needFillInStackTrace, true);
                        } else {
                            this.parent.resumeRequest(this.result, true);
                        }
                    }
                    if (this.numWaiting > 0) {
                        this.notify();
                    }
                } else {
                    if (this.transaction == null && (this.tranInfo != 0 || this.hasTransaction())) {
                        this.forceSuspendTransaction();
                    }
                    this.running = false;
                    asyncResult = null;
                    futureResponse = null;
                }
            }
            try {
                if (n != Integer.MAX_VALUE) {
                    return response;
                }
                if (asyncResult == null && futureResponse == null) {
                    if (this.invocableMonitor != null) {
                        this.invocableMonitor.decrement();
                        this.invocableMonitor = null;
                    }
                    if (throwable != null) {
                        return this.getResult();
                    }
                    return response;
                }
                if (asyncResult != null) {
                    asyncResult.setResult(throwable != null ? throwable : response);
                    futureResponse.send();
                    break block45;
                }
                if (futureResponse == null) break block45;
                if (throwable != null) {
                    futureResponse.sendThrowable(throwable);
                } else {
                    futureResponse.getMsgOutput().writeObject(response, response.getClass());
                    futureResponse.send();
                }
            }
            catch (RemoteException remoteException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.invocableMonitor != null) {
            this.invocableMonitor.decrement();
            this.invocableMonitor = null;
        }
        return response;
    }

    public abstract int remoteSignature();

    public void setFailover(boolean bl) {
        this.doFailover = bl;
    }

    public final void execute(ExecuteThread executeThread) {
        try {
            DispatcherManager.getLocalDispatcher().dispatchAsync(this);
        }
        catch (DispatcherException dispatcherException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispatchAsync(Dispatcher dispatcher, Request request) throws DispatcherException {
        request.parent = this;
        Request request2 = this;
        synchronized (request2) {
            ++this.numChildren;
        }
        dispatcher.dispatchAsync(request);
    }

    public Request() {
        this.result = this;
        this.isCollocated = true;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.invocableId != null) {
            n |= 0x100;
        }
        if (this.correlationId != 0L) {
            n |= 0x200;
        }
        objectOutput.writeInt(n);
        if (this.invocableId != null) {
            this.invocableId.writeExternal(objectOutput);
        }
        if (this.correlationId != 0L) {
            objectOutput.writeLong(this.correlationId);
        }
        objectOutput.writeInt(this.methodId);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        if ((n & 0x100) != 0) {
            this.invocableId = new JMSID();
            this.invocableId.readExternal(objectInput);
        }
        if ((n & 0x200) != 0) {
            this.correlationId = objectInput.readLong();
        }
        this.methodId = objectInput.readInt();
        this.isCollocated = false;
    }

    final boolean hasTransaction() {
        if (this.tranInfo == 2) {
            try {
                this.tranInfo = (this.remoteSignature() & 1) != 0 && this.getTranManager().getTransaction() != null ? 1 : 0;
            }
            catch (SystemException systemException) {
                this.tranInfo = 0;
            }
        }
        return this.tranInfo == 1;
    }

    public final void setTranInfo(int n) {
        this.tranInfo = n;
    }

    final synchronized boolean forceSuspendTransaction() {
        if (this.transaction != null) {
            throw new Error("transaction suspended twice");
        }
        this.transaction = this.getTranManager().forceSuspend();
        if (this.transaction == null) {
            return false;
        }
        this.tranInfo = 1;
        return true;
    }

    private ClientTransactionManager getTranManager() {
        return TransactionHelper.getTransactionHelper().getTransactionManager();
    }

    final synchronized void resumeTransaction() {
        if (this.transaction == null) {
            throw new Error("transaction resumed twice");
        }
        this.getTranManager().forceResume(this.transaction);
        this.transaction = null;
    }
}

