/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.common.internal.PeerInfoableObjectOutput;
import weblogic.jms.common.JMSUtilities;

public class Response
implements Externalizable {
    static final long serialVersionUID = -4057384450154825617L;
    public static final boolean CHECK = false;
    private Serializable payload;
    private long correlationId;
    private static final byte EXTVERSION = 1;
    private static final byte VERSION_MASK = 31;
    private static final byte CORRELATION_ID_MASK = 32;
    private static final byte PAYLOAD_MASK = 64;
    private PeerInfo peerInfo;
    static /* synthetic */ Class class$weblogic$jms$dispatcher$VoidResponse;

    public Response(Serializable serializable) {
        this.payload = serializable;
    }

    public Response(long l) {
        this.correlationId = l;
    }

    Response(long l, Serializable serializable) {
        this.payload = serializable;
        this.correlationId = l;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(Serializable serializable) {
        this.payload = serializable;
    }

    long getCorrelationId() {
        return this.correlationId;
    }

    void setCorrelationId(long l) {
        this.correlationId = l;
    }

    public Response() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.correlationId == 0L ? 1 : 33;
        if (this.payload != null) {
            n |= 0x40;
        }
        objectOutput.writeByte(n);
        if (this.correlationId != 0L) {
            objectOutput.writeLong(this.correlationId);
        }
        if (this.payload != null) {
            objectOutput.writeObject(this.payload);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if ((by & 0x1F) != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        if ((by & 0x20) != 0) {
            this.correlationId = objectInput.readLong();
        }
        if ((by & 0x40) != 0) {
            this.payload = (Serializable)objectInput.readObject();
        }
    }

    public static void instanceOf(Object object, Class clazz) {
        if (clazz.isInstance(object)) {
            return;
        }
        if (object == null && (class$weblogic$jms$dispatcher$VoidResponse == null ? (class$weblogic$jms$dispatcher$VoidResponse = Response.class$("weblogic.jms.dispatcher.VoidResponse")) : class$weblogic$jms$dispatcher$VoidResponse) == clazz) {
            return;
        }
        throw new Error("" + object + " is not an instance of " + clazz.getName());
    }

    public void setPeerInfo(PeerInfo peerInfo) {
        this.peerInfo = peerInfo;
    }

    public ObjectOutput getVersionedStream(ObjectOutput objectOutput) {
        if (objectOutput instanceof PeerInfoable) {
            return objectOutput;
        }
        if (this.peerInfo != null) {
            return new PeerInfoableObjectOutput(this.peerInfo, objectOutput);
        }
        return objectOutput;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

