/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Dispatcher;
import weblogic.jms.dispatcher.Request;

public final class FEBrowserCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 7024696476454603978L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int SELECTOR_MASK = 256;
    private static final int DISTRIBUTEDDESTINATION_MASK = 8192;
    public static final int START = 0;
    public static final int CONTINUE = 1;
    private transient Dispatcher dispatcher;
    private JMSID connectionId;
    private DestinationImpl destination;
    private String messageSelector;
    private static PeerInfo queueBrowserChildOfSession = PeerInfo.VERSION_614;

    public FEBrowserCreateRequest(JMSID jMSID, JMSID jMSID2, DestinationImpl destinationImpl, String string) {
        super(jMSID2, 520);
        this.connectionId = jMSID;
        this.destination = destinationImpl;
        this.messageSelector = string;
    }

    public DestinationImpl getDestination() {
        return this.destination;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public int remoteSignature() {
        return 32;
    }

    public FEBrowserCreateRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        int n = 1;
        PeerInfo peerInfo = objectOutput instanceof PeerInfoable ? ((PeerInfoable)((Object)objectOutput)).getPeerInfo() : PeerInfo.getPeerInfo();
        if (peerInfo.compareTo(queueBrowserChildOfSession) < 0) {
            this.setMethodId(519);
            this.setInvocableId(this.connectionId);
        }
        if (this.messageSelector != null) {
            n |= 0x100;
        }
        if (this.destination instanceof DistributedDestinationImpl) {
            n |= 0x2000;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        this.destination.writeExternal(objectOutput);
        if (this.messageSelector != null) {
            objectOutput.writeUTF(this.messageSelector);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        if ((n & 0x2000) != 0) {
            this.destination = new DistributedDestinationImpl();
            this.destination.readExternal(objectInput);
        } else {
            this.destination = new DestinationImpl();
            this.destination.readExternal(objectInput);
        }
        if ((n & 0x100) != 0) {
            this.messageSelector = objectInput.readUTF();
        }
    }
}

