/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.ServerSessionPool;
import weblogic.jms.client.JMSServerSessionPool;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;

public final class FEConnectionConsumerCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 7143098392927142826L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int DURABLE_MASK = 256;
    private static final int SELECTOR_MASK = 512;
    private static final int PERMISSION_MASK = 1024;
    private static final int DISTRIBUTEDDESTINATION_MASK = 8192;
    private ServerSessionPool serverSessionPool;
    private DestinationImpl destination;
    private boolean durable;
    private String messageSelector;
    private int messagesMaximum;
    private boolean checkPermission;

    public FEConnectionConsumerCreateRequest(JMSID jMSID, ServerSessionPool serverSessionPool, DestinationImpl destinationImpl, boolean bl, String string, int n, boolean bl2) {
        super(jMSID, 1543);
        this.serverSessionPool = serverSessionPool;
        this.destination = destinationImpl;
        this.durable = bl;
        this.messageSelector = string;
        this.messagesMaximum = n;
        this.checkPermission = bl2;
    }

    public final ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }

    public final DestinationImpl getDestination() {
        return this.destination;
    }

    public final boolean isDurable() {
        return this.durable;
    }

    public final String getMessageSelector() {
        return this.messageSelector;
    }

    public final int getMessagesMaximum() {
        return this.messagesMaximum;
    }

    public final boolean checkPermission() {
        return this.checkPermission;
    }

    public int remoteSignature() {
        return 18;
    }

    public FEConnectionConsumerCreateRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.durable) {
            n |= 0x100;
        }
        if (this.messageSelector != null) {
            n |= 0x200;
        }
        if (this.checkPermission) {
            n |= 0x400;
        }
        if (this.destination instanceof DistributedDestinationImpl) {
            n |= 0x2000;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        ((JMSServerSessionPool)this.serverSessionPool).writeExternal(objectOutput);
        this.destination.writeExternal(objectOutput);
        if (this.messageSelector != null) {
            objectOutput.writeUTF(this.messageSelector);
        }
        objectOutput.writeInt(this.messagesMaximum);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.durable = (n & 0x100) != 0;
        this.checkPermission = (n & 0x400) != 0;
        this.serverSessionPool = new JMSServerSessionPool();
        ((JMSServerSessionPool)this.serverSessionPool).readExternal(objectInput);
        if ((n & 0x2000) != 0) {
            this.destination = new DistributedDestinationImpl();
            this.destination.readExternal(objectInput);
        } else {
            this.destination = new DestinationImpl();
            this.destination.readExternal(objectInput);
        }
        if ((n & 0x200) != 0) {
            this.messageSelector = objectInput.readUTF();
        }
        this.messagesMaximum = objectInput.readInt();
    }
}

