/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.DispatcherWrapper;

public final class FEConnectionCreateRequest
implements Externalizable {
    static final long serialVersionUID = 8136687183971929785L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int XA_MASK = 256;
    private static final int HAS_USER_MASK = 512;
    private static final int HAS_PW_MASK = 1024;
    private DispatcherWrapper wrapper;
    private String userName;
    private String password;
    private boolean createXAConnection;

    public FEConnectionCreateRequest() {
    }

    public FEConnectionCreateRequest(DispatcherWrapper dispatcherWrapper, String string, String string2, boolean bl) {
        this.wrapper = dispatcherWrapper;
        this.userName = string;
        this.password = string2;
        this.createXAConnection = bl;
    }

    public DispatcherWrapper getDispatcherWrapper() {
        return this.wrapper;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getCreateXAConnection() {
        return this.createXAConnection;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.createXAConnection) {
            n |= 0x100;
        }
        if (this.userName != null) {
            n |= 0x200;
        }
        if (this.password != null) {
            n |= 0x400;
        }
        objectOutput.writeInt(n);
        this.wrapper.writeExternal(objectOutput);
        if (this.userName != null) {
            objectOutput.writeUTF(this.userName);
        }
        if (this.password != null) {
            objectOutput.writeUTF(this.password);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        this.wrapper = new DispatcherWrapper();
        this.wrapper.readExternal(objectInput);
        boolean bl = this.createXAConnection = (n & 0x100) != 0;
        if ((n & 0x200) != 0) {
            this.userName = objectInput.readUTF();
        }
        if ((n & 0x400) != 0) {
            this.password = objectInput.readUTF();
        }
    }
}

