/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Response;

public final class FEConsumerCreateResponse
extends Response
implements Externalizable {
    static final long serialVersionUID = 4370603925624654360L;
    static final byte EXTVERSION1 = 1;
    static final byte EXTVERSION2 = 2;
    static final byte EXTVERSION = 2;
    private JMSID consumerId;
    private String runtimeMBeanName;

    public FEConsumerCreateResponse(JMSID jMSID, String string) {
        this.consumerId = jMSID;
        this.runtimeMBeanName = string;
    }

    public JMSID getConsumerId() {
        return this.consumerId;
    }

    public String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public FEConsumerCreateResponse() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        PeerInfo peerInfo = null;
        if (objectOutput instanceof PeerInfoable) {
            peerInfo = ((PeerInfoable)((Object)objectOutput)).getPeerInfo();
        }
        int n = peerInfo == null || peerInfo.compareTo(PeerInfo.VERSION_81) >= 0 ? 2 : 1;
        objectOutput.writeByte(n);
        super.writeExternal(objectOutput);
        this.consumerId.writeExternal(objectOutput);
        if (n >= 2) {
            objectOutput.writeUTF(this.runtimeMBeanName);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1 && by != 2) {
            throw JMSUtilities.versionIOException(by, 1, 2);
        }
        super.readExternal(objectInput);
        this.consumerId = new JMSID();
        this.consumerId.readExternal(objectInput);
        if (by >= 2) {
            this.runtimeMBeanName = objectInput.readUTF();
        }
    }
}

