/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;

public final class FEConsumerIncrementWindowCurrentOneWayRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 1485628795862457005L;
    static final int START = 0;
    static final int CONTINUE = 1;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int CLIENTRESPONSIBLEFORACKNOWLEDGE = 256;
    private int windowIncrement;
    private transient boolean clientResponsibleForAcknowledge;

    public FEConsumerIncrementWindowCurrentOneWayRequest(JMSID jMSID, int n, boolean bl) {
        super(jMSID, 17418);
        this.windowIncrement = n;
        this.clientResponsibleForAcknowledge = bl;
    }

    public final int getWindowIncrement() {
        return this.windowIncrement;
    }

    public final boolean getClientResponsibleForAcknowledge() {
        return this.clientResponsibleForAcknowledge;
    }

    public int remoteSignature() {
        return 64;
    }

    public FEConsumerIncrementWindowCurrentOneWayRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.clientResponsibleForAcknowledge) {
            n |= 0x100;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.windowIncrement);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        this.clientResponsibleForAcknowledge = (n & 0x100) != 0;
        super.readExternal(objectInput);
        this.windowIncrement = objectInput.readInt();
    }
}

