/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;

public final class FEProducerCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -1183676357733894095L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int DESTINATION_MASK = 1792;
    private static final int DESTINATION_SHIFT = 8;
    private DestinationImpl destination;

    public FEProducerCreateRequest(JMSID jMSID, DestinationImpl destinationImpl) {
        super(jMSID, 4872);
        this.destination = destinationImpl;
    }

    public final DestinationImpl getDestination() {
        return this.destination;
    }

    public int remoteSignature() {
        return 18;
    }

    public FEProducerCreateRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.destination != null) {
            n |= Destination.getDestinationType(this.destination, 8);
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        if (this.destination != null) {
            this.destination.writeExternal(objectOutput);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        if ((n & 0x700) != 0) {
            byte by = (byte)((n & 0x700) >>> 8);
            this.destination = Destination.createDestination(by, objectInput);
        }
    }
}

