/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Response;

public final class FEProducerCreateResponse
extends Response
implements Externalizable {
    static final long serialVersionUID = -6258736813443927954L;
    static final byte EXTVERSION1 = 1;
    static final byte EXTVERSION2 = 2;
    static final byte EXTVERSION = 2;
    private JMSID producerId;
    private String runtimeMBeanName;

    public FEProducerCreateResponse(JMSID jMSID, String string) {
        this.producerId = jMSID;
        this.runtimeMBeanName = string;
    }

    public JMSID getProducerId() {
        return this.producerId;
    }

    public String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public FEProducerCreateResponse() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        PeerInfo peerInfo = null;
        if (objectOutput instanceof PeerInfoable) {
            peerInfo = ((PeerInfoable)((Object)objectOutput)).getPeerInfo();
        }
        int n = peerInfo == null || peerInfo.compareTo(PeerInfo.VERSION_81) >= 0 ? 2 : 1;
        objectOutput.writeByte(n);
        super.writeExternal(objectOutput);
        this.producerId.writeExternal(objectOutput);
        if (n >= 2) {
            objectOutput.writeUTF(this.runtimeMBeanName);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1 && by != 2) {
            throw JMSUtilities.versionIOException(by, 1, 2);
        }
        super.readExternal(objectInput);
        this.producerId = new JMSID();
        this.producerId.readExternal(objectInput);
        if (by >= 2) {
            this.runtimeMBeanName = objectInput.readUTF();
        }
    }
}

