/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.Request;

public final class FEProducerSendRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -6258361113844425358L;
    private static final int EXTVERSION61 = 1;
    private static final int EXTVERSION81 = 2;
    private static final int EXTVERSION = 2;
    private static final int VERSION_MASK = 255;
    private static final int MESSAGE_MASK = 65280;
    private static final int DESTINATION_MASK = 983040;
    private static final int TIMEOUT_MASK = 0x100000;
    private static final int MESSAGE_MASK_SHIFT = 8;
    private static final int DESTINATION_MASK_SHIFT = 16;
    static final int START = 0;
    static final int CONTINUE = 1;
    static final int RETRY = 2;
    private transient boolean infected;
    private MessageImpl message;
    private DestinationImpl destination;
    private long sendTimeout;

    public FEProducerSendRequest(JMSID jMSID, MessageImpl messageImpl, DestinationImpl destinationImpl, long l) {
        super(jMSID, 5129);
        this.message = messageImpl;
        this.destination = destinationImpl;
        this.sendTimeout = l;
    }

    MessageImpl getMessage() {
        return this.message;
    }

    DestinationImpl getDestination() {
        return this.destination;
    }

    long getSendTimeout() {
        return this.sendTimeout;
    }

    void setInfected(boolean bl) {
        this.infected = bl;
    }

    boolean isInfected() {
        return this.infected;
    }

    public int remoteSignature() {
        return 19;
    }

    public FEProducerSendRequest() {
    }

    protected byte getVersion(Object object) throws IOException {
        if (object instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)object).getPeerInfo();
            if (peerInfo.compareTo(PeerInfo.VERSION_61) < 0) {
                throw JMSUtilities.versionIOException(0, 1, 2);
            }
            if (peerInfo.compareTo(PeerInfo.VERSION_81) < 0) {
                return 1;
            }
        }
        return 2;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        byte by = this.getVersion(objectOutput);
        int n = by | this.message.getType() << 8;
        n |= Destination.getDestinationType(this.destination, 16);
        if (by >= 2 && this.sendTimeout != 10L) {
            n |= 0x100000;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        this.message.writeExternal(objectOutput);
        if (this.destination != null) {
            this.destination.writeExternal(objectOutput);
        }
        if ((n & 0x100000) != 0) {
            objectOutput.writeLong(this.sendTimeout);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 < 1 || n2 > 2) {
            throw JMSUtilities.versionIOException(n2, 1, 2);
        }
        super.readExternal(objectInput);
        int n3 = (n & 0xFF00) >>> 8;
        this.message = MessageImpl.createMessageImpl((byte)n3);
        this.message.readExternal(objectInput);
        int n4 = (n & 0xF0000) >>> 16;
        this.destination = Destination.createDestination((byte)n4, objectInput);
        if ((n & 0x100000) != 0) {
            this.sendTimeout = objectInput.readLong();
        }
    }
}

