/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;

public final class FESessionCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 5179168005654945285L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int TRANSACTED_MASK = 256;
    private boolean transacted;
    private int acknowledgeMode;

    public FESessionCreateRequest(JMSID jMSID, boolean bl, int n) {
        super(jMSID, 6663);
        this.transacted = bl;
        this.acknowledgeMode = n;
    }

    public final boolean getTransacted() {
        return this.transacted;
    }

    public final int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public int remoteSignature() {
        return 18;
    }

    public FESessionCreateRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        int n2 = n = 1;
        if (this.transacted) {
            n2 |= 0x100;
        }
        objectOutput.writeInt(n2);
        super.writeExternal(objectOutput);
        objectOutput.writeShort((short)this.acknowledgeMode);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.transacted = (n & 0x100) != 0;
        this.acknowledgeMode = objectInput.readShort();
    }
}

