/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;

public final class FESessionRecoverRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 3677451811287600209L;
    private long lastSequenceNumber;
    private boolean doRollback;
    private transient Request childRequests;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int DO_ROLLBACK_MASK = 256;
    private static final int SEQUENCE_NUMBER_MASK = 512;
    static final int ROLLBACK_START = 0;
    static final int RECOVER_START = 1;
    static final int RECOVER_FINISH = 2;
    static final int ROLLBACK_FINISH = 3;

    public FESessionRecoverRequest(JMSID jMSID, long l, boolean bl) {
        super(jMSID, 6920);
        this.lastSequenceNumber = l;
        this.doRollback = bl;
    }

    final long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    final void setLastSequenceNumber(long l) {
        this.lastSequenceNumber = l;
    }

    final boolean doRollback() {
        return this.doRollback;
    }

    final Request getChildRequests() {
        return this.childRequests;
    }

    final void setChildRequests(Request request) {
        this.childRequests = request;
    }

    public int remoteSignature() {
        return this.doRollback ? 18 : 19;
    }

    public FESessionRecoverRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.doRollback) {
            n |= 0x100;
        }
        if (this.lastSequenceNumber != 0L) {
            n |= 0x200;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        if (this.lastSequenceNumber != 0L) {
            objectOutput.writeLong(this.lastSequenceNumber);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        if ((n & 0x200) != 0) {
            this.lastSequenceNumber = objectInput.readLong();
        }
        this.doRollback = (n & 0x100) != 0;
    }
}

