/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;

public final class FESessionSetRedeliveryDelayRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 2214133860017221888L;
    private long redeliveryDelay;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;

    public FESessionSetRedeliveryDelayRequest(JMSID jMSID, long l) {
        super(jMSID, 7176);
        this.redeliveryDelay = l;
    }

    public final long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public int remoteSignature() {
        return 18;
    }

    public FESessionSetRedeliveryDelayRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.redeliveryDelay);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.redeliveryDelay = objectInput.readLong();
    }
}

