/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Dispatcher;
import weblogic.jms.dispatcher.Request;

public final class FETemporaryDestinationDestroyRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 1839581631272219969L;
    private JMSID destinationId;
    private transient Dispatcher dispatcher;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    static final int START = 0;
    static final int CONTINUE = 1;

    public FETemporaryDestinationDestroyRequest(JMSID jMSID, JMSID jMSID2) {
        super(jMSID, 7431);
        this.destinationId = jMSID2;
    }

    public final JMSID getDestinationId() {
        return this.destinationId;
    }

    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public int remoteSignature() {
        return 18;
    }

    public FETemporaryDestinationDestroyRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        super.writeExternal(objectOutput);
        this.destinationId.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.destinationId = new JMSID();
        this.destinationId.readExternal(objectInput);
    }
}

