/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.multicast;

import java.util.BitSet;
import javax.jms.Destination;
import weblogic.jms.client.JMSSession;
import weblogic.jms.extensions.SequenceGapException;

public final class JMSFragmentStash {
    private static final int INVALID_FRAGMENT_NUMBER = -1;
    private JMSSession session;
    private long currentSeqNo;
    private int lastFragNum;
    private byte[] serializedMessage;
    private BitSet fragmentsReceived;
    private int numFragmentsReceived;
    private Destination destination;

    public JMSFragmentStash(JMSSession jMSSession, long l, Destination destination) {
        this.session = jMSSession;
        this.currentSeqNo = l - 1L;
        this.destination = destination;
    }

    public byte[] processFragment(long l, int n, int n2, int n3, byte[] byArray) throws SequenceGapException {
        if (l < this.currentSeqNo) {
            return null;
        }
        if (l > this.currentSeqNo) {
            int n4 = (int)(l - this.currentSeqNo);
            if (n4 > 1) {
                this.session.onException(new SequenceGapException("Missing message(s)", this.destination, n4 - 1));
            }
            this.currentSeqNo = l;
            this.lastFragNum = -1;
            this.serializedMessage = new byte[n];
            this.fragmentsReceived = new BitSet();
            this.numFragmentsReceived = 0;
        }
        if (!this.fragmentsReceived.get(n2)) {
            System.arraycopy(byArray, 0, this.serializedMessage, n3, byArray.length);
            this.fragmentsReceived.set(n2);
            ++this.numFragmentsReceived;
            if (n3 + byArray.length >= n) {
                this.lastFragNum = n2;
            }
        }
        if (this.numFragmentsReceived == this.lastFragNum + 1) {
            return this.serializedMessage;
        }
        return null;
    }
}

