/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.multicast;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import weblogic.jms.multicast.JMSTDMSocket;

public final class JMSTDMSocketIPM
implements JMSTDMSocket {
    private MulticastSocket sock;
    private ArrayList groups;
    private int timeout = 0;

    public JMSTDMSocketIPM(int n) throws IOException, UnknownHostException {
        this.sock = new MulticastSocket(n);
        this.groups = new ArrayList();
    }

    public JMSTDMSocketIPM() throws IOException, UnknownHostException {
        this.sock = new MulticastSocket();
        this.groups = new ArrayList();
    }

    public void send(byte[] byArray, int n, InetAddress inetAddress, int n2, byte by) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, inetAddress, n2);
        this.sock.send(datagramPacket, by);
    }

    public void setSoTimeout(int n) throws IOException {
        try {
            this.sock.setSoTimeout(n);
        }
        catch (SocketException socketException) {
            throw new IOException(socketException.toString());
        }
    }

    public void setTTL(byte by) throws IOException {
        this.sock.setTTL(by);
    }

    public int receive(byte[] byArray) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        try {
            this.sock.receive(datagramPacket);
        }
        catch (InterruptedIOException interruptedIOException) {
            return 0;
        }
        return datagramPacket.getLength();
    }

    public void close() {
        if (this.sock == null) {
            return;
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            try {
                this.sock.leaveGroup((InetAddress)this.groups.get(i));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.sock.close();
        this.sock = null;
        this.groups = null;
    }

    public void joinGroup(InetAddress inetAddress) throws IOException {
        if (this.sock == null) {
            throw new IOException("Socket is closed");
        }
        if (this.groups.indexOf(inetAddress) >= 0) {
            throw new IOException("Group exists");
        }
        this.sock.joinGroup(inetAddress);
        this.groups.add(inetAddress);
    }

    public void leaveGroup(InetAddress inetAddress) throws IOException {
        if (this.sock == null) {
            throw new IOException("Socket is closed");
        }
        if (this.groups.indexOf(inetAddress) == -1) {
            throw new IOException("Group not found");
        }
        this.sock.leaveGroup(inetAddress);
        this.groups.remove(inetAddress);
    }

    void setTimeout(int n) {
        this.timeout = n;
    }
}

