/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.multicast;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.jms.client.JMSConsumer;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.jms.extensions.SequenceGapException;
import weblogic.jms.multicast.JMSFragmentStash;
import weblogic.jms.multicast.JMSTDMSocket;
import weblogic.jms.multicast.JMSTMObjectIOBypassImpl;
import weblogic.jms.store.BufferDataInputStream;
import weblogic.jms.store.BufferDataOutputStream;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.utils.expressions.ExpressionEvaluationException;

public class JMSTMSocket
implements ExecuteRequest {
    private static final int MAX_FRAGMENT_SIZE = 10240;
    private static final int PAYLOAD_FUDGE_FACTOR = 232;
    private static final int MESSAGE_VERSION = 1;
    private static final int FRAGMENT_VERSION = 1;
    private static final int VERSION_MASK = 4095;
    private static final int FRAGMENT_MAGIC = 199886103;
    protected static final int INITIAL_SEQNO = 0;
    protected JMSTDMSocket sock;
    private boolean isStarted = false;
    private Object wantLock = new Object();
    private int wantLockCount = 0;
    private JMSSession session;
    private long nextPushSeqNo = 0L;
    protected boolean closed;
    private JMSTMObjectIOBypassImpl objectIOBypassImpl = new JMSTMObjectIOBypassImpl();
    private BufferDataOutputStream bdosMsg = new BufferDataOutputStream((ObjectIOBypass)this.objectIOBypassImpl, 10240);
    private BufferDataOutputStream bdosFrag = new BufferDataOutputStream(null, 10240);
    private BufferDataInputStream bdisFrag = new BufferDataInputStream(null, 10240);
    private HashMap stashes;
    private int receivePort;
    private HashMap groups;
    private HashMap destinations;
    private HashMap dests;
    private long fragmentDelay;
    private long lastDelay;
    private long lastSendTime;
    public static final String PROTOCOL = "WeblogicMulticast";

    public JMSTMSocket(JMSSession jMSSession, JMSTDMSocket jMSTDMSocket, int n, int n2) throws IOException {
        this.session = jMSSession;
        this.sock = jMSTDMSocket;
        this.receivePort = n2;
        this.fragmentDelay = n;
        this.lastDelay = 0L;
        this.lastSendTime = 0L;
        this.closed = false;
        this.groups = new HashMap();
        this.destinations = new HashMap();
        this.dests = new HashMap();
        this.stashes = new HashMap();
        this.bdosMsg.setIsJMSMulticastOutputStream();
        this.bdosFrag.setIsJMSMulticastOutputStream();
    }

    public void setFragmentDelay(long l) {
        this.fragmentDelay = l;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            if (!this.closed) {
                this.closed = true;
                this.sock = null;
                this.stashes = null;
            }
        }
        this.decWantLockCount();
    }

    void send(MessageImpl messageImpl, DestinationImpl destinationImpl, JMSID jMSID, InetAddress inetAddress, int n, byte by, long l) throws IOException {
        String string = destinationImpl.getServerName() + "/" + destinationImpl.getName();
        if (this.closed) {
            throw new IOException("Attempt to send message on multicast socket that is closed");
        }
        this.bdosMsg.reset();
        this.bdosMsg.writeShort(1);
        this.bdosMsg.writeByte(messageImpl.getType());
        messageImpl.writeExternal(this.bdosMsg);
        jMSID.writeExternal(this.bdosMsg);
        this.bdosMsg.flush();
        int n2 = this.bdosMsg.size();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            this.bdosFrag.reset();
            this.bdosFrag.writeInt(199886103);
            this.bdosFrag.writeShort(1);
            this.bdosFrag.writeUTF(string);
            this.bdosFrag.writeLong(l);
            this.bdosFrag.writeInt(n2);
            this.bdosFrag.writeInt(n4);
            this.bdosFrag.writeInt(n3);
            this.bdosFrag.flush();
            int n5 = Math.min(10008 - this.bdosFrag.size(), n2 - n3);
            this.bdosFrag.writeInt(n5);
            if (n5 > 0) {
                this.bdosFrag.write(this.bdosMsg.getBuffer(), n3, n5);
            }
            this.bdosFrag.flush();
            this.sendThrottled(this.bdosFrag.getBuffer(), this.bdosFrag.size(), inetAddress, n, by);
            n3 += n5;
            ++n4;
        }
    }

    private void sendThrottled(byte[] byArray, int n, InetAddress inetAddress, int n2, byte by) throws IOException {
        long l = System.currentTimeMillis();
        this.lastDelay = Math.max(this.lastDelay - Math.max(l - this.lastSendTime, 0L) + this.fragmentDelay, 0L);
        this.lastSendTime = l;
        if (this.lastDelay > 0L) {
            try {
                Thread.sleep(this.lastDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.sock.send(byArray, n, inetAddress, n2, by);
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecuteThread executeThread) throws Exception {
        while (true) {
            int n;
            if ((n = this.getWantLockCount()) != 0) {
                Thread.yield();
            }
            JMSTMSocket jMSTMSocket = this;
            synchronized (jMSTMSocket) {
                if (this.sock == null) {
                    break;
                }
                MessageImpl messageImpl = this.receive();
                if (messageImpl == null) {
                    continue;
                }
                JMSID jMSID = messageImpl.getConnectionId();
                messageImpl.setConnectionId(null);
                DestinationImpl destinationImpl = (DestinationImpl)messageImpl.getJMSDestination();
                String string = destinationImpl.getServerName() + "/" + destinationImpl.getName();
                JMSPushRequest jMSPushRequest = new JMSPushRequest(0, null, messageImpl);
                ArrayList arrayList = (ArrayList)this.destinations.get(string);
                if (arrayList == null) {
                    continue;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    JMSConsumer jMSConsumer;
                    block13: {
                        jMSConsumer = (JMSConsumer)arrayList.get(i);
                        if (jMSConsumer.privateGetNoLocal() && this.session.getConnection().getId().equals(jMSID)) continue;
                        try {
                            if (jMSConsumer.getExpressionEvaluator() != null && !jMSConsumer.getExpressionEvaluator().evaluate(messageImpl)) {
                            }
                            break block13;
                        }
                        catch (ExpressionEvaluationException expressionEvaluationException) {
                        }
                        catch (ClassCastException classCastException) {}
                        continue;
                    }
                    JMSID jMSID2 = jMSConsumer.getId();
                    if (jMSID2 == null) continue;
                    JMSPushEntry jMSPushEntry = new JMSPushEntry(null, jMSID2, Long.MAX_VALUE, Long.MAX_VALUE, false);
                    jMSPushRequest.addPushEntry(jMSPushEntry);
                }
                this.session.pushMessage(jMSPushRequest, false);
            }
        }
    }

    MessageImpl receive() throws Exception {
        block17: {
            try {
                byte[] byArray;
                JMSFragmentStash jMSFragmentStash;
                if (this.closed) {
                    return null;
                }
                if (this.sock.receive(this.bdisFrag.getBuffer()) == 0) {
                    return null;
                }
                this.bdisFrag.reset();
                if (this.bdisFrag.readInt() != 199886103) {
                    return null;
                }
                if ((this.bdisFrag.readShort() & 0xFFF) != 1) {
                    return null;
                }
                String string = this.bdisFrag.readUTF();
                DestinationImpl destinationImpl = (DestinationImpl)this.dests.get(string);
                if (destinationImpl == null) {
                    return null;
                }
                long l = this.bdisFrag.readLong();
                int n = this.bdisFrag.readInt();
                int n2 = this.bdisFrag.readInt();
                int n3 = this.bdisFrag.readInt();
                int n4 = this.bdisFrag.readInt();
                byte[] byArray2 = new byte[n4];
                if (n4 > 0) {
                    this.bdisFrag.read(byArray2, 0, n4);
                }
                if ((jMSFragmentStash = (JMSFragmentStash)this.stashes.get(string)) == null) {
                    jMSFragmentStash = new JMSFragmentStash(this.session, l, destinationImpl);
                    this.stashes.put(string, jMSFragmentStash);
                }
                if ((byArray = jMSFragmentStash.processFragment(l, n, n2, n3, byArray2)) != null) {
                    BufferDataInputStream bufferDataInputStream = new BufferDataInputStream((ObjectIOBypass)this.objectIOBypassImpl, byArray);
                    if ((bufferDataInputStream.readShort() & 0xFFF) != 1) {
                        return null;
                    }
                    MessageImpl messageImpl = MessageImpl.createMessageImpl(bufferDataInputStream.readByte());
                    messageImpl.readExternal(bufferDataInputStream);
                    JMSID jMSID = new JMSID();
                    jMSID.readExternal(bufferDataInputStream);
                    messageImpl.setJMSDestinationImpl(destinationImpl);
                    messageImpl.setConnectionId(jMSID);
                    return messageImpl;
                }
            }
            catch (IOException iOException) {
                if (JMSDebug.debugJMSFrontEnd) {
                    JMSDebug.debug(8, "IOException", iOException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (JMSDebug.debugJMSFrontEnd) {
                    JMSDebug.debug(8, "ClassNotFoundException", classNotFoundException);
                }
            }
            catch (SequenceGapException sequenceGapException) {
                this.session.onException(sequenceGapException);
                if (JMSDebug.debugJMSFrontEnd) {
                    JMSDebug.debug(8, "SequenceGapException", sequenceGapException);
                }
            }
            catch (Throwable throwable) {
                if (!JMSDebug.debugJMSFrontEnd) break block17;
                JMSDebug.debug(8, "Throwable", throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinGroup(DestinationImpl destinationImpl, JMSConsumer jMSConsumer) throws IOException {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            try {
                InetAddress inetAddress;
                if (this.sock == null) {
                    throw new IOException("socket closed");
                }
                if (destinationImpl.getPort() != this.receivePort) {
                    throw new IOException("Wrong port");
                }
                String string = destinationImpl.getServerName() + "/" + destinationImpl.getName();
                try {
                    inetAddress = InetAddress.getByName(destinationImpl.getMulticastAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IOException("Cannot parse multicast address " + destinationImpl.getMulticastAddress());
                }
                ArrayList<JMSConsumer> arrayList = (ArrayList<JMSConsumer>)this.groups.get(inetAddress);
                if (arrayList != null) {
                    if (arrayList.indexOf(jMSConsumer) < 0) {
                        arrayList.add(jMSConsumer);
                        ArrayList<JMSConsumer> arrayList2 = (ArrayList<JMSConsumer>)this.destinations.get(string);
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<JMSConsumer>();
                            this.destinations.put(string, arrayList2);
                            this.dests.put(string, destinationImpl);
                        }
                        arrayList2.add(jMSConsumer);
                    }
                } else {
                    this.sock.joinGroup(inetAddress);
                    arrayList = new ArrayList<JMSConsumer>();
                    arrayList.add(jMSConsumer);
                    this.groups.put(inetAddress, arrayList);
                    ArrayList<JMSConsumer> arrayList3 = new ArrayList<JMSConsumer>();
                    this.destinations.put(string, arrayList3);
                    this.dests.put(string, destinationImpl);
                    arrayList3.add(jMSConsumer);
                }
            }
            catch (Throwable throwable) {
                this.decWantLockCount();
                throw new IOException(throwable.toString());
            }
        }
        this.decWantLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveGroup(DestinationImpl destinationImpl, JMSConsumer jMSConsumer) throws IOException {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            try {
                int n;
                InetAddress inetAddress;
                if (this.sock == null) {
                    throw new IOException("socket closed");
                }
                try {
                    inetAddress = InetAddress.getByName(destinationImpl.getMulticastAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IOException("Cannot parse multicast address " + destinationImpl.getMulticastAddress());
                }
                ArrayList arrayList = (ArrayList)this.groups.get(inetAddress);
                if (arrayList == null || (n = arrayList.indexOf(jMSConsumer)) < 0) {
                    throw new IOException("Cannot find group info about consumer");
                }
                arrayList.remove(n);
                String string = destinationImpl.getServerName() + "/" + destinationImpl.getName();
                ArrayList arrayList2 = (ArrayList)this.destinations.get(string);
                if (arrayList2 == null || (n = arrayList2.indexOf(jMSConsumer)) < 0) {
                    throw new IOException("can not find destination info about consumer");
                }
                arrayList2.remove(n);
                if (arrayList2.size() == 0) {
                    this.destinations.remove(string);
                    this.dests.remove(string);
                    this.stashes.remove(string);
                }
                if (arrayList.size() == 0) {
                    this.groups.remove(inetAddress);
                    this.sock.leaveGroup(inetAddress);
                }
            }
            catch (Throwable throwable) {
                this.decWantLockCount();
                throw new IOException(throwable.toString());
            }
        }
        this.decWantLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            try {
                if (this.sock == null) {
                    throw new IOException("socket is closed");
                }
                Iterator iterator = this.groups.keySet().iterator();
                while (iterator.hasNext()) {
                    InetAddress inetAddress = (InetAddress)iterator.next();
                    this.sock.joinGroup(inetAddress);
                }
                this.stashes = new HashMap();
                this.isStarted = true;
            }
            catch (Throwable throwable) {
                this.decWantLockCount();
                throw new IOException(throwable.toString());
            }
        }
        this.decWantLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            try {
                if (this.sock == null) {
                    throw new IOException("socket is closed");
                }
                Iterator iterator = this.groups.keySet().iterator();
                while (iterator.hasNext()) {
                    InetAddress inetAddress = (InetAddress)iterator.next();
                    this.sock.leaveGroup(inetAddress);
                }
                this.stashes = null;
                this.isStarted = false;
            }
            catch (Throwable throwable) {
                this.decWantLockCount();
                throw new IOException(throwable.toString());
            }
        }
        this.decWantLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incWantLockCount() {
        Object object = this.wantLock;
        synchronized (object) {
            ++this.wantLockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decWantLockCount() {
        Object object = this.wantLock;
        synchronized (object) {
            --this.wantLockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getWantLockCount() {
        Object object = this.wantLock;
        synchronized (object) {
            return this.wantLockCount;
        }
    }
}

