/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.store;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import weblogic.jms.common.JMSOutputStream;
import weblogic.jms.common.ObjectIOBypass;

public final class BufferDataOutputStream
extends OutputStream
implements DataOutput,
ObjectOutput,
JMSOutputStream {
    byte[] buf;
    private int count;
    private ObjectIOBypass objectIOBypass;
    private boolean isBypassOutputStream;
    private boolean isJMSStoreOutputStream;
    private boolean isJMSMulticastOutputStream;
    private static final int VERSION = 1234;

    public BufferDataOutputStream(ObjectIOBypass objectIOBypass) {
        this.buf = new byte[32];
        this.objectIOBypass = objectIOBypass;
    }

    public BufferDataOutputStream(ObjectIOBypass objectIOBypass, int n) {
        this.buf = new byte[n];
        this.objectIOBypass = objectIOBypass;
    }

    public BufferDataOutputStream(ObjectIOBypass objectIOBypass, byte[] byArray) {
        this.buf = byArray;
        this.objectIOBypass = objectIOBypass;
    }

    private void resizeBuf(int n, int n2) {
        if (n >= n2) {
            return;
        }
        byte[] byArray = n2 >= 0x200000 ? (n2 >= 0x2000000 ? (n2 >= 0x7F7FFFFE ? new byte[Integer.MAX_VALUE] : new byte[n2 + 0x7FFFFF & 0xFF800000]) : new byte[n2 + 1048575 & 0xFFF00000]) : new byte[n2 << 1];
        System.arraycopy(this.buf, 0, byArray, 0, n);
        this.buf = byArray;
    }

    public final boolean isJMSStoreOutputStream() {
        return this.isJMSStoreOutputStream;
    }

    public final boolean isBypassOutputStream() {
        return this.isBypassOutputStream;
    }

    public final boolean isJMSMulticastOutputStream() {
        return this.isJMSMulticastOutputStream;
    }

    public final void setIsJMSStoreOutputStream() {
        this.isJMSStoreOutputStream = true;
    }

    public final void setIsBypassOutputStream() {
        this.isBypassOutputStream = true;
    }

    public final void setIsJMSMulticastOutputStream() {
        this.isJMSMulticastOutputStream = true;
    }

    public final void write(int n) {
        if (this.count >= this.buf.length) {
            this.resizeBuf(this.count, this.count + 1);
        }
        this.buf[this.count++] = (byte)n;
    }

    public final void write(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            this.resizeBuf(this.count, n3);
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public final void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public final void reset() {
        this.count = 0;
    }

    public final void reposition(int n) {
        if (n >= this.buf.length) {
            this.resizeBuf(this.count, n + 1024);
        }
        this.count = n;
    }

    public final byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public final int size() {
        return this.count;
    }

    public final void writeObject(Object object) throws IOException {
        this.writeInt(1234);
        if (this.objectIOBypass == null) {
            throw new IOException("Stream can not handle raw objects.");
        }
        this.objectIOBypass.writeObject(this, object);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        if (this.count >= this.buf.length) {
            this.resizeBuf(this.count, this.count + 1);
        }
        this.buf[this.count++] = (byte)(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.resizeBuf(this.count, this.count + 1);
        }
        this.buf[this.count++] = (byte)n;
    }

    public final void writeShort(int n) throws IOException {
        if (this.count + 2 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 2);
        }
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)(n >>> 0);
    }

    public final void writeChar(int n) throws IOException {
        if (this.count + 2 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 2);
        }
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)(n >>> 0);
    }

    public final void writeInt(int n) throws IOException {
        int n2 = this.count;
        if (n2 + 4 > this.buf.length) {
            this.resizeBuf(n2, n2 + 4);
        }
        byte[] byArray = this.buf;
        byArray[n2++] = (byte)(n >>> 24);
        byArray[n2++] = (byte)(n >>> 16);
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)(n >>> 0);
        this.count = n2;
    }

    public final void writeLong(long l) throws IOException {
        int n = this.count;
        if (n + 8 > this.buf.length) {
            this.resizeBuf(n, n + 8);
        }
        byte[] byArray = this.buf;
        byArray[n++] = (byte)(l >>> 56);
        byArray[n++] = (byte)(l >>> 48);
        byArray[n++] = (byte)(l >>> 40);
        byArray[n++] = (byte)(l >>> 32);
        byArray[n++] = (byte)(l >>> 24);
        byArray[n++] = (byte)(l >>> 16);
        byArray[n++] = (byte)(l >>> 8);
        byArray[n++] = (byte)(l >>> 0);
        this.count = n;
    }

    public final void writeFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        int n2 = this.count;
        if (n2 + 4 > this.buf.length) {
            this.resizeBuf(n2, n2 + 4);
        }
        byte[] byArray = this.buf;
        byArray[n2++] = (byte)(n >>> 24);
        byArray[n2++] = (byte)(n >>> 16);
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)(n >>> 0);
        this.count = n2;
    }

    public final void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        int n = this.count;
        if (n + 8 > this.buf.length) {
            this.resizeBuf(n, n + 8);
        }
        byte[] byArray = this.buf;
        byArray[n++] = (byte)(l >>> 56);
        byArray[n++] = (byte)(l >>> 48);
        byArray[n++] = (byte)(l >>> 40);
        byArray[n++] = (byte)(l >>> 32);
        byArray[n++] = (byte)(l >>> 24);
        byArray[n++] = (byte)(l >>> 16);
        byArray[n++] = (byte)(l >>> 8);
        byArray[n++] = (byte)(l >>> 0);
        this.count = n;
    }

    public final void writeBytes(String string) throws IOException {
        BufferDataOutputStream bufferDataOutputStream = this;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            ((OutputStream)bufferDataOutputStream).write((byte)string.charAt(i));
        }
    }

    public final void writeChars(String string) throws IOException {
        BufferDataOutputStream bufferDataOutputStream = this;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            ((OutputStream)bufferDataOutputStream).write(c >>> 8 & 0xFF);
            ((OutputStream)bufferDataOutputStream).write(c >>> 0 & 0xFF);
        }
    }

    public final void writeUTF(String string) throws IOException {
        char c;
        int n;
        BufferDataOutputStream bufferDataOutputStream = this;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        ((OutputStream)bufferDataOutputStream).write(n3 >>> 8 & 0xFF);
        ((OutputStream)bufferDataOutputStream).write(n3 >>> 0 & 0xFF);
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ((OutputStream)bufferDataOutputStream).write(c);
                continue;
            }
            if (c > '\u07ff') {
                ((OutputStream)bufferDataOutputStream).write(0xE0 | c >> 12 & 0xF);
                ((OutputStream)bufferDataOutputStream).write(0x80 | c >> 6 & 0x3F);
                ((OutputStream)bufferDataOutputStream).write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            ((OutputStream)bufferDataOutputStream).write(0xC0 | c >> 6 & 0x1F);
            ((OutputStream)bufferDataOutputStream).write(0x80 | c >> 0 & 0x3F);
        }
    }
}

