/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import weblogic.kernel.AuditableThread;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThreadManager;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelLogger;

public final class ExecuteThread
extends AuditableThread {
    private static final boolean ASSERT = true;
    private static final Throwable REQUEST_DEATH = new RequestDeath();
    private static final Field javaLangThreadContextClassLoaderField = ExecuteThread.initializeThreadContextClassLoaderField();
    private static final String oomeMessage = " OutOfMemoryError occured on server";
    private Calendar calendar;
    private ClassLoader defaultContextClassLoader;
    private Date date;
    private ExecuteThreadManager em;
    private int hashcode;
    private ClassLoader contextClassLoader;
    private ExecuteRequest req = null;
    private boolean ignoreStuckThread = false;
    private boolean printStuckMessage = false;
    private boolean started = false;
    private int executeCount = 0;
    private long timeStamp = 0L;
    private String originalID = null;
    private boolean isOriginalIDSet = false;
    private boolean systemThread = false;
    static /* synthetic */ Class class$java$lang$Thread;

    private static Field initializeThreadContextClassLoaderField() {
        if (Kernel.isServer()) {
            try {
                Field field = (class$java$lang$Thread == null ? (class$java$lang$Thread = ExecuteThread.class$("java.lang.Thread")) : class$java$lang$Thread).getDeclaredField("contextClassLoader");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    ExecuteThread(int n, ExecuteThreadManager executeThreadManager) {
        super("ExecuteThread: '" + n + "' for queue: '" + executeThreadManager.getName() + "'");
        this.init(executeThreadManager);
    }

    ExecuteThread(int n, ExecuteThreadManager executeThreadManager, ThreadGroup threadGroup) {
        super(threadGroup, "ExecuteThread: '" + n + "' for queue: '" + executeThreadManager.getName() + "'");
        this.init(executeThreadManager);
    }

    private void init(ExecuteThreadManager executeThreadManager) {
        this.em = executeThreadManager;
        this.date = new Date();
        this.date.setYear(this.date.getYear());
        this.calendar = new GregorianCalendar();
        this.defaultContextClassLoader = this.getClass().getClassLoader();
        this.setContextClassLoader(this.defaultContextClassLoader);
        this.hashcode = this.getName().hashCode();
    }

    public int hashCode() {
        return this.hashcode;
    }

    boolean isStarted() {
        return this.started;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public ExecuteRequest getCurrentRequest() {
        return this.req;
    }

    public Date getDate() {
        return this.date;
    }

    public int getExecuteCount() {
        return this.executeCount;
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setPrintStuckThreadMessage(boolean bl) {
        this.printStuckMessage = bl;
    }

    public boolean getPrintStuckThreadMessage() {
        return this.printStuckMessage;
    }

    public void setIgnoreStuckThread(boolean bl) {
        this.ignoreStuckThread = bl;
    }

    public boolean getIgnoreStuckThread() {
        return this.ignoreStuckThread;
    }

    public void setSystemThread(boolean bl) {
        this.systemThread = bl;
    }

    public boolean getSystemThread() {
        return this.systemThread;
    }

    public ExecuteThreadManager getExecuteThreadManager() {
        return this.em;
    }

    synchronized void notifyRequest(ExecuteRequest executeRequest) {
        this.req = executeRequest;
        this.notify();
    }

    void setRequest(ExecuteRequest executeRequest) {
        this.req = executeRequest;
    }

    private synchronized void waitForRequest() {
        while (this.req == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ExecuteThread executeThread = this;
        synchronized (executeThread) {
            this.started = true;
            this.notify();
        }
        while (true) {
            try {
                while (true) {
                    this.reset();
                    this.em.registerIdle(this);
                    if (this.req == null) {
                        this.waitForRequest();
                    }
                    this.setTimeStamp(System.currentTimeMillis());
                    this.setPrintStuckThreadMessage(false);
                    this.execute(this.req);
                }
            }
            catch (ExecuteThreadManager.ShutdownError shutdownError) {
            }
            catch (ThreadDeath threadDeath) {
                if (!Kernel.isServer()) continue;
                if (!Kernel.isIntentionalShutdown()) {
                    KernelLogger.logStopped(this.getName());
                }
                throw threadDeath;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                try {
                    KernelLogger.logExecuteFailed(outOfMemoryError);
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    ExecuteThread.printOutOfMemoryError();
                }
                throw outOfMemoryError;
            }
            break;
        }
        if (Kernel.isServer() && !Kernel.isIntentionalShutdown()) {
            KernelLogger.logStopped(this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(ExecuteRequest executeRequest) {
        try {
            ++this.executeCount;
            if (Kernel.DEBUG) {
                this.setThreadName(executeRequest);
            }
            executeRequest.execute(this);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (ExecuteThreadManager.ShutdownError shutdownError) {
            throw shutdownError;
        }
        catch (RequestDeath requestDeath) {
            KernelLogger.logExecuteCancelled(executeRequest.toString());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            try {
                KernelLogger.logExecuteFailed(outOfMemoryError);
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                ExecuteThread.printOutOfMemoryError();
            }
        }
        catch (Throwable throwable) {
            if (!Kernel.isApplet()) {
                KernelLogger.logExecuteFailed(throwable);
            } else {
                throwable.printStackTrace();
            }
        }
        finally {
            if (Kernel.DEBUG) {
                this.resetThreadName();
            }
        }
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        try {
            this.contextClassLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            return;
        }
        if (super.getContextClassLoader() != this.contextClassLoader && javaLangThreadContextClassLoaderField != null) {
            try {
                javaLangThreadContextClassLoaderField.set(this, this.contextClassLoader);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    protected final void reset() {
        super.reset();
        if (!Kernel.isApplet()) {
            this.setContextClassLoader(this.defaultContextClassLoader);
        }
        this.req = null;
    }

    private static void printOutOfMemoryError() {
        System.err.println(oomeMessage);
        System.out.println(oomeMessage);
    }

    private void resetThreadName() {
        this.setName(this.originalID);
    }

    private void setThreadName(ExecuteRequest executeRequest) {
        if (!this.isOriginalIDSet) {
            this.originalID = this.getName();
            this.isOriginalIDSet = true;
        }
        this.setName(this.originalID + " : Executing(" + executeRequest.toString() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class RequestDeath
    extends Error {
        private RequestDeath() {
        }
    }
}

