/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.ArrayList;
import weblogic.health.HealthState;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.Kernel;
import weblogic.kernel.QueueFullException;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.t3.srvr.T3SrvrLogger;
import weblogic.utils.UnsyncCircularQueue;
import weblogic.utils.collections.Stack;

public final class ExecuteThreadManager {
    static boolean netscape = false;
    private static final ShutdownRequest SHUTDOWN_REQUEST = new ShutdownRequest();
    private final UnsyncCircularQueue q;
    private final String name;
    private final Stack idleThreads;
    private ExecuteThread[] threads;
    private boolean shutdownWasRequested = false;
    private ThreadGroup thdGrp = null;
    private int departures = 0;
    private int queueLengthThresholdPercent;
    private int queueLength;
    private int threadsIncrease;
    private int threadsMaximum;
    private int threadsMinimum;
    private int calculatedPercent;
    private int threadPriority;
    private boolean printStuckMessageOnce = true;
    private int oldThreadsLength;
    private boolean changeHealthThreadStatus = false;
    private boolean changeHealthPoolStatus = false;
    private int healthState = 0;
    private String[] healthReason = new String[]{""};

    ExecuteThreadManager(String string, ExecuteQueueMBean executeQueueMBean) {
        this.name = string;
        this.queueLengthThresholdPercent = executeQueueMBean.getQueueLengthThresholdPercent();
        this.queueLength = executeQueueMBean.getQueueLength();
        this.threadsIncrease = executeQueueMBean.getThreadsIncrease();
        this.threadsMaximum = executeQueueMBean.getThreadsMaximum();
        this.threadsMinimum = executeQueueMBean.getThreadsMinimum();
        this.threadPriority = executeQueueMBean.getThreadPriority();
        this.calculatedPercent = this.queueLength * this.queueLengthThresholdPercent / 100;
        if (this.calculatedPercent <= 0) {
            this.calculatedPercent = 1;
        }
        this.q = new UnsyncCircularQueue(256, this.queueLength);
        this.idleThreads = new Stack(executeQueueMBean.getThreadCount());
        try {
            this.thdGrp = new ThreadGroup("Thread Group for Queue: '" + string + "'");
        }
        catch (SecurityException securityException) {
            System.err.println("Caught a security exception. That's okay.");
            netscape = true;
        }
        this.setThreadCount(executeQueueMBean.getThreadCount());
        this.oldThreadsLength = this.threads.length;
    }

    public boolean isShutdownInProgress() {
        return this.shutdownWasRequested;
    }

    ExecuteThread[] getExecuteThreads() {
        return this.threads;
    }

    public int getExecuteQueueDepth() {
        return this.q.size();
    }

    public int getExecuteQueueSize() {
        return this.q.capacity();
    }

    public int getExecuteQueueDepartures() {
        return this.departures;
    }

    public int getExecuteThreadCount() {
        return this.threads.length;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadCount(int n) throws SecurityException {
        int n2 = 0;
        ExecuteThreadManager executeThreadManager = this;
        synchronized (executeThreadManager) {
            if (n > this.threadsMaximum) {
                n = this.threadsMaximum;
            }
            if (this.shutdownWasRequested) {
                throw new IllegalStateException("Shutdown in progress");
            }
            if (this.threads == null) {
                this.threads = new ExecuteThread[n];
            } else {
                if (n == this.threads.length) {
                    return;
                }
                if (n < this.threads.length) {
                    throw new IllegalStateException("Cannot reduce thread pool size in a running server");
                }
                ExecuteThread[] executeThreadArray = this.threads;
                this.threads = new ExecuteThread[n];
                n2 = executeThreadArray.length;
                System.arraycopy(executeThreadArray, 0, this.threads, 0, n2);
            }
            for (int i = n2; i < this.threads.length; ++i) {
                if (!netscape) {
                    try {
                        this.threads[i] = new ExecuteThread(i, this, this.thdGrp);
                    }
                    catch (SecurityException securityException) {
                        this.threads[i] = new ExecuteThread(i, this);
                        System.err.println("Caught a security exception. That's okay.");
                        netscape = true;
                    }
                } else {
                    this.threads[i] = new ExecuteThread(i, this);
                }
                if (!netscape) {
                    try {
                        this.threads[i].setDaemon(true);
                    }
                    catch (SecurityException securityException) {
                        System.err.println("Caught a security exception. That's okay.");
                        netscape = true;
                    }
                }
                this.threads[i].setPriority(this.threadPriority);
            }
        }
        this.startThreads(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThreads(int n) {
        ExecuteThread[] executeThreadArray = this.threads;
        synchronized (this.threads) {
            for (int i = n; i < this.threads.length; ++i) {
                if (this.threads[i] == null) continue;
                this.threads[i].start();
                if (this.threads[i].isStarted()) continue;
                try {
                    Thread.sleep(5L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void expandThreadPool() {
        if (this.oldThreadsLength == 0 || this.q.size() + 1 >= this.calculatedPercent) {
            if (this.oldThreadsLength < this.threadsMaximum) {
                if (this.oldThreadsLength != 0) {
                    this.setHealthState(1, "Queue Capacity greater than configured threshold of " + this.queueLengthThresholdPercent + "%" + " We will try to allocate " + this.threadsIncrease + " threads to help.");
                    this.changeHealthPoolStatus = true;
                }
                if (this.threadsIncrease != 0) {
                    this.oldThreadsLength = Math.min(this.threads.length + this.threadsIncrease, this.threadsMaximum);
                    this.setThreadCount(this.oldThreadsLength);
                }
            }
        } else if (this.changeHealthPoolStatus) {
            this.setHealthState(0, "");
            this.changeHealthPoolStatus = false;
        }
    }

    synchronized ExecuteThread[] getStuckExecuteThreads(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        int n = 0;
        ArrayList<ExecuteThread> arrayList = null;
        if (this.threads.length == 0 || l == 0L) {
            return null;
        }
        for (int i = 0; i < this.threads.length; ++i) {
            ExecuteThread executeThread = this.threads[i];
            if (executeThread == null || executeThread.getIgnoreStuckThread() || executeThread.getCurrentRequest() == null || executeThread.getTimeStamp() <= 0L || (l3 = l2 - executeThread.getTimeStamp()) <= l) continue;
            ++n;
            if (arrayList == null) {
                arrayList = new ArrayList<ExecuteThread>();
            }
            arrayList.add(executeThread);
            executeThread.setPrintStuckThreadMessage(true);
        }
        if (n == this.threads.length) {
            this.changeHealthThreadStatus = true;
            this.setHealthState(2, "All Threads are stuck. We will try to allocate " + this.threadsIncrease + " threads to help.");
            if (this.threadsIncrease != 0 && this.oldThreadsLength < this.threadsMaximum) {
                this.oldThreadsLength = Math.min(this.threads.length + this.threadsIncrease, this.threadsMaximum);
                this.setThreadCount(this.oldThreadsLength);
            }
        } else if (this.changeHealthThreadStatus) {
            this.setHealthState(0, "");
            this.changeHealthThreadStatus = false;
        }
        return arrayList != null ? arrayList.toArray(new ExecuteThread[arrayList.size()]) : null;
    }

    synchronized void shutdown() throws SecurityException {
        if (this.shutdownWasRequested) {
            return;
        }
        this.shutdownWasRequested = true;
        while (this.idleThreads.size() != 0) {
            ExecuteThread executeThread = (ExecuteThread)this.idleThreads.pop();
            ++this.departures;
            executeThread.notifyRequest(SHUTDOWN_REQUEST);
        }
    }

    public int getIdleThreadCount() {
        return this.idleThreads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerIdle(ExecuteThread executeThread) {
        ExecuteRequest executeRequest;
        if (executeThread.getPrintStuckThreadMessage()) {
            T3SrvrLogger.logInfoUnstuckThread(executeThread.getName());
        }
        ExecuteThreadManager executeThreadManager = this;
        synchronized (executeThreadManager) {
            executeRequest = this.shutdownWasRequested ? SHUTDOWN_REQUEST : (ExecuteRequest)this.q.get();
            if (executeRequest == null) {
                this.idleThreads.push(executeThread);
                return;
            }
        }
        executeThread.setRequest(executeRequest);
        ++this.departures;
    }

    synchronized void requeueRequest(ExecuteRequest executeRequest) {
        this.q.put(executeRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(ExecuteRequest executeRequest, boolean bl) {
        ExecuteThread executeThread;
        if (bl && Kernel.isQueueThrottleAllowed() && this.q.size() >= this.queueLength) {
            throw new QueueFullException(this.queueLength);
        }
        ExecuteThreadManager executeThreadManager = this;
        synchronized (executeThreadManager) {
            if (this.idleThreads.size() == 0) {
                this.expandThreadPool();
                this.q.put(executeRequest);
                return;
            }
            executeThread = (ExecuteThread)this.idleThreads.pop();
            executeThread.setTimeStamp(System.currentTimeMillis());
            executeThread.setPrintStuckThreadMessage(false);
            this.printStuckMessageOnce = true;
        }
        ++this.departures;
        executeThread.notifyRequest(executeRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeIfIdle(ExecuteRequest executeRequest) {
        ExecuteThread executeThread;
        ExecuteThreadManager executeThreadManager = this;
        synchronized (executeThreadManager) {
            if (this.idleThreads.size() == 0) {
                return false;
            }
            executeThread = (ExecuteThread)this.idleThreads.pop();
            executeThread.setTimeStamp(System.currentTimeMillis());
            executeThread.setPrintStuckThreadMessage(false);
            this.printStuckMessageOnce = true;
        }
        ++this.departures;
        executeThread.notifyRequest(executeRequest);
        return true;
    }

    public void setHealthState(int n, String string) {
        this.healthState = n;
        this.healthReason[0] = string;
    }

    public HealthState getHealthState() {
        return new HealthState(this.healthState, this.healthReason);
    }

    int getPendingTasksCount() {
        int n = 0;
        if (this.threads.length == 0) {
            return 0;
        }
        if (Kernel.getDispatchPolicyIndex("weblogic.kernel.Default") == Kernel.getDispatchPolicyIndex(this.name)) {
            for (int i = 0; i < this.threads.length; ++i) {
                ExecuteThread executeThread = this.threads[i];
                if (executeThread == null) continue;
                ExecuteRequest executeRequest = executeThread.getCurrentRequest();
                if (executeThread.getSystemThread() || executeRequest == null) continue;
                ++n;
            }
        } else {
            n += this.getExecuteThreadCount() - this.getIdleThreadCount();
        }
        return n += this.getExecuteQueueDepth();
    }

    public synchronized String toString() {
        return super.toString() + " - name: '" + this.getName() + "' threads: '" + this.getExecuteThreadCount() + "' idle: '" + this.getIdleThreadCount() + " departures: '" + this.getExecuteQueueDepartures() + "' queue:\n\t" + this.q;
    }

    static final class ShutdownError
    extends Error {
        ShutdownError() {
        }
    }

    private static final class ShutdownRequest
    implements ExecuteRequest {
        private ShutdownRequest() {
        }

        public void execute(ExecuteThread executeThread) {
            throw new ShutdownError();
        }
    }
}

