/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InvalidAttributeValueException;
import weblogic.common.internal.LogOutputStream;
import weblogic.common.internal.VersionInfo;
import weblogic.kernel.ExecuteQueueMBeanStub;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.ExecuteThreadManager;
import weblogic.kernel.KernelMBeanStub;
import weblogic.kernel.KernelStatus;
import weblogic.logging.ConsoleFormatter;
import weblogic.logging.ConsoleHandler;
import weblogic.logging.FileStreamHandler;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.management.configuration.KernelDebugMBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.utils.AssertionError;
import weblogic.utils.StackTraceUtils;

public final class Kernel
extends KernelStatus {
    public static final String DIRECT_DISPATCH = "direct";
    public static final String DEFAULT_DISPATCH = "weblogic.kernel.Default";
    public static final String DEFAULT_DISPATCH_ALIAS = "default";
    public static final String NON_BLOCKING_DISPATCH = "weblogic.kernel.Non-Blocking";
    public static final String SYSTEM_DISPATCH = "weblogic.kernel.System";
    public static final String KERNEL_LOGGER = "com.bea.weblogic.kernel";
    private static final String USE_JAVA_SERIALIZATION_PROP = "weblogic.kernel.useJavaSerializationForExternalizable";
    private static final String ALLOW_QUEUE_THROTTLE = "weblogic.kernel.allowQueueThrottling";
    private static final int DIRECT = 0;
    private static Logger logger = null;
    private static LogOutputStream log;
    private static boolean intentionalShutdown;
    private static KernelMBean config;
    private static ExecuteThreadManager[] queues;
    private static HashMap policyNameAlias;
    private static ArrayList applicationQueueNames;
    private static int defaultDispatchIndex;
    private static boolean isTracingEnabled;
    private static final boolean useJavaSerialization;
    private static final boolean allowQueueThrottling;
    private static boolean enableLogging;
    static /* synthetic */ Class class$weblogic$kernel$Kernel;

    private static final boolean initUseJavaSerializationProp() {
        if (Kernel.isApplet()) {
            return false;
        }
        return Boolean.getBoolean(USE_JAVA_SERIALIZATION_PROP);
    }

    private static final boolean initAllowThrottleProp() {
        if (Kernel.isApplet()) {
            return false;
        }
        return Boolean.getBoolean(ALLOW_QUEUE_THROTTLE);
    }

    public static boolean needJavaSerialization() {
        return useJavaSerialization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogOutputStream getLog() {
        if (log == null) {
            Class clazz = class$weblogic$kernel$Kernel == null ? (class$weblogic$kernel$Kernel = Kernel.class$("weblogic.kernel.Kernel")) : class$weblogic$kernel$Kernel;
            synchronized (clazz) {
                if (log == null) {
                    log = new LogOutputStream("Kernel");
                }
            }
        }
        return log;
    }

    public static final boolean isTracingEnabled() {
        return isTracingEnabled;
    }

    public static boolean isInitialized() {
        return config != null;
    }

    public static synchronized void ensureInitialized() {
        Kernel.initialized();
        if (config == null) {
            try {
                KernelMBeanStub kernelMBeanStub = new KernelMBeanStub();
                Kernel.initialize(kernelMBeanStub);
            }
            catch (Throwable throwable) {
                throw new InternalError("error initializing kernel caused by: " + StackTraceUtils.throwable2StackTrace(throwable));
            }
        }
    }

    public static synchronized void initialize(KernelMBean kernelMBean) {
        Kernel.initialized();
        if (config != null) {
            config = kernelMBean;
            return;
        }
        config = kernelMBean;
        isTracingEnabled = config.getTracingEnabled();
        VersionInfo.initialize(Kernel.isServer());
        if (Kernel.isServer()) {
            logger = Kernel.createAndInitLogger(config);
        }
        policyNameAlias.put(DEFAULT_DISPATCH, DEFAULT_DISPATCH_ALIAS);
        ExecuteQueueMBean[] executeQueueMBeanArray = config.getExecuteQueues();
        int n = executeQueueMBeanArray.length;
        while (--n >= 0) {
            ExecuteQueueMBean executeQueueMBean = executeQueueMBeanArray[n];
            String string = executeQueueMBean.getName();
            if (string.startsWith("wl_bootstrap_")) {
                string = string.substring(13);
                Kernel.addExecuteQueue(string, executeQueueMBean);
                continue;
            }
            applicationQueueNames.add(string);
            Kernel.addExecuteQueue(string, executeQueueMBean, true);
        }
        if (!Kernel.isDispatchPolicy(DEFAULT_DISPATCH)) {
            ExecuteQueueMBeanStub executeQueueMBeanStub = new ExecuteQueueMBeanStub();
            if (config.getThreadPoolSize() > 0) {
                try {
                    executeQueueMBeanStub.setThreadCount(config.getThreadPoolSize());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            applicationQueueNames.add(executeQueueMBeanStub.getName());
            Kernel.addExecuteQueue(executeQueueMBeanStub.getName(), executeQueueMBeanStub, true);
        }
        defaultDispatchIndex = Kernel.getDispatchPolicyIndex(DEFAULT_DISPATCH);
        if (Kernel.isServer() && !Kernel.isDispatchPolicy(NON_BLOCKING_DISPATCH)) {
            Kernel.addExecuteQueue(NON_BLOCKING_DISPATCH, 0, 3, 3);
        }
        if (Kernel.isServer() && !Kernel.isDispatchPolicy(SYSTEM_DISPATCH)) {
            Kernel.addExecuteQueue(SYSTEM_DISPATCH, config.getSystemThreadPoolSize());
        }
    }

    public static KernelMBean getConfig() {
        if (!Kernel.isServer() && !Kernel.isInitialized()) {
            Kernel.ensureInitialized();
        }
        return config;
    }

    public static KernelDebugMBean getDebug() {
        return config.getKernelDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger() {
        if (logger == null) {
            Class clazz = class$weblogic$kernel$Kernel == null ? (class$weblogic$kernel$Kernel = Kernel.class$("weblogic.kernel.Kernel")) : class$weblogic$kernel$Kernel;
            synchronized (clazz) {
                if (logger == null) {
                    if (enableLogging) {
                        logger = Kernel.createLogger();
                        logger = Kernel.createAndInitLogger(new KernelMBeanStub());
                    } else {
                        logger = Kernel.createDummyLogger();
                    }
                }
            }
        }
        return logger;
    }

    private static Logger createLogger() {
        return Logger.getAnonymousLogger();
    }

    private static Logger createAndInitLogger(KernelMBean kernelMBean) {
        Logger logger = Kernel.createLogger();
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.ALL);
        Handler[] handlerArray = logger.getHandlers();
        if (handlerArray != null) {
            for (int i = 0; i < handlerArray.length; ++i) {
                logger.removeHandler(handlerArray[i]);
            }
        }
        ConsoleHandler consoleHandler = new ConsoleHandler(kernelMBean);
        logger.addHandler(consoleHandler);
        FileStreamHandler fileStreamHandler = null;
        if (!Kernel.isServer() && kernelMBean.getLog().getFileName() != null) {
            fileStreamHandler = new FileStreamHandler(kernelMBean.getLog());
            fileStreamHandler.setFormatter(new ConsoleFormatter(kernelMBean));
            logger.addHandler(fileStreamHandler);
        }
        return logger;
    }

    public static ExecuteThreadManager getExecuteThreadManager() {
        return queues[defaultDispatchIndex];
    }

    public static ExecuteThreadManager getExecuteThreadManager(String string) {
        int n = Kernel.getDispatchPolicyIndex(string);
        return queues[n];
    }

    static ExecuteThreadManager[] getExecuteThreadManagers() {
        return queues;
    }

    public static void execute(ExecuteRequest executeRequest) {
        Kernel.execute(executeRequest, false);
    }

    public static void execute(ExecuteRequest executeRequest, boolean bl) {
        queues[defaultDispatchIndex].execute(executeRequest, bl);
    }

    public static void execute(ExecuteRequest executeRequest, int n) {
        Kernel.execute(executeRequest, n, false);
    }

    public static void execute(ExecuteRequest executeRequest, int n, boolean bl) {
        if (n == 0) {
            ExecuteThread executeThread = (ExecuteThread)Thread.currentThread();
            executeThread.execute(executeRequest);
        } else {
            queues[n].execute(executeRequest, bl);
        }
    }

    public static void execute(ExecuteRequest executeRequest, String string) {
        Kernel.execute(executeRequest, string, false);
    }

    public static void execute(ExecuteRequest executeRequest, String string, boolean bl) {
        Kernel.execute(executeRequest, Kernel.getDispatchPolicyIndex(string), bl);
    }

    public static void executeIfIdle(ExecuteRequest executeRequest, int n) {
        if (n == 0 || !queues[n].executeIfIdle(executeRequest)) {
            Thread thread = Thread.currentThread();
            if (thread instanceof ExecuteThread) {
                ((ExecuteThread)thread).execute(executeRequest);
            } else {
                try {
                    executeRequest.execute(null);
                }
                catch (Exception exception) {
                    throw new InternalError("Error executing the request on a Non-kernel Thread: " + StackTraceUtils.throwable2StackTrace(exception));
                }
            }
        }
    }

    public static void executeIfIdle(ExecuteRequest executeRequest, String string) {
        Kernel.executeIfIdle(executeRequest, Kernel.getDispatchPolicyIndex(string));
    }

    public static int getExecuteQueueDepth() {
        return queues[defaultDispatchIndex].getExecuteQueueDepth();
    }

    public static int getExecuteQueueDepth(int n) {
        if (n == 0) {
            return 0;
        }
        return queues[n].getExecuteQueueDepth();
    }

    public static int getExecuteQueueDepth(String string) {
        return Kernel.getExecuteQueueDepth(Kernel.getDispatchPolicyIndex(string));
    }

    public static int getDispatchPolicyIndex(String string) {
        if (DIRECT_DISPATCH.equalsIgnoreCase(string)) {
            return 0;
        }
        int n = queues.length;
        for (int i = 1; i < n; ++i) {
            String string2 = queues[i].getName();
            if (!string2.equalsIgnoreCase(string) && !string2.equalsIgnoreCase((String)policyNameAlias.get(string))) continue;
            return i;
        }
        Kernel.ensureInitialized();
        return Kernel.getDispatchPolicyIndex(DEFAULT_DISPATCH);
    }

    public static boolean isDispatchPolicy(String string) {
        if (DIRECT_DISPATCH.equalsIgnoreCase(string)) {
            return true;
        }
        int n = queues.length;
        for (int i = 1; i < n; ++i) {
            String string2 = queues[i].getName();
            if (!string2.equalsIgnoreCase(string) && !string2.equalsIgnoreCase((String)policyNameAlias.get(string))) continue;
            return true;
        }
        return false;
    }

    public static void addExecuteQueue(String string, int n) {
        Kernel.addExecuteQueue(string, false, n);
    }

    public static void addExecuteQueue(String string, String string2, int n) {
        policyNameAlias.put(string, string2);
        Kernel.addExecuteQueue(string, false, n);
    }

    public static void addExecuteQueue(String string, boolean bl, int n) {
        Kernel.addExecuteQueue(string, bl, n, 0, n);
    }

    public static void addExecuteQueue(String string, int n, int n2, int n3) {
        Kernel.addExecuteQueue(string, false, n, n2, n3);
    }

    public static void addExecuteQueue(String string, boolean bl, int n, int n2, int n3) {
        ExecuteQueueMBeanStub executeQueueMBeanStub = new ExecuteQueueMBeanStub();
        try {
            executeQueueMBeanStub.setThreadCount(n);
            executeQueueMBeanStub.setThreadsIncrease(n2);
            executeQueueMBeanStub.setThreadsMaximum(n3);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new AssertionError("Invalid ExecuteQueueMBean attributes specified for " + string);
        }
        Kernel.addExecuteQueue(string, executeQueueMBeanStub, bl);
    }

    public static void addExecuteQueue(String string, ExecuteQueueMBean executeQueueMBean) {
        Kernel.addExecuteQueue(string, executeQueueMBean, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExecuteQueue(String string, ExecuteQueueMBean executeQueueMBean, boolean bl) {
        if (bl) {
            if (!applicationQueueNames.contains(string)) {
                applicationQueueNames.add(string);
            }
        } else {
            applicationQueueNames.remove(string);
            applicationQueueNames.remove(policyNameAlias.get(string));
        }
        if (Kernel.isDispatchPolicy(string)) {
            return;
        }
        Class clazz = class$weblogic$kernel$Kernel == null ? (class$weblogic$kernel$Kernel = Kernel.class$("weblogic.kernel.Kernel")) : class$weblogic$kernel$Kernel;
        synchronized (clazz) {
            if (Kernel.isDispatchPolicy(string)) {
                return;
            }
            ExecuteThreadManager executeThreadManager = new ExecuteThreadManager(string, executeQueueMBean);
            ExecuteThreadManager[] executeThreadManagerArray = new ExecuteThreadManager[queues.length + 1];
            System.arraycopy(queues, 0, executeThreadManagerArray, 0, queues.length);
            executeThreadManagerArray[Kernel.queues.length] = executeThreadManager;
            queues = executeThreadManagerArray;
        }
    }

    public static void initializeExecuteQueue(ExecuteQueueMBean executeQueueMBean) {
        Kernel.addExecuteQueue(executeQueueMBean.getName(), executeQueueMBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Class clazz = class$weblogic$kernel$Kernel == null ? (class$weblogic$kernel$Kernel = Kernel.class$("weblogic.kernel.Kernel")) : class$weblogic$kernel$Kernel;
        synchronized (clazz) {
            intentionalShutdown = true;
            int n = queues.length;
            for (int i = 1; i < n; ++i) {
                queues[i].shutdown();
            }
        }
    }

    public static boolean checkStuckThreads(String string, long l) {
        boolean bl = false;
        ExecuteThreadManager[] executeThreadManagerArray = Kernel.getExecuteThreadManagers();
        if (string != null) {
            ExecuteThread[] executeThreadArray;
            ExecuteThreadManager executeThreadManager;
            int n = Kernel.getDispatchPolicyIndex(string);
            if (l > 0L && n > 0 && (executeThreadManager = executeThreadManagerArray[n]) != null && (executeThreadArray = executeThreadManager.getStuckExecuteThreads(l)) != null && executeThreadArray.length == executeThreadManager.getExecuteThreadCount()) {
                bl = true;
            }
        }
        return bl;
    }

    public static int getPendingTasksCount(String string) {
        ExecuteThreadManager executeThreadManager;
        int n;
        int n2 = 0;
        ExecuteThreadManager[] executeThreadManagerArray = Kernel.getExecuteThreadManagers();
        if (string != null && (n = Kernel.getDispatchPolicyIndex(string)) > 0 && (executeThreadManager = executeThreadManagerArray[n]) != null) {
            n2 = executeThreadManager.getPendingTasksCount();
        }
        return n2;
    }

    public static List getApplicationDispatchPolicies() {
        return applicationQueueNames;
    }

    public static boolean isApplicationDispatchPolicy(int n) {
        if (n == 0) {
            return false;
        }
        return applicationQueueNames.contains(queues[n].getName());
    }

    public static boolean removeFromApplicationQueueNames(String string) {
        return applicationQueueNames.remove(string);
    }

    public static boolean isIntentionalShutdown() {
        return intentionalShutdown;
    }

    private Kernel() {
    }

    public static synchronized void setLoggingEnabled(boolean bl) {
        enableLogging = bl;
    }

    private static Logger createDummyLogger() {
        Logger logger = Logger.getAnonymousLogger();
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.OFF);
        return logger;
    }

    static boolean isQueueThrottleAllowed() {
        return allowQueueThrottling;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        intentionalShutdown = false;
        queues = new ExecuteThreadManager[1];
        policyNameAlias = new HashMap();
        applicationQueueNames = new ArrayList();
        isTracingEnabled = false;
        useJavaSerialization = Kernel.initUseJavaSerializationProp();
        allowQueueThrottling = Kernel.initAllowThrottleProp();
        enableLogging = true;
    }
}

