/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.Map;
import weblogic.kernel.ExecuteQueueMBeanStub;
import weblogic.kernel.IIOPMBeanStub;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelDebugMBeanStub;
import weblogic.kernel.LogMBeanStub;
import weblogic.kernel.MBeanStub;
import weblogic.kernel.SSLMBeanStub;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.management.configuration.IIOPMBean;
import weblogic.management.configuration.KernelDebugMBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.management.configuration.LogMBean;
import weblogic.management.configuration.SSLMBean;

final class KernelMBeanStub
extends MBeanStub
implements KernelMBean {
    private final LogMBean log = new LogMBeanStub();
    private final SSLMBean ssl = new SSLMBeanStub();
    private final IIOPMBeanStub iiop = new IIOPMBeanStub();
    private final KernelDebugMBeanStub debug = new KernelDebugMBeanStub();
    private final ExecuteQueueMBeanStub[] queues = new ExecuteQueueMBeanStub[]{new ExecuteQueueMBeanStub()};
    private boolean reverseDNSAllowed = false;
    private String defaultProtocol = "t3";
    private String defaultSecureProtocol = "t3s";
    private int systemThreadPoolSize = 0;
    private int jmsThreadPoolSize = 0;
    private int messagingBridgeThreadPoolSize = 0;
    private boolean nativeIOEnabled = false;
    private String muxerClass = null;
    private int socketReaders = -1;
    private int percentSocketReaders = 33;
    private int socketReaderTimeoutMinMillis = 500;
    private int socketReaderTimeoutMaxMillis = 1000;
    private int completeMessageTimeout = 60;
    private int completeT3MessageTimeout = 60;
    private boolean socketBufferSizeAsChunkSize = false;
    private int periodLength = 60000;
    private int idlePeriodsUntilTimeout = 4;
    private int idleTimeout = 0;
    private int rjvmIdleTimeout = 0;
    private int responseTimeout = 0;
    private boolean stdoutEnabled = true;
    private int stdoutSeverityLevel = 64;
    private boolean stdoutDebugEnabled = false;
    private boolean logRemoteExceptionsEnabled = false;
    private boolean instrumentStackTraceEnabled = true;
    private int maxOpenSockCount = Integer.MAX_VALUE;
    private String fmt = "standard";
    private boolean stack = true;
    private int stuckThreadTimerInterval = 600;
    private int stuckThreadMaxTime = 600;
    private boolean tracingEnabled = false;
    private int mtuSize = 1500;
    private boolean enableStubLoadingUsingCCL;
    private boolean refreshClientRuntimeDescriptor = false;

    KernelMBeanStub() {
        if (!Kernel.isServer()) {
            this.stdoutSeverityLevel = 64;
        }
        this.initializeFromSystemProperties("weblogic.");
    }

    public Map getValidProtocols() {
        return null;
    }

    public boolean isReverseDNSAllowed() {
        return this.reverseDNSAllowed;
    }

    public void setReverseDNSAllowed(boolean bl) {
        this.reverseDNSAllowed = bl;
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void setDefaultProtocol(String string) {
        this.defaultProtocol = string;
    }

    public String getDefaultSecureProtocol() {
        return this.defaultSecureProtocol;
    }

    public void setDefaultSecureProtocol(String string) {
        this.defaultSecureProtocol = string;
    }

    public int getThreadPoolSize() {
        return this.queues[0].getThreadCount();
    }

    public void setThreadPoolSize(int n) {
        this.queues[0].setThreadCount(n);
    }

    public int getSystemThreadPoolSize() {
        return this.systemThreadPoolSize;
    }

    public void setSystemThreadPoolSize(int n) {
        this.systemThreadPoolSize = n;
    }

    public int getJMSThreadPoolSize() {
        return this.jmsThreadPoolSize;
    }

    public void setJMSThreadPoolSize(int n) {
        this.jmsThreadPoolSize = n;
    }

    public int getMessagingBridgeThreadPoolSize() {
        return this.messagingBridgeThreadPoolSize;
    }

    public void setMessagingBridgeThreadPoolSize(int n) {
        this.messagingBridgeThreadPoolSize = n;
    }

    public boolean isNativeIOEnabled() {
        return this.nativeIOEnabled;
    }

    public void setNativeIOEnabled(boolean bl) {
        this.nativeIOEnabled = bl;
    }

    public String getMuxerClass() {
        return this.muxerClass;
    }

    public void setMuxerClass(String string) {
        this.muxerClass = string;
    }

    public int getSocketReaders() {
        return this.socketReaders;
    }

    public void setSocketReaders(int n) {
        this.socketReaders = n;
    }

    public int getThreadPoolPercentSocketReaders() {
        return this.percentSocketReaders;
    }

    public void setThreadPoolPercentSocketReaders(int n) {
        this.percentSocketReaders = n;
    }

    public int getSocketReaderTimeoutMinMillis() {
        return this.socketReaderTimeoutMinMillis;
    }

    public void setSocketReaderTimeoutMinMillis(int n) {
        this.socketReaderTimeoutMinMillis = n;
    }

    public int getSocketReaderTimeoutMaxMillis() {
        return this.socketReaderTimeoutMaxMillis;
    }

    public void setSocketReaderTimeoutMaxMillis(int n) {
        this.socketReaderTimeoutMaxMillis = n;
    }

    public int getMaxMessageSize() {
        return 10000000;
    }

    public void setMaxMessageSize(int n) {
    }

    public int getCompleteMessageTimeout() {
        return this.completeMessageTimeout;
    }

    public void setCompleteMessageTimeout(int n) {
        this.completeMessageTimeout = n;
    }

    public int getMaxT3MessageSize() {
        return 10000000;
    }

    public void setMaxT3MessageSize(int n) {
    }

    public int getMaxHTTPMessageSize() {
        return 10000000;
    }

    public void setMaxHTTPMessageSize(int n) {
    }

    public int getMaxIIOPMessageSize() {
        return this.iiop.getMaxMessageSize();
    }

    public void setMaxIIOPMessageSize(int n) {
    }

    public int getMaxCOMMessageSize() {
        return 10000000;
    }

    public void setMaxCOMMessageSize(int n) {
    }

    public int getCompleteT3MessageTimeout() {
        return this.completeT3MessageTimeout;
    }

    public void setCompleteT3MessageTimeout(int n) {
        this.completeT3MessageTimeout = n;
    }

    public void setSocketBufferSizeAsChunkSize(boolean bl) {
        this.socketBufferSizeAsChunkSize = bl;
    }

    public boolean isSocketBufferSizeAsChunkSize() {
        return this.socketBufferSizeAsChunkSize;
    }

    public int getCompleteHTTPMessageTimeout() {
        return 60;
    }

    public void setCompleteHTTPMessageTimeout(int n) {
    }

    public int getCompleteIIOPMessageTimeout() {
        return this.iiop.getCompleteMessageTimeout();
    }

    public void setCompleteIIOPMessageTimeout(int n) {
    }

    public int getCompleteCOMMessageTimeout() {
        return 60;
    }

    public void setCompleteCOMMessageTimeout(int n) {
    }

    public int getPeriodLength() {
        return this.periodLength;
    }

    public void setPeriodLength(int n) {
        this.periodLength = n;
    }

    public int getIdlePeriodsUntilTimeout() {
        return this.idlePeriodsUntilTimeout;
    }

    public void setIdlePeriodsUntilTimeout(int n) {
        this.idlePeriodsUntilTimeout = n;
    }

    public int getIdleConnectionTimeout() {
        return this.idleTimeout;
    }

    public void setIdleConnectionTimeout(int n) {
        this.idleTimeout = n;
    }

    public int getDefaultGIOPMinorVersion() {
        return this.iiop.getDefaultMinorVersion();
    }

    public void setDefaultGIOPMinorVersion(int n) {
        this.iiop.setDefaultMinorVersion(n);
    }

    public String getIIOPLocationForwardPolicy() {
        return this.iiop.getLocationForwardPolicy();
    }

    public void setIIOPLocationForwardPolicy(String string) {
        this.iiop.setLocationForwardPolicy(string);
    }

    public boolean getUseIIOPLocateRequest() {
        return this.iiop.getUseLocateRequest();
    }

    public void setUseIIOPLocateRequest(boolean bl) {
        this.iiop.setUseLocateRequest(bl);
    }

    public String getIIOPTxMechanism() {
        return this.iiop.getTxMechanism();
    }

    public void setIIOPTxMechanism(String string) {
        this.iiop.setTxMechanism(string);
    }

    public int getIdleIIOPConnectionTimeout() {
        return this.iiop.getIdleConnectionTimeout();
    }

    public void setIdleIIOPConnectionTimeout(int n) {
        this.iiop.setIdleConnectionTimeout(n);
    }

    public IIOPMBean getIIOP() {
        return this.iiop;
    }

    public void setIIOPMBean() {
    }

    public int getRjvmIdleTimeout() {
        return this.rjvmIdleTimeout;
    }

    public void setRjvmIdleTimeout(int n) {
        this.rjvmIdleTimeout = n;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(int n) {
        this.responseTimeout = n;
    }

    public boolean isUnsafeClassLoadingEnabled() {
        return false;
    }

    public void setUnsafeClassLoadingEnabled(boolean bl) {
    }

    public KernelDebugMBean getKernelDebug() {
        return this.debug;
    }

    public void setKernelDebug(KernelDebugMBean kernelDebugMBean) {
    }

    public int getDGCIdlePeriodsUntilTimeout() {
        return this.getIdlePeriodsUntilTimeout();
    }

    public void setDGCIdlePeriodsUntilTimeout(int n) {
    }

    public LogMBean getLog() {
        return this.log;
    }

    public boolean isStdoutEnabled() {
        return this.stdoutEnabled;
    }

    public void setStdoutEnabled(boolean bl) {
        this.stdoutEnabled = bl;
    }

    public int getStdoutSeverityLevel() {
        return this.stdoutSeverityLevel;
    }

    public void setStdoutSeverityLevel(int n) {
        this.stdoutSeverityLevel = n;
    }

    public boolean isStdoutDebugEnabled() {
        return this.stdoutDebugEnabled;
    }

    public void setStdoutDebugEnabled(boolean bl) {
        this.stdoutDebugEnabled = bl;
    }

    public boolean isLogRemoteExceptionsEnabled() {
        return false;
    }

    public void setLogRemoteExceptionsEnabled(boolean bl) {
        this.logRemoteExceptionsEnabled = bl;
    }

    public boolean isInstrumentStackTraceEnabled() {
        return this.instrumentStackTraceEnabled;
    }

    public void setInstrumentStackTraceEnabled(boolean bl) {
        this.instrumentStackTraceEnabled = bl;
    }

    public SSLMBean getSSL() {
        return this.ssl;
    }

    public void setSSLMBean() {
    }

    public ExecuteQueueMBean[] getExecuteQueues() {
        return this.queues;
    }

    public void setExecuteQueues(ExecuteQueueMBean[] executeQueueMBeanArray) {
    }

    public int getMaxOpenSockCount() {
        return this.maxOpenSockCount;
    }

    public void setMaxOpenSockCount(int n) {
        if (n >= 0) {
            this.maxOpenSockCount = n;
        }
    }

    public String getStdoutFormat() {
        return this.fmt;
    }

    public void setStdoutFormat(String string) {
        if (string.equals("standard") || string.equals("standard")) {
            this.fmt = string;
        }
    }

    public boolean isStdoutLogStack() {
        return this.stack;
    }

    public void setStdoutLogStack(boolean bl) {
        this.stack = bl;
    }

    public int getStuckThreadTimerInterval() {
        return this.stuckThreadTimerInterval;
    }

    public void setStuckThreadTimerInterval(int n) {
        this.stuckThreadTimerInterval = n;
    }

    public int getStuckThreadMaxTime() {
        return this.stuckThreadMaxTime;
    }

    public void setStuckThreadMaxTime(int n) {
        this.stuckThreadMaxTime = n;
    }

    public boolean getTracingEnabled() {
        return this.tracingEnabled;
    }

    public void setTracingEnabled(boolean bl) {
        this.tracingEnabled = bl;
    }

    public int getMTUSize() {
        return this.mtuSize;
    }

    public void setMTUSize(int n) {
        this.mtuSize = n;
    }

    public void setLoadStubUsingContextClassLoader(boolean bl) {
        this.enableStubLoadingUsingCCL = bl;
    }

    public boolean getLoadStubUsingContextClassLoader() {
        return this.enableStubLoadingUsingCCL;
    }

    public void setRefreshClientRuntimeDescriptor(boolean bl) {
        this.refreshClientRuntimeDescriptor = bl;
    }

    public boolean getRefreshClientRuntimeDescriptor() {
        return this.refreshClientRuntimeDescriptor;
    }
}

