/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import weblogic.logging.WLLogRecord;
import weblogic.management.configuration.KernelMBean;
import weblogic.utils.PlatformConstants;
import weblogic.utils.StackTraceUtils;

public class ConsoleFormatter
extends Formatter {
    public static String FIELD_PREFIX = "<";
    public static String FIELD_SUFFIX = "> ";
    private final DateFormat dformat = DateFormat.getDateTimeInstance(2, 0, Locale.getDefault());
    private KernelMBean kmb;
    private static final boolean logAnalyzer = Boolean.getBoolean("logAnalyzer");

    protected ConsoleFormatter() {
    }

    public ConsoleFormatter(KernelMBean kernelMBean) {
        this();
        this.kmb = kernelMBean;
    }

    public String format(LogRecord logRecord) {
        WLLogRecord wLLogRecord = (WLLogRecord)logRecord;
        String string = this.formatDate(new Date(wLLogRecord.getMillis()));
        StringBuffer stringBuffer = new StringBuffer();
        if (logAnalyzer) {
            this.appendBuf(stringBuffer, Long.toString(wLLogRecord.getMillis()));
        }
        this.appendBuf(stringBuffer, string);
        this.appendBuf(stringBuffer, wLLogRecord.getLevel().getLocalizedName());
        this.appendBuf(stringBuffer, wLLogRecord.getLoggerName());
        String string2 = this.kmb.getStdoutFormat();
        if (!string2.equals("noid")) {
            this.appendBuf(stringBuffer, wLLogRecord.getId());
        }
        stringBuffer.append(FIELD_PREFIX);
        stringBuffer.append(wLLogRecord.getMessage());
        if (this.kmb.isStdoutLogStack() && wLLogRecord.getThrown() != null) {
            stringBuffer.append(PlatformConstants.EOL);
            stringBuffer.append(StackTraceUtils.throwable2StackTrace(wLLogRecord.getThrown()));
        }
        stringBuffer.append(FIELD_SUFFIX);
        stringBuffer.append(PlatformConstants.EOL);
        return stringBuffer.toString();
    }

    protected final String formatDate(Date date) {
        return this.dformat.format(date);
    }

    protected final void appendBuf(StringBuffer stringBuffer, String string) {
        stringBuffer.append(FIELD_PREFIX);
        stringBuffer.append(string);
        stringBuffer.append(FIELD_SUFFIX);
    }
}

