/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import weblogic.kernel.Kernel;
import weblogic.logging.ConsoleFormatter;
import weblogic.logging.WLErrorManager;
import weblogic.logging.WLLevel;
import weblogic.logging.WLLogRecord;
import weblogic.management.configuration.KernelMBean;

public final class ConsoleHandler
extends StreamHandler {
    private final KernelMBean kmb;

    public ConsoleHandler(KernelMBean kernelMBean) {
        super(System.out, new ConsoleFormatter(kernelMBean));
        this.kmb = kernelMBean;
        ErrorManager errorManager = this.getErrorManager();
        if (Kernel.isApplet()) {
            this.setErrorManager(errorManager);
        } else {
            this.setErrorManager(new WLErrorManager(this));
        }
        this.setFilter(new Filter(){

            public boolean isLoggable(LogRecord logRecord) {
                if (!(logRecord instanceof WLLogRecord)) {
                    return false;
                }
                if (!Kernel.isInitialized()) {
                    return true;
                }
                WLLogRecord wLLogRecord = (WLLogRecord)logRecord;
                Level level = wLLogRecord.getLevel();
                int n = WLLevel.getSeverity(level);
                if (!ConsoleHandler.this.kmb.isStdoutEnabled()) {
                    return false;
                }
                if (n == 128) {
                    return ConsoleHandler.this.kmb.isStdoutDebugEnabled();
                }
                return n <= ConsoleHandler.this.kmb.getStdoutSeverityLevel();
            }
        });
        this.setLevel(Level.ALL);
    }

    void logAll(int n, String string, String string2) {
        Level level = WLLevel.getLevel(n);
        WLLogRecord wLLogRecord = new WLLogRecord(level, string2);
        wLLogRecord.setLoggerName(string);
        super.publish(wLLogRecord);
    }

    public void publish(LogRecord logRecord) {
        if (!(logRecord instanceof WLLogRecord)) {
            logRecord = WLLogRecord.normalizeLogRecord(logRecord);
        }
        if (this.isLoggable(logRecord)) {
            WLLogRecord wLLogRecord = (WLLogRecord)logRecord;
            if (!this.kmb.isStdoutLogStack()) {
                wLLogRecord.setThrown(null);
            }
            super.publish(wLLogRecord);
            super.flush();
        }
    }

    public boolean isLoggable(LogRecord logRecord) {
        if (!this.kmb.isStdoutEnabled()) {
            return false;
        }
        Filter filter = this.getFilter();
        if (filter != null) {
            return filter.isLoggable(logRecord);
        }
        return true;
    }

    public void close() {
    }
}

