/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.TreeMap;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import weblogic.kernel.Kernel;
import weblogic.logging.LogRotationException;
import weblogic.logging.MessageLogger;
import weblogic.logging.WLErrorManager;
import weblogic.logging.WLLevel;
import weblogic.logging.WLLogRecord;
import weblogic.logging.WeblogicLogfileFilter;
import weblogic.management.configuration.LogMBean;
import weblogic.utils.StringUtils;

public final class FileStreamHandler
extends StreamHandler
implements NotificationListener {
    private static final int NUM_OF_DIGITS_IN_SUFFIX = String.valueOf(99999).length();
    private static final String TIME_FORMAT = "k:mm";
    private int curNumFiles;
    private LogMBean logConfig;
    private long nextRotationTime = 0L;
    private boolean logOpened = false;
    private String logFileName = null;
    private String rotatedLogFileName = null;
    private boolean logNeedsRotation = false;
    private boolean logRotationNotified = false;
    private int sizeOffset = 0;
    private static final String LOG_WILL_BE_ROTATED_ID = "170017";
    private static final String LOG_NEEDS_ROTATION_ID = "170018";
    private static final String LOCALIZER_CLASS = "weblogic.i18n.LogMgmtLogLocalizer";
    private static final int FILESIZE_LIMIT = 500000;
    private static final int FILESIZE_OFFSET = 1000;
    static /* synthetic */ Class class$weblogic$logging$FileStreamHandler;
    static /* synthetic */ Class class$weblogic$management$configuration$LogMBean;

    public FileStreamHandler(LogMBean logMBean) {
        this.setErrorManager(new WLErrorManager(this));
        this.logConfig = logMBean;
        Calendar calendar = FileStreamHandler.getCalendar(this.logConfig.getRotationTime());
        this.nextRotationTime = calendar.getTimeInMillis();
        long l = Calendar.getInstance().getTimeInMillis();
        while (this.nextRotationTime <= l) {
            calendar.add(10, this.logConfig.getFileTimeSpan());
            this.nextRotationTime = calendar.getTimeInMillis();
        }
        this.logConfig.addNotificationListener(this, null, null);
        this.setFilter(new Filter(){

            public boolean isLoggable(LogRecord logRecord) {
                if (logRecord == null) {
                    return false;
                }
                return logRecord instanceof WLLogRecord;
            }
        });
        this.setLevel(Level.ALL);
        if (Kernel.isServer() && this.logConfig.getRotationType().equalsIgnoreCase("byTime")) {
            try {
                Class<?> clazz = Class.forName("weblogic.logging.RotateLogTrigger");
                Constructor<?> constructor = clazz.getConstructor(class$weblogic$logging$FileStreamHandler == null ? (class$weblogic$logging$FileStreamHandler = FileStreamHandler.class$("weblogic.logging.FileStreamHandler")) : class$weblogic$logging$FileStreamHandler, class$weblogic$management$configuration$LogMBean == null ? (class$weblogic$management$configuration$LogMBean = FileStreamHandler.class$("weblogic.management.configuration.LogMBean")) : class$weblogic$management$configuration$LogMBean, Long.TYPE);
                Object obj = constructor.newInstance(this, this.logConfig, new Long(this.nextRotationTime));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getFormattedFilename() throws ParseException {
        String string = this.logConfig.getFileName();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("'" + string.replace('%', '\'') + "'");
        String string2 = simpleDateFormat.format(new Date()).toString();
        if (string2.indexOf("'") != -1) {
            string2 = StringUtils.replaceGlobal(string2, "'", "");
        }
        return string2;
    }

    private void open() throws IOException, ParseException {
        File file = new File(this.logFileName);
        FileOutputStream fileOutputStream = new FileOutputStream(file.getCanonicalPath(), true);
        this.setOutputStream(fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord logRecord) {
        if (!(logRecord instanceof WLLogRecord)) {
            logRecord = WLLogRecord.normalizeLogRecord(logRecord);
        }
        WLLogRecord wLLogRecord = (WLLogRecord)logRecord;
        try {
            Object object;
            if (!this.logOpened) {
                this.logFileName = this.getLogFileName();
                object = new File(this.logFileName);
                File file = ((File)object).getParentFile();
                if (file != null) {
                    file.mkdirs();
                }
                if (this.logConfig.getRotateLogOnStartup()) {
                    try {
                        this.rotateLog();
                    }
                    catch (LogRotationException logRotationException) {
                        // empty catch block
                    }
                }
                this.open();
                this.logOpened = true;
            }
            if (this.logNeedsRotation()) {
                object = this;
                synchronized (object) {
                    if (!this.logNeedsRotation && this.logNeedsRotation()) {
                        this.logNeedsRotation = true;
                        this.logRotationNotified = false;
                        FileStreamHandler.logFileWillbeRotated(this.logFileName);
                        this.logRotationNotified = true;
                    }
                    if (this.logNeedsRotation && this.logRotationNotified) {
                        this.rotateLog();
                        this.logNeedsRotation = false;
                        FileStreamHandler.logFileRotated(this.logFileName, this.rotatedLogFileName);
                    }
                }
            }
            super.publish(wLLogRecord);
            super.flush();
        }
        catch (LogRotationException logRotationException) {
            this.sizeOffset += 1000;
        }
        catch (IOException iOException) {
            this.reportError("I/O Error rotating the log file " + this.logFileName, iOException, 4);
        }
        catch (ParseException parseException) {
            this.reportError("Invalid date format log file name " + this.logFileName, parseException, 4);
        }
        catch (Exception exception) {
            String string = "Unknown exception in log file " + this.logFileName;
        }
    }

    private boolean logNeedsRotation() {
        String string = this.logConfig.getRotationType();
        File file = new File(this.logFileName);
        long l = file.length() / 1024L;
        if (l > 500000L) {
            return true;
        }
        if (string.equalsIgnoreCase("bySize") && l >= (long)(this.logConfig.getFileMinSize() + this.sizeOffset)) {
            return true;
        }
        if (string.equalsIgnoreCase("byTime")) {
            long l2 = Calendar.getInstance().getTimeInMillis();
            if (l2 >= this.nextRotationTime) {
                return true;
            }
            if (this.nextRotationTime - l2 <= 36000L) {
                Calendar calendar = Calendar.getInstance();
                Calendar calendar2 = Calendar.getInstance();
                calendar.setTimeInMillis(l2);
                calendar2.setTimeInMillis(this.nextRotationTime);
                if (calendar.get(12) == calendar2.get(12)) {
                    return true;
                }
            }
            return l2 > this.nextRotationTime;
        }
        return false;
    }

    private final void rotateFormattedLog() throws IOException, ParseException {
        int n = 0;
        File file = new File(this.logFileName);
        if (!file.exists()) {
            return;
        }
        this.rotatedLogFileName = file.getCanonicalPath();
        String string = this.getFormattedFilename();
        File file2 = new File(string);
        if (file.equals(file2) || file2.exists()) {
            while ((file2 = new File(string + StringUtils.padNumberWidth(++n, 4))).exists()) {
            }
        }
        this.close();
        if (file2 != null) {
            if (!file.renameTo(file2)) {
                this.open();
                throw new LogRotationException("Error rotating log file " + file.getCanonicalPath());
            }
            this.rotatedLogFileName = file2.getCanonicalPath();
        }
        Calendar calendar = FileStreamHandler.getCalendar(this.logConfig.getRotationTime());
        calendar.add(10, this.logConfig.getFileTimeSpan());
        this.nextRotationTime = calendar.getTimeInMillis();
        FileOutputStream fileOutputStream = new FileOutputStream(file.getCanonicalPath(), true);
        this.setOutputStream(fileOutputStream);
        boolean bl = this.logConfig.isNumberOfFilesLimited();
        int n2 = this.logConfig.getFileCount();
        String string2 = this.logConfig.getFileName();
        File file3 = new File(string2);
        String string3 = file3.getParent();
        String string4 = file3.getName();
        if (string2.indexOf("%") > -1 && !this.logConfig.getRotationType().equalsIgnoreCase("none")) {
            String string5 = string4.substring(0, string4.indexOf("%"));
            WeblogicLogfileFilter weblogicLogfileFilter = new WeblogicLogfileFilter(string5, true);
            File file4 = new File(string3);
            String[] stringArray = file4.list(weblogicLogfileFilter);
            TreeMap<Long, File> treeMap = new TreeMap<Long, File>();
            if (stringArray != null || stringArray.length > 0) {
                int n3;
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    File file5 = new File(file4, stringArray[n3]);
                    treeMap.put(new Long(file5.lastModified()), file5);
                }
                if (bl && stringArray.length > n2) {
                    File file6;
                    n3 = stringArray.length - n2;
                    for (int i = n3 - 1; i >= 0 && !treeMap.isEmpty() && (file6 = (File)treeMap.remove(treeMap.firstKey())).delete(); --i) {
                    }
                }
            }
        }
    }

    private final void rotateLog() throws IOException, ParseException {
        String string = this.logConfig.getFileName();
        if (string.indexOf("%") > -1) {
            this.rotateFormattedLog();
            this.sizeOffset = 0;
            return;
        }
        int n = 0;
        boolean bl = this.logConfig.isNumberOfFilesLimited();
        int n2 = this.logConfig.getFileCount();
        File file = new File(string);
        String string2 = file.getParent();
        if (string2 == null) {
            string2 = System.getProperty("user.dir");
        }
        String string3 = file.getName();
        int n3 = 0;
        TreeMap<Long, File> treeMap = new TreeMap<Long, File>();
        File file2 = new File(string2);
        WeblogicLogfileFilter weblogicLogfileFilter = new WeblogicLogfileFilter(string3);
        String[] stringArray = file2.list(weblogicLogfileFilter);
        if (stringArray == null || stringArray.length == 0) {
            n3 = 1;
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(file2, stringArray[i]);
                treeMap.put(new Long(file3.lastModified()), file3);
            }
        }
        if (!treeMap.isEmpty()) {
            String string4 = ((File)treeMap.get(treeMap.lastKey())).getName();
            int n4 = new Integer(string4.substring(string4.length() - NUM_OF_DIGITS_IN_SUFFIX));
            n3 = n4 == 99999 ? 1 : n4 + 1;
        }
        String string5 = StringUtils.padNumberWidth(n3, NUM_OF_DIGITS_IN_SUFFIX);
        this.close();
        this.rotatedLogFileName = string3 + string5;
        File file4 = new File(string2, this.rotatedLogFileName);
        if (file4.exists() && !file4.delete()) {
            while ((file4 = new File(string3 + StringUtils.padNumberWidth(++n3, NUM_OF_DIGITS_IN_SUFFIX))).exists()) {
            }
        }
        if (file.renameTo(file4)) {
            ++this.curNumFiles;
        } else {
            throw new LogRotationException("Failed to rotate log to " + this.rotatedLogFileName);
        }
        n = n3;
        stringArray = file2.list(weblogicLogfileFilter);
        if (bl && stringArray.length > n2) {
            File file5;
            int n5 = stringArray.length - n2;
            for (int i = n5 - 1; i >= 0 && !treeMap.isEmpty() && (file5 = (File)treeMap.remove(treeMap.firstKey())).delete(); --i) {
            }
        }
        Calendar calendar = FileStreamHandler.getCalendar(this.logConfig.getRotationTime());
        calendar.add(10, this.logConfig.getFileTimeSpan());
        this.nextRotationTime = calendar.getTimeInMillis();
        this.open();
        this.sizeOffset = 0;
    }

    private static Calendar getCalendar(String string) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        if (string == null || string.length() == 0) {
            return calendar2;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT);
        try {
            calendar.setTime(simpleDateFormat.parse(string));
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            if (calendar.before(calendar2)) {
                calendar2.set(12, calendar.get(12));
                calendar2.set(13, calendar2.getMinimum(13));
                return calendar2;
            }
        }
        catch (ParseException parseException) {
            return calendar2;
        }
        return calendar;
    }

    public void handleNotification(Notification notification, Object object) {
        String string = null;
        if (notification instanceof AttributeChangeNotification) {
            String string2 = ((AttributeChangeNotification)notification).getAttributeName();
            if (string2.indexOf("RotationType") > -1) {
                string = ((AttributeChangeNotification)notification).getNewValue().toString();
            }
            if (string2.indexOf("RotationTime") != -1) {
                Calendar calendar = FileStreamHandler.getCalendar(this.logConfig.getRotationTime());
                calendar.add(10, this.logConfig.getFileTimeSpan());
                this.nextRotationTime = calendar.getTimeInMillis();
            } else if (string2.indexOf("FileTimeSpan") != -1) {
                Integer n = (Integer)((AttributeChangeNotification)notification).getOldValue();
                Integer n2 = (Integer)((AttributeChangeNotification)notification).getNewValue();
                Calendar calendar = FileStreamHandler.getCalendar(this.logConfig.getRotationTime());
                calendar.add(10, n * -1);
                calendar.add(10, n2);
                this.nextRotationTime = calendar.getTimeInMillis();
            }
        }
    }

    public String toString() {
        try {
            File file = new File(this.getLogFileName());
            return file.getCanonicalPath();
        }
        catch (ParseException parseException) {
            return this.logConfig.getFileName();
        }
        catch (IOException iOException) {
            return this.logConfig.getFileName();
        }
    }

    private String getLogFileName() throws ParseException {
        this.logFileName = this.logConfig.getFileName();
        if (this.logFileName.indexOf("%") > -1 && !this.logConfig.getRotationType().equalsIgnoreCase("none")) {
            this.getFormattedFilename();
        }
        this.logFileName = StringUtils.replaceGlobal(this.logFileName, "%", "");
        return this.logFileName;
    }

    private static String logFileWillbeRotated(String string) {
        Object[] objectArray = new Object[]{string};
        try {
            MessageLogger.log(LOG_WILL_BE_ROTATED_ID, objectArray, LOCALIZER_CLASS);
        }
        catch (MissingResourceException missingResourceException) {
            MessageLogger.log(WLLevel.ALERT, "Log Management", "Log file " + string + " will be rotated");
        }
        return LOG_WILL_BE_ROTATED_ID;
    }

    private static String logFileRotated(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        try {
            MessageLogger.log(LOG_NEEDS_ROTATION_ID, objectArray, LOCALIZER_CLASS);
        }
        catch (MissingResourceException missingResourceException) {
            MessageLogger.log(WLLevel.ALERT, "Log Management", "Log file has been rotated to " + string2 + ". Log messages will continue to be logged in " + string);
        }
        return LOG_NEEDS_ROTATION_ID;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

