/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import weblogic.i18n.Localizer;
import weblogic.i18ntools.L10nLookup;

public class LoggingTextFormatter {
    private Localizer l10n;
    private boolean format = false;

    public LoggingTextFormatter() {
        this.l10n = L10nLookup.getLocalizer(Locale.getDefault(), "weblogic.logging.LoggingTextLocalizer");
    }

    public LoggingTextFormatter(Locale locale) {
        this.l10n = L10nLookup.getLocalizer(locale, "weblogic.logging.LoggingTextLocalizer");
    }

    public static LoggingTextFormatter getInstance() {
        return new LoggingTextFormatter();
    }

    public static LoggingTextFormatter getInstance(Locale locale) {
        return new LoggingTextFormatter(locale);
    }

    public void setExtendedFormat(boolean bl) {
        this.format = bl;
    }

    public boolean getExtendedFormat() {
        return this.format;
    }

    public String getTextEmergency() {
        String string = "";
        String string2 = "emergency";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }

    public String getTextAlert() {
        String string = "";
        String string2 = "alert";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }

    public String getTextCritical() {
        String string = "";
        String string2 = "critical";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }

    public String getTextNotice() {
        String string = "";
        String string2 = "notice";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }

    public String getTextError() {
        String string = "";
        String string2 = "error";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }

    public String getTextWarning() {
        String string = "";
        String string2 = "warning";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }

    public String getTextInfo() {
        String string = "";
        String string2 = "info";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }

    public String getTextDebug() {
        String string = "";
        String string2 = "debug";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }

    public String consoleSeverityControlHint(String string, String string2) {
        String string3 = "";
        String string4 = "consoleSeverityControlHint";
        String string5 = "Logging";
        Object[] objectArray = new Object[]{string, string2};
        String string6 = MessageFormat.format(this.l10n.get(string4), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string3 = "<" + dateFormat.format(new Date()) + "><" + string5 + "><" + string4 + "> ";
        }
        return string3 + string6;
    }

    public String someConsoleSeverity2Console(String string) {
        String string2 = "";
        String string3 = "someConsoleSeverity2Console";
        String string4 = "Logging";
        Object[] objectArray = new Object[]{string};
        String string5 = MessageFormat.format(this.l10n.get(string3), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string2 = "<" + dateFormat.format(new Date()) + "><" + string4 + "><" + string3 + "> ";
        }
        return string2 + string5;
    }

    public String someConsoleSeverity2Log(String string) {
        String string2 = "";
        String string3 = "someConsoleSeverity2Log";
        String string4 = "Logging";
        Object[] objectArray = new Object[]{string};
        String string5 = MessageFormat.format(this.l10n.get(string3), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string2 = "<" + dateFormat.format(new Date()) + "><" + string4 + "><" + string3 + "> ";
        }
        return string2 + string5;
    }

    public String everyConsoleSeverity2Console() {
        String string = "";
        String string2 = "everyConsoleSeverity2Console";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }

    public String everyConsoleSeverity2Log() {
        String string = "";
        String string2 = "everyConsoleSeverity2Log";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }

    public String noConsoleSeverity2Console() {
        String string = "";
        String string2 = "noConsoleSeverity2Console";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }

    public String noConsoleSeverity2Log() {
        String string = "";
        String string2 = "noConsoleSeverity2Log";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }

    public String getDomainLoggerDoesNotExistMsg() {
        String string = "";
        String string2 = "domainLoggerDoesNotExist";
        String string3 = "Logging";
        Object[] objectArray = new Object[]{};
        String string4 = MessageFormat.format(this.l10n.get(string2), objectArray);
        if (this.getExtendedFormat()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
            string = "<" + dateFormat.format(new Date()) + "><" + string3 + "><" + string2 + "> ";
        }
        return string + string4;
    }
}

