/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.io.Serializable;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import weblogic.i18n.Localizer;
import weblogic.i18ntools.L10nLookup;
import weblogic.kernel.Kernel;
import weblogic.logging.WLLevel;
import weblogic.logging.WLLogRecord;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public final class MessageLogger {
    private static final AbstractSubject kernelID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    public static final boolean USE_PREFIX = true;
    private static boolean usePrefix = true;
    private static final String PREFIX_PROP = "weblogic.MessageIdPrefixEnabled";
    static /* synthetic */ Class class$java$util$logging$Level;
    static /* synthetic */ Class class$java$lang$String;

    public static void log(String string, Object[] objectArray, String string2) {
        WLLogRecord wLLogRecord = MessageLogger.createLogRecord(Level.OFF, null);
        wLLogRecord.setParameters(objectArray);
        String string3 = string;
        Localizer localizer = null;
        try {
            String string4;
            Serializable serializable;
            localizer = L10nLookup.getLocalizer(Locale.getDefault(), string2);
            if (usePrefix) {
                try {
                    serializable = new Integer(string);
                    string4 = localizer.getPrefix();
                    if (string4 != null) {
                        string3 = string4 + "-" + string;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            wLLogRecord.setId(string3);
            serializable = WLLevel.getLevel(localizer.getSeverity(string3));
            wLLogRecord.setLevel((Level)serializable);
            wLLogRecord.setLoggerName(localizer.getSubSystem());
            string4 = localizer.getBody(string3);
            wLLogRecord.setMessage(MessageFormat.format(string4, objectArray));
            wLLogRecord.setParameters(objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            wLLogRecord.setLoggerName("Unknown");
            wLLogRecord.setMessage("Message text not found - " + missingResourceException.getMessage());
        }
        if (localizer == null || localizer.getStackTrace(string3)) {
            wLLogRecord.setThrown(MessageLogger.getThrowable(objectArray));
        }
        Kernel.getLogger().log(wLLogRecord);
    }

    private static Throwable getThrowable(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        if (n > 0 && objectArray[n - 1] instanceof Throwable) {
            return (Throwable)objectArray[n - 1];
        }
        return null;
    }

    public static void log(Level level, String string, String string2) {
        MessageLogger.log(level, string, string2, null);
    }

    public static void log(Level level, String string, String string2, Throwable throwable) {
        WLLogRecord wLLogRecord = MessageLogger.createLogRecord(level, string2);
        wLLogRecord.setLoggerName(string);
        wLLogRecord.setThrown(throwable);
        Kernel.getLogger().log(wLLogRecord);
    }

    static WLLogRecord createLogRecord(Level level, String string) {
        if (!Kernel.isServer()) {
            return new WLLogRecord(level, string);
        }
        WLLogRecord wLLogRecord = null;
        try {
            Class<?> clazz = Class.forName("weblogic.logging.WLServerLogRecord");
            Class[] classArray = new Class[]{class$java$util$logging$Level == null ? (class$java$util$logging$Level = MessageLogger.class$("java.util.logging.Level")) : class$java$util$logging$Level, class$java$lang$String == null ? (class$java$lang$String = MessageLogger.class$("java.lang.String")) : class$java$lang$String};
            Object[] objectArray = new Object[]{level, string};
            wLLogRecord = (WLLogRecord)clazz.getConstructor(classArray).newInstance(objectArray);
        }
        catch (Exception exception) {
            wLLogRecord = new WLLogRecord(level, string);
        }
        return wLLogRecord;
    }

    public static void setUsePrefix(boolean bl) {
        usePrefix = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string = System.getProperty(PREFIX_PROP);
            if (string != null) {
                MessageLogger.setUsePrefix(Boolean.getBoolean(PREFIX_PROP));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

