/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.util.Locale;
import weblogic.logging.LoggingTextFormatter;
import weblogic.logging.Severities;

public final class SeverityI18N
extends Severities {
    private static LoggingTextFormatter tform1;
    private static LoggingTextFormatter tform2;
    private static String lang1;
    private static String lang2;

    public static String severityNumToString(int n, Locale locale) {
        String string = locale.getLanguage();
        if ("en".equals(string)) {
            switch (n) {
                case 1: {
                    return "Emergency";
                }
                case 2: {
                    return "Alert";
                }
                case 4: {
                    return "Critical";
                }
                case 8: {
                    return "Notice";
                }
                case 16: {
                    return "Error";
                }
                case 32: {
                    return "Warning";
                }
                case 64: {
                    return "Info";
                }
                case 128: {
                    return "Debug";
                }
            }
            return "Unknown";
        }
        LoggingTextFormatter loggingTextFormatter = SeverityI18N.quicklyGetLTForm(locale, string);
        switch (n) {
            case 1: {
                return loggingTextFormatter.getTextEmergency();
            }
            case 2: {
                return loggingTextFormatter.getTextAlert();
            }
            case 4: {
                return loggingTextFormatter.getTextCritical();
            }
            case 8: {
                return loggingTextFormatter.getTextNotice();
            }
            case 16: {
                return loggingTextFormatter.getTextError();
            }
            case 32: {
                return loggingTextFormatter.getTextWarning();
            }
            case 64: {
                return loggingTextFormatter.getTextInfo();
            }
            case 128: {
                return loggingTextFormatter.getTextDebug();
            }
        }
        return "Unknown";
    }

    public static int severityStringToNum(String string, Locale locale) {
        String string2 = locale.getLanguage();
        if ("en".equals(string2)) {
            if (string.equalsIgnoreCase("Emergency")) {
                return 1;
            }
            if (string.equalsIgnoreCase("Alert")) {
                return 2;
            }
            if (string.equalsIgnoreCase("Critical")) {
                return 4;
            }
            if (string.equalsIgnoreCase("Notice")) {
                return 8;
            }
            if (string.equalsIgnoreCase("Error")) {
                return 16;
            }
            if (string.equalsIgnoreCase("Warning")) {
                return 32;
            }
            if (string.equalsIgnoreCase("Info")) {
                return 64;
            }
            if (string.equalsIgnoreCase("Debug")) {
                return 128;
            }
            return 0;
        }
        LoggingTextFormatter loggingTextFormatter = SeverityI18N.quicklyGetLTForm(locale, string2);
        if (string.equalsIgnoreCase(loggingTextFormatter.getTextEmergency())) {
            return 1;
        }
        if (string.equalsIgnoreCase(loggingTextFormatter.getTextAlert())) {
            return 2;
        }
        if (string.equalsIgnoreCase(loggingTextFormatter.getTextCritical())) {
            return 4;
        }
        if (string.equalsIgnoreCase(loggingTextFormatter.getTextNotice())) {
            return 8;
        }
        if (string.equalsIgnoreCase(loggingTextFormatter.getTextError())) {
            return 16;
        }
        if (string.equalsIgnoreCase(loggingTextFormatter.getTextWarning())) {
            return 32;
        }
        if (string.equalsIgnoreCase(loggingTextFormatter.getTextInfo())) {
            return 64;
        }
        if (string.equalsIgnoreCase(loggingTextFormatter.getTextDebug())) {
            return 128;
        }
        return 0;
    }

    private static LoggingTextFormatter quicklyGetLTForm(Locale locale, String string) {
        if (lang1 != null && lang1.equals(string)) {
            return tform1;
        }
        if (lang2 != null && lang2.equals(string)) {
            return tform2;
        }
        LoggingTextFormatter loggingTextFormatter = new LoggingTextFormatter(locale);
        if (lang1 == null) {
            lang1 = string;
            tform1 = loggingTextFormatter;
        } else if (lang2 == null) {
            lang2 = string;
            tform2 = loggingTextFormatter;
        } else {
            lang1 = string;
            tform1 = loggingTextFormatter;
        }
        return loggingTextFormatter;
    }
}

