/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.util.logging.ErrorManager;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import weblogic.logging.ConsoleFormatter;
import weblogic.logging.MessageLogger;
import weblogic.logging.WLLevel;
import weblogic.logging.WLLogRecord;

public class WLErrorManager
extends ErrorManager {
    private final Handler handler;
    private static final int EXCEPTION_TOLERANCE_LIMIT = 5;
    private int exceptionsEncountered = 0;
    static final String SUBSYSTEM = "Logging";
    private Logger errorLogger = null;

    public WLErrorManager(Handler handler) {
        this.handler = handler;
        this.errorLogger = Logger.getAnonymousLogger();
        this.errorLogger.addHandler(new StreamHandler(System.err, new ConsoleFormatter()));
    }

    public synchronized void error(String string, Exception exception, int n) {
        ++this.exceptionsEncountered;
        WLLogRecord wLLogRecord = null;
        if (this.exceptionsEncountered > 5 || n == 4) {
            this.handler.setLevel(Level.OFF);
            wLLogRecord = MessageLogger.createLogRecord(WLLevel.CRITICAL, "Handler: '" + this.handler.toString() + "' reported critical error(s). Shutting it down.");
        } else {
            wLLogRecord = MessageLogger.createLogRecord(WLLevel.ERROR, "Handler: '" + this.handler.toString() + "' raised exception" + WLErrorManager.codeToDesc(n) + ".");
        }
        wLLogRecord.setThrown(exception);
        wLLogRecord.setLoggerName(SUBSYSTEM);
        this.errorLogger.log(wLLogRecord);
    }

    private static String codeToDesc(int n) {
        switch (n) {
            case 1: {
                return " when writing";
            }
            case 2: {
                return " when flushing";
            }
            case 3: {
                return " when closing";
            }
            case 4: {
                return " when opening";
            }
            case 5: {
                return " when formatting";
            }
        }
        return "";
    }
}

