/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.util.Locale;
import java.util.logging.Level;
import weblogic.kernel.Kernel;
import weblogic.logging.Severities;
import weblogic.logging.SeverityI18N;

public class WLLevel
extends Level {
    public static final WLLevel EMERGENCY = new WLLevel("EMERGENCY", 1090, 1);
    public static final WLLevel CRITICAL = new WLLevel("CRITICAL", 1060, 4);
    public static final WLLevel ERROR = new WLLevel("ERROR", 1030, 16);
    public static final WLLevel ALERT = new WLLevel("ALERT", 930, 2);
    public static final WLLevel NOTICE = new WLLevel("NOTICE", 830, 8);
    public static final WLLevel DEBUG = new WLLevel("DEBUG", 530, 128);
    public static final WLLevel WARNING = new WLLevel("Warning", 901, 32);
    public static final WLLevel INFO = new WLLevel("Info", 801, 64);
    private final int severity;
    private final String localizedName;

    protected WLLevel(String string, int n, int n2) {
        super(string, n);
        this.severity = n2;
        this.localizedName = !Kernel.isServer() ? Severities.severityNumToString(n2) : SeverityI18N.severityNumToString(n2, Locale.getDefault());
    }

    protected String getHeader(Level level) {
        int n = WLLevel.getSeverity(level);
        if (!Kernel.isServer()) {
            return Severities.severityNumToString(n);
        }
        return SeverityI18N.severityNumToString(n, Locale.getDefault());
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public static Level getLevel(int n) {
        switch (n) {
            case 1: {
                return EMERGENCY;
            }
            case 2: {
                return ALERT;
            }
            case 4: {
                return CRITICAL;
            }
            case 8: {
                return NOTICE;
            }
            case 16: {
                return ERROR;
            }
            case 32: {
                return WARNING;
            }
            case 64: {
                return INFO;
            }
            case 128: {
                return DEBUG;
            }
        }
        return OFF;
    }

    public static int getSeverity(Level level) {
        if (level == EMERGENCY) {
            return 1;
        }
        if (level == ALERT) {
            return 2;
        }
        if (level == CRITICAL) {
            return 4;
        }
        if (level == NOTICE) {
            return 8;
        }
        if (level == ERROR) {
            return 16;
        }
        if (level == WARNING) {
            return 32;
        }
        if (level == INFO) {
            return 64;
        }
        if (level == DEBUG) {
            return 128;
        }
        return 64;
    }
}

