/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import weblogic.logging.MessageLogger;
import weblogic.logging.WLLevel;

public class WLLogRecord
extends LogRecord {
    private static final String DEFAULT_ID = "000000";
    private static final String DEFAULT_SUBSYSTEM = "Default";
    private static WeakHashMap normalizedCache = new WeakHashMap();
    private static final long serialVersionUID = -8930788966766077378L;
    private String id;
    private String machineName;
    private String serverName;
    private String threadId = Thread.currentThread().getName();
    private String userId;
    private String transactionId;

    public WLLogRecord(Level level, String string) {
        super(level, string);
    }

    public WLLogRecord(Level level, String string, Throwable throwable) {
        this(level, string);
        this.setThrown(throwable);
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        if (this.id == null) {
            return DEFAULT_ID;
        }
        return this.id;
    }

    public void setMachineName(String string) {
        this.machineName = string;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setThreadName(String string) {
        this.threadId = string;
    }

    public String getThreadName() {
        return this.threadId;
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setTransactionId(String string) {
        this.transactionId = string;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WLLogRecord normalizeLogRecord(LogRecord logRecord) {
        if (logRecord instanceof WLLogRecord) {
            return (WLLogRecord)logRecord;
        }
        WLLogRecord wLLogRecord = null;
        Object object = normalizedCache;
        synchronized (object) {
            wLLogRecord = (WLLogRecord)normalizedCache.get(logRecord);
        }
        if (wLLogRecord != null) {
            return wLLogRecord;
        }
        object = WLLevel.INFO;
        int n = logRecord.getLevel().intValue();
        object = n >= WLLevel.EMERGENCY.intValue() ? WLLevel.EMERGENCY : (n >= WLLevel.CRITICAL.intValue() ? WLLevel.CRITICAL : (n >= WLLevel.ERROR.intValue() ? WLLevel.ERROR : (n >= WLLevel.ALERT.intValue() ? WLLevel.ALERT : (n >= WLLevel.WARNING.intValue() - 1 ? WLLevel.WARNING : (n >= WLLevel.NOTICE.intValue() ? WLLevel.NOTICE : (n >= WLLevel.INFO.intValue() - 1 ? WLLevel.INFO : WLLevel.DEBUG))))));
        wLLogRecord = MessageLogger.createLogRecord((Level)object, logRecord.getMessage());
        wLLogRecord.setLoggerName(DEFAULT_SUBSYSTEM);
        wLLogRecord.setMillis(logRecord.getMillis());
        wLLogRecord.setParameters(logRecord.getParameters());
        wLLogRecord.setResourceBundle(logRecord.getResourceBundle());
        wLLogRecord.setResourceBundleName(logRecord.getResourceBundleName());
        wLLogRecord.setSequenceNumber(logRecord.getSequenceNumber());
        wLLogRecord.setSourceClassName(logRecord.getSourceClassName());
        wLLogRecord.setSourceMethodName(logRecord.getSourceMethodName());
        wLLogRecord.setThreadID(logRecord.getThreadID());
        wLLogRecord.setThrown(logRecord.getThrown());
        WeakHashMap weakHashMap = normalizedCache;
        synchronized (weakHashMap) {
            normalizedCache.put(logRecord, wLLogRecord);
        }
        return wLLogRecord;
    }
}

