/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.io.File;
import java.io.FilenameFilter;

public final class WeblogicLogfileFilter
implements FilenameFilter {
    private String wlsLogfile;
    private boolean isDateBasedName = false;
    private static final int NUM_OF_DIGITS_IN_SUFFIX = String.valueOf(99999).length();

    public WeblogicLogfileFilter(String string) {
        this.wlsLogfile = string;
    }

    public WeblogicLogfileFilter(String string, boolean bl) {
        this.wlsLogfile = string;
        this.isDateBasedName = bl;
    }

    public boolean accept(File file, String string) {
        int n = this.wlsLogfile.length();
        if (this.isDateBasedName && string.startsWith(this.wlsLogfile)) {
            return true;
        }
        if (!string.startsWith(this.wlsLogfile) || string.length() != n + NUM_OF_DIGITS_IN_SUFFIX) {
            return false;
        }
        for (int i = 0; i < NUM_OF_DIGITS_IN_SUFFIX; ++i) {
            if (string.charAt(n + i) >= '0' && string.charAt(n + i) <= '9') continue;
            return false;
        }
        return true;
    }
}

