/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import weblogic.utils.NestedException;

public abstract class DistributedUpdateException
extends NestedException {
    private ObjectName remoteName;
    private MBeanServer remoteMBeanServer;

    public DistributedUpdateException(ObjectName objectName, MBeanServer mBeanServer, Exception exception) {
        super(exception);
        this.remoteName = objectName;
        this.remoteMBeanServer = mBeanServer;
    }

    public ObjectName getRemoteName() {
        return this.remoteName;
    }

    public MBeanServer getRemoteMBeanServer() {
        return this.remoteMBeanServer;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    public void printStackTrace(PrintWriter printWriter) {
        this.printExceptionInfo(printWriter);
        printWriter.println("Distributed update exception");
        printWriter.println("- remote object: " + this.getRemoteName());
        printWriter.println("- remote server: " + this.getRemoteMBeanServer());
        super.printStackTrace(printWriter);
    }

    public void printExceptionInfo(PrintWriter printWriter) {
        printWriter.println("Distributed update exception");
        printWriter.println("- remote object: " + this.getRemoteName());
        printWriter.println("- remote server: " + this.getRemoteMBeanServer());
    }
}

